/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.soap;

import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.interceptor.Fault;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SoapFault
extends Fault {
    public static final QName ATTACHMENT_IO = new QName("http://www.w3.org/2003/05/soap-envelope", "AttachmentIOError");
    private QName subCode;
    private String role;
    private String node;
    private Map<String, String> namespaces = new HashMap<String, String>();

    public SoapFault(Message message, Throwable throwable2, QName faultCode) {
        super(message, throwable2, faultCode);
    }

    public SoapFault(Message message, QName faultCode) {
        super(message, faultCode);
    }

    public SoapFault(String message, QName faultCode) {
        super(new Message(message, (ResourceBundle)null, new Object[0]), faultCode);
    }

    public SoapFault(String message, ResourceBundle bundle, QName faultCode) {
        super(new Message(message, bundle, new Object[0]), faultCode);
    }

    public SoapFault(String message, ResourceBundle bundle, Throwable t2, QName faultCode) {
        super(new Message(message, bundle, new Object[0]), t2, faultCode);
    }

    public SoapFault(String message, ResourceBundle bundle, QName faultCode, Object ... params2) {
        super(new Message(message, bundle, params2), faultCode);
    }

    public SoapFault(String message, Throwable t2, QName faultCode) {
        super(new Message(message, (ResourceBundle)null, new Object[0]), t2, faultCode);
    }

    public String getCodeString(String prefix2, String defaultPrefix) {
        return this.getFaultCodeString(prefix2, defaultPrefix, this.getFaultCode());
    }

    public String getSubCodeString(String prefix2, String defaultPrefix) {
        return this.getFaultCodeString(prefix2, defaultPrefix, this.subCode);
    }

    private String getFaultCodeString(String prefix2, String defaultPrefix, QName fCode) {
        String codePrefix = null;
        if (StringUtils.isEmpty(prefix2)) {
            codePrefix = fCode.getPrefix();
            if (StringUtils.isEmpty(codePrefix)) {
                codePrefix = defaultPrefix;
            }
        } else {
            codePrefix = prefix2;
        }
        return codePrefix + ":" + fCode.getLocalPart();
    }

    public String getReason() {
        return this.getMessage();
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String actor2) {
        this.role = actor2;
    }

    public String getNode() {
        return this.node;
    }

    public void setNode(String n) {
        this.node = n;
    }

    public QName getSubCode() {
        return this.subCode;
    }

    public void setSubCode(QName subCode) {
        this.subCode = subCode;
    }

    public Map<String, String> getNamespaces() {
        return this.namespaces;
    }

    public void setNamespaces(Map<String, String> namespaces) {
        this.namespaces = namespaces;
    }

    public static SoapFault createFault(Fault f2, SoapVersion v) {
        if (f2 instanceof SoapFault) {
            if (f2.getFaultCode().getNamespaceURI().equals(Fault.FAULT_CODE_CLIENT.getNamespaceURI())) {
                QName fc = f2.getFaultCode();
                if (Fault.FAULT_CODE_CLIENT.equals(fc)) {
                    fc = v.getSender();
                } else if (Fault.FAULT_CODE_SERVER.equals(fc)) {
                    fc = v.getReceiver();
                }
                f2.setFaultCode(fc);
            }
            return (SoapFault)f2;
        }
        QName fc = f2.getFaultCode();
        if (Fault.FAULT_CODE_CLIENT.equals(fc)) {
            fc = v.getSender();
        } else if (Fault.FAULT_CODE_SERVER.equals(fc)) {
            fc = v.getReceiver();
        }
        SoapFault soapFault = new SoapFault(new Message(f2.getMessage(), (ResourceBundle)null, new Object[0]), f2.getCause(), fc);
        soapFault.setDetail(f2.getDetail());
        return soapFault;
    }
}

