/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.soap;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.Soap11;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.headers.Header;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SoapMessage
extends MessageImpl {
    private SoapVersion version;

    public SoapMessage(Message message) {
        super(message);
        this.version = Soap11.getInstance();
    }

    public SoapMessage(SoapVersion ver) {
        this.version = ver;
    }

    public SoapVersion getVersion() {
        return this.version;
    }

    public void setVersion(SoapVersion v) {
        this.version = v;
    }

    public List<Header> getHeaders() {
        List<Header> heads2 = CastUtils.cast((List)this.get(Header.HEADER_LIST));
        if (heads2 == null) {
            heads2 = new ArrayList<Header>();
            this.put(Header.HEADER_LIST, (Object)heads2);
        }
        return heads2;
    }

    public boolean hasHeader(QName qn) {
        for (Header head2 : this.getHeaders()) {
            if (!head2.getName().equals(qn)) continue;
            return true;
        }
        return false;
    }

    public Header getHeader(QName qn) {
        for (Header head2 : this.getHeaders()) {
            if (!head2.getName().equals(qn)) continue;
            return head2;
        }
        return null;
    }

    public boolean hasHeaders() {
        return this.containsKey(Header.HEADER_LIST) && this.getHeaders().size() > 0;
    }

    public Map<String, String> getEnvelopeNs() {
        return CastUtils.cast((Map)this.getContextualProperty("soap.env.ns.map"));
    }

    public boolean hasAdditionalEnvNs() {
        Map<String, String> ns = this.getEnvelopeNs();
        return ns != null && !ns.isEmpty();
    }
}

