/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.soap;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.factory.WSDLFactory;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.binding.soap.Soap12;
import org.apache.cxf.binding.soap.model.SoapBindingInfo;
import org.apache.cxf.binding.soap.tcp.SoapTcpDestination;
import org.apache.cxf.binding.soap.tcp.TCPConduit;
import org.apache.cxf.binding.soap.wsdl11.SoapAddressPlugin;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.AbstractPropertiesHolder;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.tools.common.extensions.soap.SoapAddress;
import org.apache.cxf.tools.util.SOAPBindingUtil;
import org.apache.cxf.transport.AbstractTransportFactory;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.ConduitInitiatorManager;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.DestinationFactoryManager;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.wsdl11.WSDLEndpointFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NoJSR250Annotations(unlessNull={"bus"})
public class SoapTransportFactory
extends AbstractTransportFactory
implements DestinationFactory,
WSDLEndpointFactory,
ConduitInitiator {
    public static final String SOAP_11_HTTP_BINDING = "http://schemas.xmlsoap.org/soap/http";
    public static final String SOAP_12_HTTP_BINDING = "http://www.w3.org/2003/05/soap/bindings/HTTP/";
    public static final String TRANSPORT_ID = "http://schemas.xmlsoap.org/soap/";
    public static final List<String> DEFAULT_NAMESPACES = Arrays.asList("http://schemas.xmlsoap.org/soap/", "http://schemas.xmlsoap.org/wsdl/soap/", "http://schemas.xmlsoap.org/wsdl/soap12/", "http://schemas.xmlsoap.org/soap/http/", "http://schemas.xmlsoap.org/wsdl/soap/http", "http://www.w3.org/2010/soapjms/", "http://www.w3.org/2003/05/soap/bindings/HTTP/", "http://schemas.xmlsoap.org/soap/http");

    public SoapTransportFactory() {
        super(DEFAULT_NAMESPACES, null);
    }

    public SoapTransportFactory(Bus b) {
        super(DEFAULT_NAMESPACES, b);
    }

    @Override
    public Set<String> getUriPrefixes() {
        return Collections.singleton("soap.tcp");
    }

    public String mapTransportURI(String s2, String address) {
        if ("http://www.w3.org/2010/soapjms/".equals(s2) || address != null && address.startsWith("jms")) {
            s2 = "http://cxf.apache.org/transports/jms";
        } else if (SOAP_11_HTTP_BINDING.equals(s2) || SOAP_12_HTTP_BINDING.equals(s2) || "http://schemas.xmlsoap.org/wsdl/soap/".equals(s2) || "http://schemas.xmlsoap.org/wsdl/http".equals(s2) || "http://schemas.xmlsoap.org/wsdl/soap/http".equals(s2) || "http://schemas.xmlsoap.org/wsdl/soap/http/".equals(s2) || "http://schemas.xmlsoap.org/wsdl/http/".equals(s2)) {
            s2 = "http://cxf.apache.org/transports/http";
        }
        return s2;
    }

    private boolean isJMSSpecAddress(String address) {
        return address != null && address.startsWith("jms:") && !"jms://".equals(address);
    }

    @Override
    public Destination getDestination(EndpointInfo ei) throws IOException {
        String address = ei.getAddress();
        if (!StringUtils.isEmpty(address) && address.startsWith("soap.tcp")) {
            return new SoapTcpDestination(ei.getTarget(), ei);
        }
        BindingInfo bi = ei.getBinding();
        String transId = ei.getTransportId();
        if (bi instanceof SoapBindingInfo && (transId = ((SoapBindingInfo)bi).getTransportURI()) == null) {
            transId = ei.getTransportId();
        }
        try {
            DestinationFactoryManager mgr = this.bus.getExtension(DestinationFactoryManager.class);
            DestinationFactory destinationFactory = StringUtils.isEmpty(address) || address.startsWith("http") || address.startsWith("jms") || address.startsWith("/") ? mgr.getDestinationFactory(this.mapTransportURI(transId, address)) : mgr.getDestinationFactoryForUri(address);
            return destinationFactory.getDestination(ei);
        }
        catch (BusException e2) {
            IOException ex2 = new IOException("Could not find destination factory for transport " + transId);
            ex2.initCause(e2);
            throw ex2;
        }
    }

    @Override
    public void createPortExtensors(EndpointInfo ei, Service service) {
        if (ei.getBinding() instanceof SoapBindingInfo) {
            SoapBindingInfo bi = (SoapBindingInfo)ei.getBinding();
            this.createSoapExtensors(ei, bi, bi.getSoapVersion() instanceof Soap12);
        }
    }

    private void createSoapExtensors(EndpointInfo ei, SoapBindingInfo bi, boolean isSoap12) {
        try {
            ExtensionRegistry extensionRegistry = WSDLFactory.newInstance().newPopulatedExtensionRegistry();
            SoapAddressPlugin addresser = new SoapAddressPlugin();
            addresser.setExtensionRegistry(extensionRegistry);
            String address = ei.getAddress();
            if (address == null) {
                address = "http://localhost:9090";
            }
            ei.addExtensor(addresser.createExtension(isSoap12, address));
        }
        catch (WSDLException e2) {
            e2.printStackTrace();
        }
    }

    @Override
    public EndpointInfo createEndpointInfo(ServiceInfo serviceInfo, BindingInfo b, List<?> ees) {
        String transportURI = "http://schemas.xmlsoap.org/wsdl/soap/";
        if (b instanceof SoapBindingInfo) {
            SoapBindingInfo sbi = (SoapBindingInfo)b;
            transportURI = sbi.getTransportURI();
        }
        SoapEndpointInfo info2 = new SoapEndpointInfo(serviceInfo, transportURI);
        if (ees != null) {
            for (Object extensor : ees) {
                if (SOAPBindingUtil.isSOAPAddress(extensor)) {
                    SoapAddress sa = SOAPBindingUtil.getSoapAddress(extensor);
                    ((AbstractPropertiesHolder)info2).addExtensor(sa);
                    ((EndpointInfo)info2).setAddress(sa.getLocationURI());
                    if (!this.isJMSSpecAddress(sa.getLocationURI())) continue;
                    info2.setTransportId("http://www.w3.org/2010/soapjms/");
                    continue;
                }
                ((AbstractPropertiesHolder)info2).addExtensor(extensor);
            }
        }
        return info2;
    }

    @Override
    public Conduit getConduit(EndpointInfo ei, EndpointReferenceType target2) throws IOException {
        return this.getConduit(ei);
    }

    @Override
    public Conduit getConduit(EndpointInfo ei) throws IOException {
        String address = ei.getAddress();
        if (!StringUtils.isEmpty(address) && address.startsWith("soap.tcp://")) {
            return new TCPConduit(ei);
        }
        BindingInfo bi = ei.getBinding();
        String transId = ei.getTransportId();
        if (bi instanceof SoapBindingInfo && (transId = ((SoapBindingInfo)bi).getTransportURI()) == null) {
            transId = ei.getTransportId();
        }
        try {
            ConduitInitiatorManager mgr = this.bus.getExtension(ConduitInitiatorManager.class);
            ConduitInitiator conduitInit = StringUtils.isEmpty(address) || address.startsWith("http") || address.startsWith("jms") ? mgr.getConduitInitiator(this.mapTransportURI(transId, address)) : mgr.getConduitInitiatorForUri(address);
            return conduitInit.getConduit(ei);
        }
        catch (BusException e2) {
            throw new RuntimeException("Could not find conduit initiator for transport " + transId);
        }
    }

    @Override
    @Resource(name="cxf")
    public void setBus(Bus bus) {
        super.setBus(bus);
    }

    public void setActivationNamespaces(Collection<String> ans2) {
        super.setTransportIds(new ArrayList<String>(ans2));
    }

    private static class SoapEndpointInfo
    extends EndpointInfo {
        SoapAddress saddress;

        SoapEndpointInfo(ServiceInfo serv, String trans2) {
            super(serv, trans2);
        }

        public void setAddress(String s2) {
            super.setAddress(s2);
            if (this.saddress != null) {
                this.saddress.setLocationURI(s2);
            }
        }

        public void addExtensor(Object el) {
            super.addExtensor(el);
            if (el instanceof SoapAddress) {
                this.saddress = (SoapAddress)el;
            }
        }
    }
}

