/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.soap.interceptor;

import java.util.Set;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.binding.soap.interceptor.ReadHeadersInterceptor;
import org.apache.cxf.binding.soap.model.SoapBindingInfo;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.AbstractEndpointSelectionInterceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.EndpointInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointSelectionInterceptor
extends AbstractEndpointSelectionInterceptor {
    public EndpointSelectionInterceptor() {
        super("read");
        this.getAfter().add(ReadHeadersInterceptor.class.getName());
    }

    @Override
    protected Endpoint selectEndpoint(Message message, Set<Endpoint> eps) {
        SoapVersion sv = ((SoapMessage)message).getVersion();
        for (Endpoint e2 : eps) {
            EndpointInfo ei = e2.getEndpointInfo();
            BindingInfo binding = ei.getBinding();
            if (!(binding instanceof SoapBindingInfo) || !((SoapBindingInfo)binding).getSoapVersion().equals(sv)) continue;
            return e2;
        }
        return null;
    }
}

