/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.soap.interceptor;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.interceptor.ClientFaultConverter;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.staxutils.StaxUtils;
import org.w3c.dom.Element;

public class Soap11FaultInInterceptor
extends AbstractSoapInterceptor {
    public Soap11FaultInInterceptor() {
        super("unmarshal");
        this.addBefore(ClientFaultConverter.class.getName());
    }

    public void handleMessage(SoapMessage message) throws Fault {
        XMLStreamReader reader2 = message.getContent(XMLStreamReader.class);
        message.setContent(Exception.class, Soap11FaultInInterceptor.unmarshalFault(message, reader2));
    }

    public static SoapFault unmarshalFault(SoapMessage message, XMLStreamReader reader2) {
        String exMessage = null;
        QName faultCode = null;
        String role = null;
        Element detail = null;
        try {
            while (reader2.nextTag() == 1) {
                if (reader2.getLocalName().equals("faultcode")) {
                    faultCode = StaxUtils.readQName(reader2);
                    continue;
                }
                if (reader2.getLocalName().equals("faultstring")) {
                    exMessage = reader2.getElementText();
                    continue;
                }
                if (reader2.getLocalName().equals("faultactor")) {
                    role = reader2.getElementText();
                    continue;
                }
                if (!reader2.getLocalName().equals("detail")) continue;
                detail = StaxUtils.read(reader2).getDocumentElement();
            }
        }
        catch (XMLStreamException e2) {
            throw new SoapFault("Could not parse message.", (Throwable)e2, message.getVersion().getSender());
        }
        SoapFault fault = new SoapFault(exMessage, faultCode);
        fault.setDetail(detail);
        fault.setRole(role);
        return fault;
    }
}

