/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.soap.interceptor;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.cxf.binding.soap.Soap11;
import org.apache.cxf.binding.soap.Soap12;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.binding.soap.interceptor.EndpointSelectionInterceptor;
import org.apache.cxf.binding.soap.interceptor.ReadHeadersInterceptor;
import org.apache.cxf.binding.soap.model.SoapOperationInfo;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.OperationInfo;

public class SoapActionInInterceptor
extends AbstractSoapInterceptor {
    public SoapActionInInterceptor() {
        super("read");
        this.addAfter(ReadHeadersInterceptor.class.getName());
        this.addAfter(EndpointSelectionInterceptor.class.getName());
    }

    public static String getSoapAction(Message m) {
        if (!(m instanceof SoapMessage)) {
            return null;
        }
        SoapMessage message = (SoapMessage)m;
        if (message.getVersion() instanceof Soap11) {
            List sa;
            Map headers2 = CastUtils.cast((Map)message.get(Message.PROTOCOL_HEADERS));
            if (headers2 != null && (sa = (List)headers2.get("SOAPAction")) != null && sa.size() > 0) {
                String action2 = (String)sa.get(0);
                if (action2.startsWith("\"")) {
                    action2 = action2.substring(1, action2.length() - 1);
                }
                return action2;
            }
        } else if (message.getVersion() instanceof Soap12) {
            String ct = (String)message.get("Content-Type");
            if (ct == null) {
                return null;
            }
            int start2 = ct.indexOf("action=");
            if (start2 != -1) {
                int end2;
                if (ct.charAt(start2 + 7) == '\"') {
                    end2 = ct.indexOf(34, start2 += 8);
                } else {
                    end2 = ct.indexOf(59, start2 += 7);
                    if (end2 == -1) {
                        end2 = ct.length();
                    }
                }
                return ct.substring(start2, end2);
            }
        }
        return null;
    }

    public void handleMessage(SoapMessage message) throws Fault {
        String action2 = SoapActionInInterceptor.getSoapAction(message);
        if (!StringUtils.isEmpty(action2)) {
            this.getAndSetOperation(message, action2);
        }
    }

    private void getAndSetOperation(SoapMessage message, String action2) {
        if (StringUtils.isEmpty(action2)) {
            return;
        }
        message.put("SOAPAction", (Object)action2);
        Exchange ex2 = message.getExchange();
        Endpoint ep = ex2.get(Endpoint.class);
        BindingOperationInfo bindingOp = null;
        Collection<BindingOperationInfo> bops = ep.getBinding().getBindingInfo().getOperations();
        if (bops == null) {
            return;
        }
        for (BindingOperationInfo boi : bops) {
            SoapOperationInfo soi = boi.getExtensor(SoapOperationInfo.class);
            if (soi == null || !action2.equals(soi.getAction())) continue;
            if (bindingOp != null) {
                return;
            }
            bindingOp = boi;
        }
        if (bindingOp != null) {
            ex2.put(BindingOperationInfo.class, bindingOp);
            ex2.put(OperationInfo.class, bindingOp.getOperationInfo());
        }
    }
}

