/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.soap.interceptor;

import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.RPCInInterceptor;
import org.apache.cxf.binding.soap.model.SoapHeaderInfo;
import org.apache.cxf.headers.Header;
import org.apache.cxf.interceptor.AbstractInDatabindingInterceptor;
import org.apache.cxf.interceptor.BareInInterceptor;
import org.apache.cxf.interceptor.DocLiteralInInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.staxutils.W3CDOMStreamReader;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SoapHeaderInterceptor
extends AbstractInDatabindingInterceptor {
    public SoapHeaderInterceptor() {
        super("unmarshal");
        this.addAfter(BareInInterceptor.class.getName());
        this.addAfter(RPCInInterceptor.class.getName());
        this.addAfter(DocLiteralInInterceptor.class.getName());
    }

    public void handleMessage(Message m) throws Fault {
        boolean client;
        BindingMessageInfo bmi;
        BindingOperationInfo bop;
        SoapMessage message = (SoapMessage)m;
        Exchange exchange = message.getExchange();
        MessageContentsList parameters2 = MessageContentsList.getContentsList(message);
        if (null == parameters2) {
            parameters2 = new MessageContentsList();
        }
        if (null == (bop = exchange.getBindingOperationInfo())) {
            return;
        }
        if (bop.isUnwrapped()) {
            bop = bop.getWrappedOperation();
        }
        BindingMessageInfo bindingMessageInfo = bmi = (client = this.isRequestor(message)) ? bop.getOutput() : bop.getInput();
        if (bmi == null) {
            return;
        }
        List<SoapHeaderInfo> headers2 = bmi.getExtensors(SoapHeaderInfo.class);
        if (headers2 == null || headers2.size() == 0) {
            return;
        }
        boolean supportsNode = this.supportsDataReader(message, Node.class);
        for (SoapHeaderInfo header : headers2) {
            MessagePartInfo mpi = header.getPart();
            if (mpi.getTypeClass() == null) continue;
            Header param2 = this.findHeader(message, mpi);
            Object object = null;
            if (param2 != null) {
                message.getHeaders().remove(param2);
                if (param2.getDataBinding() == null) {
                    Node source = (Node)param2.getObject();
                    if (supportsNode) {
                        object = this.getNodeDataReader(message).read(mpi, source);
                    } else {
                        W3CDOMStreamReader reader2 = new W3CDOMStreamReader((Element)source);
                        try {
                            reader2.nextTag();
                        }
                        catch (XMLStreamException e2) {
                            // empty catch block
                        }
                        object = this.getDataReader(message, XMLStreamReader.class).read(mpi, reader2);
                    }
                } else {
                    object = param2.getObject();
                }
            }
            parameters2.put(mpi, object);
        }
        if (parameters2.size() > 0) {
            message.setContent(List.class, parameters2);
        }
    }

    private Header findHeader(SoapMessage message, MessagePartInfo mpi) {
        return message.getHeader(mpi.getConcreteName());
    }
}

