/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.soap.jms.interceptor;

import java.util.List;
import java.util.Map;
import org.apache.cxf.binding.Binding;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.binding.soap.jms.interceptor.JMSFault;
import org.apache.cxf.binding.soap.jms.interceptor.JMSFaultFactory;
import org.apache.cxf.binding.soap.jms.interceptor.SoapFaultFactory;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.AttachmentInInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SoapJMSInInterceptor
extends AbstractSoapInterceptor {
    public SoapJMSInInterceptor() {
        super("receive");
        this.addAfter(AttachmentInInterceptor.class.getName());
    }

    @Override
    public void handleMessage(SoapMessage message) throws Fault {
        Map<String, List<String>> headers2 = CastUtils.cast((Map)message.get(Message.PROTOCOL_HEADERS));
        if (headers2 != null) {
            this.checkContentType(message, headers2);
            this.checkContentEncoding(message, headers2);
            this.checkRequestURI(message, headers2);
            this.checkSoapAction(message, headers2);
            this.checkBindingVersion(message, headers2);
            this.checkJMSMessageFormat(message, headers2);
        }
    }

    private void checkContentEncoding(SoapMessage message, Map<String, List<String>> headers2) {
        Fault f2;
        String contentEncoding;
        List<String> contentEncodingList = headers2.get("SOAPJMS_contentEncoding");
        JMSFault jmsFault = null;
        if (contentEncodingList != null && contentEncodingList.size() > 0 && !"gzip".equals(contentEncoding = contentEncodingList.get(0))) {
            jmsFault = JMSFaultFactory.createContentEncodingNotSupported(contentEncoding);
        }
        if (jmsFault != null && (f2 = this.createFault(message, jmsFault)) != null) {
            throw f2;
        }
    }

    private void checkJMSMessageFormat(SoapMessage message, Map<String, List<String>> headers2) {
        JMSFault jmsFault;
        Fault f2;
        String messageType;
        List<String> mt = headers2.get("JMSMessageType");
        if (mt != null && mt.size() > 0 && !"text".equals(messageType = mt.get(0)) && !"byte".equals(messageType) && (f2 = this.createFault(message, jmsFault = JMSFaultFactory.createUnsupportedJMSMessageFormatFault(messageType))) != null) {
            throw f2;
        }
    }

    private void checkSoapAction(SoapMessage message, Map<String, List<String>> headers2) {
        Fault f2;
        JMSFault jmsFault = null;
        String soapAction = null;
        String contentType = null;
        String contentTypeAction = null;
        List<String> ct = headers2.get("SOAPJMS_contentType");
        List<String> sa = headers2.get("SOAPJMS_soapAction");
        if (sa != null && sa.size() > 0 && (soapAction = sa.get(0)) != null && soapAction.startsWith("\"")) {
            soapAction = soapAction.substring(1, soapAction.lastIndexOf("\""));
        }
        if (ct != null && ct.size() > 0) {
            contentType = ct.get(0);
        }
        if (contentType != null && contentType.indexOf("action=") != -1) {
            contentTypeAction = contentType.substring(contentType.indexOf("action=") + 7);
            if (contentTypeAction.indexOf(";") != -1) {
                contentTypeAction = contentTypeAction.substring(0, contentTypeAction.indexOf(";"));
            }
            if (contentTypeAction.startsWith("\"")) {
                contentTypeAction = contentTypeAction.substring(1, contentTypeAction.lastIndexOf("\""));
            }
        }
        if (soapAction != null && contentTypeAction != null && !soapAction.equals(contentTypeAction)) {
            jmsFault = JMSFaultFactory.createMismatchedSoapActionFault(contentTypeAction);
        }
        if (jmsFault != null && (f2 = this.createFault(message, jmsFault)) != null) {
            throw f2;
        }
    }

    private void checkRequestURI(SoapMessage message, Map<String, List<String>> headers2) {
        Fault f2;
        List<String> ru = headers2.get("SOAPJMS_requestURI");
        JMSFault jmsFault = null;
        if (ru != null && ru.size() > 0) {
            List<String> trn;
            String requestURI = ru.get(0);
            List<String> mr = headers2.get("malformed.requesturi");
            if (mr != null && mr.size() > 0 && mr.get(0).equals("true")) {
                jmsFault = JMSFaultFactory.createMalformedRequestURIFault(requestURI);
            }
            if ((trn = headers2.get("target.service.inrequesturi")) != null && trn.size() > 0 && trn.get(0).equals("true")) {
                jmsFault = JMSFaultFactory.createTargetServiceNotAllowedInRequestURIFault();
            }
        } else {
            jmsFault = JMSFaultFactory.createMissingRequestURIFault();
        }
        if (jmsFault != null && (f2 = this.createFault(message, jmsFault)) != null) {
            throw f2;
        }
    }

    private void checkContentType(SoapMessage message, Map<String, List<String>> headers2) {
        Fault f2;
        List<String> ct = headers2.get("SOAPJMS_contentType");
        JMSFault jmsFault = null;
        if (ct != null && ct.size() > 0) {
            String contentType = ct.get(0);
            if (!(contentType.startsWith("text/xml") || contentType.startsWith("application/soap+xml") || contentType.startsWith("multipart/related"))) {
                jmsFault = JMSFaultFactory.createContentTypeMismatchFault(contentType);
            }
        } else {
            jmsFault = JMSFaultFactory.createMissingContentTypeFault();
        }
        if (jmsFault != null && (f2 = this.createFault(message, jmsFault)) != null) {
            throw f2;
        }
    }

    private void checkBindingVersion(SoapMessage message, Map<String, List<String>> headers2) {
        JMSFault jmsFault;
        Fault f2;
        String bindingVersion;
        List<String> bv = headers2.get("SOAPJMS_bindingVersion");
        if (bv != null && bv.size() > 0 && !"1.0".equals(bindingVersion = bv.get(0)) && (f2 = this.createFault(message, jmsFault = JMSFaultFactory.createUnrecognizedBindingVerionFault(bindingVersion))) != null) {
            throw f2;
        }
    }

    private Fault createFault(SoapMessage message, JMSFault jmsFault) {
        Fault f2 = null;
        Endpoint e2 = message.getExchange().get(Endpoint.class);
        Binding b = null;
        if (null != e2) {
            b = e2.getBinding();
        }
        if (null != b) {
            SoapFaultFactory sff = new SoapFaultFactory(b);
            f2 = sff.createFault(jmsFault);
        }
        return f2;
    }
}

