/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.soap.tcp;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class DataCodingUtils {
    private DataCodingUtils() {
    }

    public static void readInts4(InputStream inputStream, int[] array2, int count2) throws IOException {
        int value2 = 0;
        int octet = 0;
        int readInts = 0;
        int shVal = 0;
        int neeble = 0;
        int neebleNum = 0;
        while (readInts < count2) {
            if (neebleNum % 2 == 0) {
                octet = inputStream.read();
                if (octet == -1) {
                    throw new EOFException();
                }
                neeble = octet >> 4;
            } else {
                neeble = octet & 0xF;
            }
            value2 |= (neeble & 7) << shVal;
            if ((neeble & 8) == 0) {
                array2[readInts++] = value2;
                shVal = 0;
                value2 = 0;
            } else {
                shVal += 3;
            }
            ++neebleNum;
        }
    }

    public static int readInt8(InputStream inputStream) throws IOException {
        int value2 = 0;
        int shVal = 0;
        int octet = 128;
        while ((octet & 0x80) != 0) {
            octet = inputStream.read();
            if (octet == -1) {
                throw new EOFException();
            }
            value2 |= (octet & 0x7F) << shVal;
            shVal += 7;
        }
        return value2;
    }

    public static void writeInt8(OutputStream outputStream, int intValue) throws IOException {
        int value2 = intValue;
        do {
            int octet = value2 & 0x7F;
            if ((value2 >>>= 7) != 0) {
                octet |= 0x80;
            }
            outputStream.write(octet);
        } while (value2 != 0);
    }

    public static void writeInts4(OutputStream outputStream, int ... values2) throws IOException {
        DataCodingUtils.writeInts4(outputStream, values2, 0, values2.length);
    }

    public static void writeInts4(OutputStream outputStream, int[] array2, int offset2, int count2) throws IOException {
        int shiftValue = 0;
        for (int i = 0; i < count2 - 1; ++i) {
            int value2 = array2[offset2 + i];
            shiftValue = DataCodingUtils.writeInt4(outputStream, value2, shiftValue, false);
        }
        if (count2 > 0) {
            DataCodingUtils.writeInt4(outputStream, array2[offset2 + count2 - 1], shiftValue, true);
        }
    }

    private static int writeInt4(OutputStream outputStream, int intValue, int highValue, boolean flush2) throws IOException {
        int nibbleL;
        int value2 = intValue;
        int hValue = highValue;
        if (hValue > 0) {
            hValue &= 0x70;
            nibbleL = value2 & 7;
            if ((value2 >>>= 3) != 0) {
                nibbleL |= 8;
            }
            outputStream.write(hValue | nibbleL);
            if (value2 == 0) {
                return 0;
            }
        }
        do {
            int nibbleH = (value2 & 7) << 4;
            if ((value2 >>>= 3) != 0) {
                nibbleH |= 0x80;
                nibbleL = value2 & 7;
                if ((value2 >>>= 3) != 0) {
                    nibbleL |= 8;
                }
            } else {
                if (!flush2) {
                    return nibbleH | 0x80;
                }
                nibbleL = 0;
            }
            outputStream.write(nibbleH | nibbleL);
        } while (value2 != 0);
        return 0;
    }
}

