/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.soap.tcp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.soap.tcp.BackendTcpConduit;
import org.apache.cxf.binding.soap.tcp.ChannelService;
import org.apache.cxf.binding.soap.tcp.DataCodingUtils;
import org.apache.cxf.binding.soap.tcp.SoapTcpChannel;
import org.apache.cxf.binding.soap.tcp.SoapTcpCodecFactory;
import org.apache.cxf.binding.soap.tcp.SoapTcpSessionState;
import org.apache.cxf.binding.soap.tcp.frames.SoapTcpMessage;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.AbstractDestination;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.logging.LoggingFilter;
import org.apache.mina.transport.socket.nio.NioSocketAcceptor;

public final class SoapTcpDestination
extends AbstractDestination
implements IoHandler {
    private static final String MAGIC_IDENTIFIER = "vnd.sun.ws.tcp";
    private static final Logger LOG = LogUtils.getL7dLogger(SoapTcpDestination.class);

    public SoapTcpDestination(EndpointReferenceType ref, EndpointInfo ei) throws IOException {
        this(null, ref, ei);
    }

    public SoapTcpDestination(Bus b, EndpointReferenceType ref, EndpointInfo ei) throws IOException {
        super(b, ref, ei);
        String address = ref.getAddress().getValue();
        if (address.contains("soap.tcp://")) {
            int endIndex;
            int beginIndex = address.indexOf("://");
            beginIndex = endIndex = address.indexOf(":", beginIndex + 1);
            endIndex = address.indexOf("/", beginIndex);
            int port = Integer.parseInt(address.substring(beginIndex + 1, endIndex));
            NioSocketAcceptor acceptor = new NioSocketAcceptor();
            acceptor.getFilterChain().addLast("logger", (IoFilter)new LoggingFilter());
            acceptor.getFilterChain().addLast("HighLevelProtocol", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new SoapTcpCodecFactory()));
            acceptor.setDefaultLocalAddress((SocketAddress)new InetSocketAddress(port));
            acceptor.setHandler((IoHandler)this);
            acceptor.bind();
            System.out.println("server is listenig at port " + port);
        }
    }

    protected Conduit getInbuiltBackChannel(Message inMessage) {
        return inMessage.getExchange().getConduit(inMessage);
    }

    protected Logger getLogger() {
        return LOG;
    }

    public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
    }

    public void messageReceived(IoSession session, Object message) throws Exception {
        SoapTcpSessionState sessionState;
        if (message instanceof SoapTcpMessage) {
            BackendTcpConduit conduit = (BackendTcpConduit)session.getAttribute((Object)"conduit");
            if (conduit == null) {
                conduit = new BackendTcpConduit(session);
                session.setAttribute((Object)"conduit", (Object)conduit);
            }
            if (((SoapTcpMessage)message).getChannelId() == 0) {
                ChannelService.service(session, (SoapTcpMessage)message);
            } else {
                MessageImpl msg = new MessageImpl();
                ExchangeImpl exchange = new ExchangeImpl();
                exchange.setConduit(conduit);
                exchange.setDestination(this);
                msg.setExchange(exchange);
                msg.setContent(InputStream.class, ((SoapTcpMessage)message).getContentAsStream());
                msg.setContent(SoapTcpChannel.class, this.getChannel(session, (SoapTcpMessage)message));
                msg.setContent(IoSession.class, session);
                this.incomingObserver.onMessage(msg);
            }
        } else if (message instanceof IoBuffer && (sessionState = (SoapTcpSessionState)session.getAttribute((Object)"sessionState")) != null && sessionState.getStateId() == 0) {
            IoBuffer buffer = (IoBuffer)message;
            InputStream inStream = buffer.asInputStream();
            byte[] magicIdBuffer = new byte[MAGIC_IDENTIFIER.length()];
            inStream.read(magicIdBuffer);
            String magicId = new String(magicIdBuffer, "US-ASCII");
            if (magicId.equals(MAGIC_IDENTIFIER)) {
                int[] version = new int[4];
                DataCodingUtils.readInts4(inStream, version, 4);
                if (version[0] == 1 && version[1] == 0 && version[2] == 1 && version[3] == 0) {
                    sessionState.setStateId((byte)1);
                    IoBuffer response = IoBuffer.allocate((int)2);
                    OutputStream out = response.asOutputStream();
                    DataCodingUtils.writeInts4(out, 1, 0, 1, 0);
                    out.close();
                    response.flip();
                    session.write((Object)response);
                }
            }
        }
    }

    public void messageSent(IoSession session, Object message) throws Exception {
        System.out.println("messageSent");
    }

    public void sessionClosed(IoSession session) throws Exception {
        System.out.println("sessionClosed");
    }

    public void sessionCreated(IoSession session) throws Exception {
        System.out.println("sessionCreated");
    }

    public void sessionIdle(IoSession session, IdleStatus status) throws Exception {
        System.out.println("sessionIdle");
    }

    public void sessionOpened(IoSession session) throws Exception {
        System.out.println("sessionOpened");
        session.setAttribute((Object)"sessionState", (Object)new SoapTcpSessionState());
        ArrayList<SoapTcpChannel> channels = new ArrayList<SoapTcpChannel>();
        SoapTcpChannel channel0 = new SoapTcpChannel(0, "");
        channels.add(channel0);
        session.setAttribute((Object)"channels", channels);
    }

    private SoapTcpChannel getChannel(IoSession session, SoapTcpMessage message) {
        List channels = (List)session.getAttribute((Object)"channels");
        if (channels != null) {
            for (SoapTcpChannel channel : channels) {
                if (channel.getChannelId() != message.getChannelId()) continue;
                return channel;
            }
        }
        return null;
    }
}

