/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.xml.interceptor;

import java.util.ResourceBundle;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.binding.xml.XMLFault;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.helpers.NSStack;
import org.apache.cxf.interceptor.AbstractOutDatabindingInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.staxutils.StaxUtils;
import org.w3c.dom.Node;

public class XMLFaultOutInterceptor
extends AbstractOutDatabindingInterceptor {
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(XMLFaultOutInterceptor.class);

    public XMLFaultOutInterceptor() {
        super("marshal");
    }

    public XMLFaultOutInterceptor(String phase) {
        super(phase);
    }

    public void handleMessage(Message message) throws Fault {
        if (this.mustPropogateException(message)) {
            throw (Fault)message.getContent(Exception.class);
        }
        message.put(Message.RESPONSE_CODE, new Integer(500));
        NSStack nsStack = new NSStack();
        nsStack.push();
        XMLStreamWriter writer = message.getContent(XMLStreamWriter.class);
        Fault f2 = (Fault)message.getContent(Exception.class);
        XMLFault xmlFault = XMLFault.createFault(f2);
        try {
            nsStack.add("http://cxf.apache.org/bindings/xformat");
            String prefix2 = nsStack.getPrefix("http://cxf.apache.org/bindings/xformat");
            StaxUtils.writeStartElement(writer, prefix2, "XMLFault", "http://cxf.apache.org/bindings/xformat");
            StaxUtils.writeStartElement(writer, prefix2, "faultstring", "http://cxf.apache.org/bindings/xformat");
            Throwable t2 = xmlFault.getCause();
            writer.writeCharacters(t2 == null ? xmlFault.getMessage() : t2.toString());
            writer.writeEndElement();
            if (xmlFault.getDetail() != null) {
                StaxUtils.writeStartElement(writer, prefix2, "detail", "http://cxf.apache.org/bindings/xformat");
                StaxUtils.writeNode(DOMUtils.getChild((Node)xmlFault.getDetail(), 1), writer, false);
                writer.writeEndElement();
            }
            writer.writeEndElement();
            writer.flush();
        }
        catch (XMLStreamException xe) {
            throw new Fault(new org.apache.cxf.common.i18n.Message("XML_WRITE_EXC", BUNDLE, new Object[0]), (Throwable)xe);
        }
    }

    public void handleFault(Message message) throws Fault {
        if (this.mustPropogateException(message)) {
            throw (Fault)message.getContent(Exception.class);
        }
    }

    protected boolean mustPropogateException(Message m) {
        return Boolean.TRUE.equals(m.getExchange().get(Message.PROPOGATE_EXCEPTION));
    }
}

