/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.bus.blueprint;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.aries.blueprint.ExtendedBlueprintContainer;
import org.apache.aries.blueprint.container.BeanRecipe;
import org.apache.aries.blueprint.di.Recipe;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.Configurable;
import org.apache.cxf.configuration.Configurer;
import org.osgi.service.blueprint.container.BlueprintContainer;

public class ConfigurerImpl
implements Configurer {
    private static final Logger LOG = LogUtils.getL7dLogger(ConfigurerImpl.class);
    ExtendedBlueprintContainer container;
    private final Map<String, List<MatcherHolder>> wildCardBeanDefinitions = new HashMap<String, List<MatcherHolder>>();

    public ConfigurerImpl(BlueprintContainer con) {
        this.container = (ExtendedBlueprintContainer)con;
        this.initializeWildcardMap();
    }

    private boolean isWildcardBeanName(String bn) {
        return bn.indexOf(42) != -1 || bn.indexOf(63) != -1 || bn.indexOf(40) != -1 && bn.indexOf(41) != -1;
    }

    private void initializeWildcardMap() {
        for (String s2 : this.container.getComponentIds()) {
            Recipe r;
            if (!this.isWildcardBeanName(s2) || !((r = this.container.getRepository().getRecipe(s2)) instanceof BeanRecipe)) continue;
            Class c2 = ((BeanRecipe)r).getType();
            String orig = s2;
            if (s2.charAt(0) == '*') {
                s2 = "." + s2.replaceAll("\\.", "\\.");
            }
            Matcher matcher2 = Pattern.compile(s2).matcher("");
            List<MatcherHolder> m = this.wildCardBeanDefinitions.get(c2.getName());
            if (m == null) {
                m = new ArrayList<MatcherHolder>();
                this.wildCardBeanDefinitions.put(c2.getName(), m);
            }
            MatcherHolder holder = new MatcherHolder(orig, matcher2);
            m.add(holder);
        }
    }

    public void configureBean(Object beanInstance) {
        this.configureBean(null, beanInstance, true);
    }

    public void configureBean(String bn, Object beanInstance) {
        this.configureBean(bn, beanInstance, true);
    }

    public synchronized void configureBean(String bn, Object beanInstance, boolean checkWildcards) {
        Recipe r;
        if (null == bn) {
            bn = this.getBeanName(beanInstance);
        }
        if (null == bn) {
            return;
        }
        if (checkWildcards) {
            this.configureWithWildCard(bn, beanInstance);
        }
        if ((r = this.container.getRepository().getRecipe(bn)) instanceof BeanRecipe) {
            ((BeanRecipe)r).setProperties(beanInstance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureWithWildCard(String bn, Object beanInstance) {
        if (!this.wildCardBeanDefinitions.isEmpty()) {
            Class<?> clazz2 = beanInstance.getClass();
            while (!Object.class.equals(clazz2)) {
                String className = clazz2.getName();
                List<MatcherHolder> matchers = this.wildCardBeanDefinitions.get(className);
                if (matchers != null) {
                    for (MatcherHolder m : matchers) {
                        Matcher matcher2 = m.matcher;
                        synchronized (matcher2) {
                            m.matcher.reset(bn);
                            if (m.matcher.matches()) {
                                this.configureBean(m.wildCardId, beanInstance, false);
                                return;
                            }
                        }
                    }
                }
                clazz2 = clazz2.getSuperclass();
            }
        }
    }

    protected String getBeanName(Object beanInstance) {
        if (beanInstance instanceof Configurable) {
            return ((Configurable)beanInstance).getBeanName();
        }
        String beanName = null;
        Method m = null;
        try {
            m = beanInstance.getClass().getDeclaredMethod("getBeanName", null);
        }
        catch (NoSuchMethodException ex2) {
            try {
                m = beanInstance.getClass().getMethod("getBeanName", null);
            }
            catch (NoSuchMethodException e2) {
                // empty catch block
            }
        }
        if (m != null) {
            try {
                beanName = (String)m.invoke(beanInstance, new Object[0]);
            }
            catch (Exception ex3) {
                LogUtils.log(LOG, Level.WARNING, "ERROR_DETERMINING_BEAN_NAME_EXC", ex3);
            }
        }
        if (null == beanName) {
            LogUtils.log(LOG, Level.FINE, "COULD_NOT_DETERMINE_BEAN_NAME_MSG", beanInstance.getClass().getName());
        }
        return beanName;
    }

    static class MatcherHolder {
        Matcher matcher;
        String wildCardId;

        public MatcherHolder(String orig, Matcher matcher2) {
            this.wildCardId = orig;
            this.matcher = matcher2;
        }
    }
}

