/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.bus.extension;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.apache.cxf.bus.extension.Extension;
import org.apache.cxf.bus.extension.ExtensionException;
import org.apache.cxf.staxutils.StaxUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionFragmentParser {
    private static final String EXTENSION_ELEM_NAME = "extension";
    private static final String NAMESPACE_ELEM_NAME = "namespace";
    private static final String CLASS_ATTR_NAME = "class";
    private static final String INTERFACE_ATTR_NAME = "interface";
    private static final String DEFERRED_ATTR_NAME = "deferred";

    List<Extension> getExtensionsFromXML(InputStream is2) {
        Document document2 = null;
        try {
            document2 = StaxUtils.read(is2);
        }
        catch (XMLStreamException ex2) {
            throw new ExtensionException(ex2);
        }
        return this.deserialiseExtensions(document2);
    }

    List<Extension> getExtensionsFromText(InputStream is2) throws IOException {
        ArrayList<Extension> extensions = new ArrayList<Extension>();
        BufferedReader reader2 = new BufferedReader(new InputStreamReader(is2, "UTF-8"));
        String line = reader2.readLine();
        while (line != null) {
            Extension extension2 = this.getExtensionFromTextLine(line);
            if (extension2 != null) {
                extensions.add(extension2);
            }
            line = reader2.readLine();
        }
        return extensions;
    }

    private Extension getExtensionFromTextLine(String line) {
        if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') {
            return null;
        }
        Extension ext = new Extension();
        String[] parts = line.split(":");
        ext.setClassname(parts[0]);
        if (ext.getClassname() == null) {
            return null;
        }
        if (parts.length >= 2) {
            String interfaceName = parts[1];
            if (interfaceName != null && "".equals(interfaceName)) {
                interfaceName = null;
            }
            ext.setInterfaceName(interfaceName);
        }
        if (parts.length >= 3) {
            ext.setDeferred(Boolean.parseBoolean(parts[2]));
        }
        return ext;
    }

    List<Extension> deserialiseExtensions(Document document2) {
        ArrayList<Extension> extensions = new ArrayList<Extension>();
        Element root2 = document2.getDocumentElement();
        for (Node nd = root2.getFirstChild(); nd != null; nd = nd.getNextSibling()) {
            if (1 != nd.getNodeType() || !EXTENSION_ELEM_NAME.equals(nd.getLocalName())) continue;
            Extension e2 = new Extension();
            Element elem2 = (Element)nd;
            e2.setClassname(elem2.getAttribute(CLASS_ATTR_NAME));
            e2.setInterfaceName(elem2.getAttribute(INTERFACE_ATTR_NAME));
            String bval = elem2.getAttribute(DEFERRED_ATTR_NAME).trim();
            e2.setDeferred("1".equals(bval) || "true".equals(bval));
            this.deserialiseNamespaces(elem2, e2);
            extensions.add(e2);
        }
        return extensions;
    }

    void deserialiseNamespaces(Element extensionElem, Extension e2) {
        for (Node nd = extensionElem.getFirstChild(); nd != null; nd = nd.getNextSibling()) {
            if (1 != nd.getNodeType() || !NAMESPACE_ELEM_NAME.equals(nd.getLocalName())) continue;
            e2.getNamespaces().add(nd.getTextContent());
        }
    }
}

