/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.bus.extension;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.extension.Extension;
import org.apache.cxf.bus.extension.ExtensionException;
import org.apache.cxf.bus.extension.ExtensionFragmentParser;
import org.apache.cxf.bus.extension.ExtensionManager;
import org.apache.cxf.common.injection.ResourceInjector;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.ConfiguredBeanLocator;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.resource.ObjectTypeResolver;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.resource.SinglePropertyResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionManagerImpl
implements ExtensionManager,
ConfiguredBeanLocator {
    public static final Logger LOG = LogUtils.getL7dLogger(ExtensionManagerImpl.class);
    public static final String EXTENSIONMANAGER_PROPERTY_NAME = "extensionManager";
    public static final String ACTIVATION_NAMESPACES_PROPERTY_NAME = "activationNamespaces";
    public static final String ACTIVATION_NAMESPACES_SETTER_METHOD_NAME = "setActivationNamespaces";
    public static final String BUS_EXTENSION_RESOURCE_XML = "META-INF/cxf/bus-extensions.xml";
    public static final String BUS_EXTENSION_RESOURCE_OLD_XML = "bus-extensions.xml";
    public static final String BUS_EXTENSION_RESOURCE = "META-INF/cxf/bus-extensions.txt";
    private final ClassLoader loader;
    private ResourceManager resourceManager;
    private Map<String, Extension> all = new LinkedHashMap<String, Extension>();
    private final Map<Class, Object> activated;
    private final Bus bus;

    public ExtensionManagerImpl(ClassLoader cl, Map<Class, Object> initialExtensions, ResourceManager rm, Bus b) {
        this(new String[]{BUS_EXTENSION_RESOURCE, BUS_EXTENSION_RESOURCE_XML, BUS_EXTENSION_RESOURCE_OLD_XML}, cl, initialExtensions, rm, b);
    }

    public ExtensionManagerImpl(String resource, ClassLoader cl, Map<Class, Object> initialExtensions, ResourceManager rm, Bus b) {
        this(new String[]{resource}, cl, initialExtensions, rm, b);
    }

    public ExtensionManagerImpl(String[] resources, ClassLoader cl, Map<Class, Object> initialExtensions, ResourceManager rm, Bus b) {
        this.loader = cl;
        this.bus = b;
        this.activated = initialExtensions;
        this.resourceManager = rm;
        SinglePropertyResolver extensionManagerResolver = new SinglePropertyResolver(EXTENSIONMANAGER_PROPERTY_NAME, this);
        this.resourceManager.addResourceResolver(extensionManagerResolver);
        this.resourceManager.addResourceResolver(new ObjectTypeResolver(this));
        this.load(resources);
    }

    public final void load(String[] resources) {
        if (resources == null) {
            return;
        }
        try {
            for (String resource : resources) {
                this.load(resource);
            }
        }
        catch (IOException ex2) {
            throw new ExtensionException(ex2);
        }
    }

    public void add(Extension ex2) {
        this.all.put(ex2.getName(), ex2);
    }

    public synchronized void initialize() {
        for (Extension e2 : this.all.values()) {
            if (e2.isDeferred() || e2.getLoadedObject() != null) continue;
            this.loadAndRegister(e2);
        }
    }

    public synchronized void removeBeansOfNames(List<String> names) {
        for (String s2 : names) {
            this.all.remove(s2);
        }
    }

    @Override
    public synchronized void activateAll() {
        for (Extension e2 : this.all.values()) {
            if (e2.getLoadedObject() != null) continue;
            this.loadAndRegister(e2);
        }
    }

    @Override
    public synchronized <T> void activateAllByType(Class<T> type) {
        for (Extension e2 : this.all.values()) {
            if (e2.getLoadedObject() != null || !type.isAssignableFrom(e2.getClassObject(this.loader))) continue;
            this.loadAndRegister(e2);
        }
    }

    final void load(String resource) throws IOException {
        Enumeration<URL> urls2 = this.loader.getResources(resource);
        while (urls2.hasMoreElements()) {
            List<Extension> exts;
            URL url = urls2.nextElement();
            InputStream is2 = url.openStream();
            if (resource.endsWith("xml")) {
                LOG.log(Level.WARNING, "DEPRECATED_EXTENSIONS", new Object[]{resource, url, BUS_EXTENSION_RESOURCE});
                exts = new ExtensionFragmentParser().getExtensionsFromXML(is2);
            } else {
                exts = new ExtensionFragmentParser().getExtensionsFromText(is2);
            }
            for (Extension e2 : exts) {
                this.all.put(e2.getName(), e2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void loadAndRegister(Extension e2) {
        Class<?> cls = null;
        if (null != e2.getInterfaceName() && !"".equals(e2.getInterfaceName())) {
            cls = e2.loadInterface(this.loader);
        }
        if (null != this.activated && null != cls && null != this.activated.get(cls)) {
            return;
        }
        Object obj = e2.load(this.loader, this.bus);
        Configurer configurer = (Configurer)this.activated.get(Configurer.class);
        if (null != configurer) {
            configurer.configureBean(obj);
        }
        SinglePropertyResolver namespacesResolver = null;
        if (null != e2.getNamespaces()) {
            namespacesResolver = new SinglePropertyResolver(ACTIVATION_NAMESPACES_PROPERTY_NAME, e2.getNamespaces());
            this.resourceManager.addResourceResolver(namespacesResolver);
        }
        if (e2.getNamespaces() != null && !e2.getNamespaces().isEmpty()) {
            this.invokeSetterActivationNSMethod(obj, e2.getNamespaces());
        }
        ResourceInjector injector = new ResourceInjector(this.resourceManager);
        try {
            injector.inject(obj);
            injector.construct(obj);
        }
        finally {
            if (null != namespacesResolver) {
                this.resourceManager.removeResourceResolver(namespacesResolver);
            }
        }
        if (null != this.activated) {
            if (cls == null) {
                cls = obj.getClass();
            }
            this.activated.put(cls, obj);
        }
    }

    @Override
    public synchronized <T> T getExtension(String name, Class<T> type) {
        Extension e2 = this.all.get(name);
        if (e2 != null && type.isAssignableFrom(e2.getClassObject(this.loader))) {
            if (e2.getLoadedObject() == null) {
                this.loadAndRegister(e2);
            }
            return type.cast(e2.getLoadedObject());
        }
        return null;
    }

    private void invokeSetterActivationNSMethod(Object target2, Object value2) {
        String methodName = ACTIVATION_NAMESPACES_SETTER_METHOD_NAME;
        for (Class<?> clazz2 = target2.getClass(); clazz2 != Object.class; clazz2 = clazz2.getSuperclass()) {
            Method[] methods2 = clazz2.getMethods();
            for (int i = 0; i < methods2.length; ++i) {
                Class<?> paramType;
                Method method = methods2[i];
                Class<?>[] params2 = method.getParameterTypes();
                if (!method.getName().equals(methodName) || params2.length != 1 || !(paramType = params2[0]).isInstance(value2)) continue;
                try {
                    method.invoke(target2, value2);
                }
                catch (Exception e2) {
                    // empty catch block
                }
                return;
            }
        }
    }

    @Override
    public List<String> getBeanNamesOfType(Class<?> type) {
        LinkedList<String> ret = new LinkedList<String>();
        for (Extension ex2 : this.all.values()) {
            if (!type.isAssignableFrom(ex2.getClassObject(this.loader))) continue;
            ret.add(ex2.getName());
        }
        return ret;
    }

    @Override
    public synchronized <T> Collection<? extends T> getBeansOfType(Class<T> type) {
        LinkedList<T> ret = new LinkedList<T>();
        for (Extension ex2 : this.all.values()) {
            if (!type.isAssignableFrom(ex2.getClassObject(this.loader))) continue;
            if (ex2.getLoadedObject() == null) {
                this.loadAndRegister(ex2);
            }
            ret.add(type.cast(ex2.getLoadedObject()));
        }
        return ret;
    }

    @Override
    public synchronized <T> boolean loadBeansOfType(Class<T> type, ConfiguredBeanLocator.BeanLoaderListener<T> listener) {
        boolean loaded = false;
        for (Extension ex2 : this.all.values()) {
            Class<?> cls = ex2.getClassObject(this.loader);
            if (ex2.getLoadedObject() != null || !type.isAssignableFrom(cls) || !listener.loadBean(ex2.getName(), cls.asSubclass(type))) continue;
            this.loadAndRegister(ex2);
            if (listener.beanLoaded(ex2.getName(), type.cast(ex2.getLoadedObject()))) {
                return true;
            }
            loaded = true;
        }
        return loaded;
    }

    @Override
    public boolean hasConfiguredPropertyValue(String beanName, String propertyName, String value2) {
        Extension ex2 = this.all.get(beanName);
        return ex2 != null && ex2.getNamespaces() != null && ex2.getNamespaces().contains(value2);
    }

    public void destroyBeans() {
        for (Extension ex2 : this.all.values()) {
            if (ex2.getLoadedObject() == null) continue;
            ResourceInjector injector = new ResourceInjector(this.resourceManager);
            injector.destroy(ex2.getLoadedObject());
        }
    }
}

