/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.bus.spring;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.bus.spring.BusEntityResolver;
import org.apache.cxf.bus.spring.ControlledValidationXmlBeanDefinitionReader;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.SystemUtils;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.BeansDtdResolver;
import org.springframework.beans.factory.xml.DefaultNamespaceHandlerResolver;
import org.springframework.beans.factory.xml.PluggableSchemaResolver;
import org.springframework.beans.factory.xml.ResourceEntityResolver;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextException;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class BusApplicationContext
extends ClassPathXmlApplicationContext {
    private static final String DEFAULT_CXF_CFG_FILE = "META-INF/cxf/cxf.xml";
    private static final String DEFAULT_CXF_EXT_CFG_FILE = "classpath*:META-INF/cxf/cxf.extension";
    private static final Logger LOG = LogUtils.getL7dLogger(BusApplicationContext.class);
    private DefaultNamespaceHandlerResolver nsHandlerResolver;
    private boolean includeDefaults;
    private String[] cfgFiles;
    private URL[] cfgFileURLs;

    public BusApplicationContext(String cf, boolean include2) {
        this(cf, include2, null);
    }

    public BusApplicationContext(String[] cfs, boolean include2) {
        this(cfs, include2, null);
    }

    public BusApplicationContext(URL url, boolean include2) {
        this(url, include2, null);
    }

    public BusApplicationContext(URL[] urls2, boolean include2) {
        this(urls2, include2, null);
    }

    public BusApplicationContext(String cf, boolean include2, ApplicationContext parent2) {
        this(new String[]{cf}, include2, parent2);
    }

    public BusApplicationContext(URL url, boolean include2, ApplicationContext parent2) {
        this(new URL[]{url}, include2, parent2);
    }

    public BusApplicationContext(String[] cf, boolean include2, ApplicationContext parent2) {
        super(new String[0], false, parent2);
        this.cfgFiles = cf;
        this.includeDefaults = include2;
        this.refresh();
    }

    public BusApplicationContext(URL[] url, boolean include2, ApplicationContext parent2) {
        super(new String[0], false, parent2);
        this.cfgFileURLs = url;
        this.includeDefaults = include2;
        this.refresh();
    }

    protected Resource[] getConfigResources() {
        String sysCfgFileUrl;
        String cfgFile;
        ArrayList<Resource> resources = new ArrayList<Resource>();
        if (this.includeDefaults) {
            try {
                Resource[] exts;
                PathMatchingResourcePatternResolver resolver2 = new PathMatchingResourcePatternResolver(Thread.currentThread().getContextClassLoader());
                Collections.addAll(resources, resolver2.getResources(DEFAULT_CXF_CFG_FILE));
                for (Resource r : exts = resolver2.getResources(DEFAULT_CXF_EXT_CFG_FILE)) {
                    InputStream is2 = r.getInputStream();
                    BufferedReader rd = new BufferedReader(new InputStreamReader(is2, "UTF-8"));
                    String line = rd.readLine();
                    while (line != null) {
                        if (!"".equals(line)) {
                            resources.add(resolver2.getResource(line));
                        }
                        line = rd.readLine();
                    }
                    is2.close();
                }
            }
            catch (IOException ex2) {
                // empty catch block
            }
        }
        boolean usingDefault = false;
        if (null == this.cfgFiles && (cfgFile = System.getProperty("cxf.config.file")) != null) {
            this.cfgFiles = new String[]{cfgFile};
        }
        if (null == this.cfgFiles) {
            this.cfgFiles = new String[]{"cxf.xml"};
            usingDefault = true;
        }
        for (String cfgFile2 : this.cfgFiles) {
            Resource cpr = BusApplicationContext.findResource(cfgFile2);
            if (cpr != null && cpr.exists()) {
                resources.add(cpr);
                LogUtils.log(LOG, Level.INFO, "USER_CFG_FILE_IN_USE", cfgFile2);
                continue;
            }
            if (usingDefault) continue;
            LogUtils.log(LOG, Level.WARNING, "USER_CFG_FILE_NOT_LOADED", cfgFile2);
            String message = new Message("USER_CFG_FILE_NOT_LOADED", LOG, cfgFile2).toString();
            throw new ApplicationContextException(message);
        }
        if (null != this.cfgFileURLs) {
            for (URL cfgFileURL : this.cfgFileURLs) {
                UrlResource ur = new UrlResource(cfgFileURL);
                if (ur.exists()) {
                    resources.add(ur);
                    continue;
                }
                LogUtils.log(LOG, Level.WARNING, "USER_CFG_FILE_URL_NOT_FOUND_MSG", cfgFileURL);
            }
        }
        if (null != (sysCfgFileUrl = System.getProperty("cxf.config.file.url"))) {
            try {
                UrlResource ur = new UrlResource(sysCfgFileUrl);
                if (ur.exists()) {
                    resources.add(ur);
                } else {
                    LogUtils.log(LOG, Level.WARNING, "USER_CFG_FILE_URL_NOT_FOUND_MSG", sysCfgFileUrl);
                }
            }
            catch (MalformedURLException e2) {
                LogUtils.log(LOG, Level.WARNING, "USER_CFG_FILE_URL_ERROR_MSG", sysCfgFileUrl);
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Creating application context with resources: " + resources);
        }
        if (0 == resources.size()) {
            return null;
        }
        Resource[] res = new Resource[resources.size()];
        res = resources.toArray(res);
        return res;
    }

    public static Resource findResource(String cfgFile) {
        URL url;
        AbstractResource cpr = new ClassPathResource(cfgFile);
        if (cpr.exists()) {
            return cpr;
        }
        try {
            url = new URL(cfgFile);
            cpr = new UrlResource(url);
            if (cpr.exists()) {
                return cpr;
            }
        }
        catch (MalformedURLException e2) {
            // empty catch block
        }
        url = ClassLoaderUtils.getResource(cfgFile, BusApplicationContext.class);
        if (url != null && (cpr = new UrlResource(url)).exists()) {
            return cpr;
        }
        cpr = new FileSystemResource(cfgFile);
        if (cpr.exists()) {
            return cpr;
        }
        return null;
    }

    protected void initBeanDefinitionReader(XmlBeanDefinitionReader reader2) {
        if (this.nsHandlerResolver == null) {
            this.nsHandlerResolver = new DefaultNamespaceHandlerResolver();
        }
        reader2.setNamespaceHandlerResolver(this.nsHandlerResolver);
        String mode = SystemUtils.getSpringValidationMode();
        if (null != mode) {
            reader2.setValidationModeName(mode);
        }
        reader2.setNamespaceAware(true);
        this.setEntityResolvers(reader2);
    }

    void setEntityResolvers(XmlBeanDefinitionReader reader2) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        reader2.setEntityResolver(new BusEntityResolver(new BeansDtdResolver(), new PluggableSchemaResolver(cl)));
    }

    protected void loadBeanDefinitions(DefaultListableBeanFactory beanFactory) throws IOException {
        ControlledValidationXmlBeanDefinitionReader beanDefinitionReader = new ControlledValidationXmlBeanDefinitionReader(beanFactory);
        beanDefinitionReader.setResourceLoader(this);
        beanDefinitionReader.setEntityResolver(new ResourceEntityResolver(this));
        this.initBeanDefinitionReader(beanDefinitionReader);
        this.loadBeanDefinitions(beanDefinitionReader);
    }
}

