/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.bus.spring;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.CXFBusImpl;
import org.apache.cxf.bus.spring.BusWiringBeanFactoryPostProcessor;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.configuration.spring.AbstractBeanDefinitionParser;
import org.apache.cxf.configuration.spring.BusWiringType;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.interceptor.AbstractBasicInterceptorProvider;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.message.Message;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.w3c.dom.Element;

public class BusDefinitionParser
extends AbstractBeanDefinitionParser {
    private static AtomicInteger counter = new AtomicInteger(0);

    public BusDefinitionParser() {
        this.setBeanClass(BusConfig.class);
    }

    protected void doParse(Element element2, ParserContext ctx, BeanDefinitionBuilder bean) {
        String bus = element2.getAttribute("bus");
        if (StringUtils.isEmpty(bus)) {
            this.addBusWiringAttribute(bean, BusWiringType.PROPERTY);
        } else {
            this.addBusWiringAttribute(bean, BusWiringType.PROPERTY, bus);
        }
        element2.removeAttribute("bus");
        bean.addConstructorArgValue(bus);
        bean.setLazyInit(false);
        super.doParse(element2, ctx, bean);
    }

    protected void mapElement(ParserContext ctx, BeanDefinitionBuilder bean, Element e2, String name) {
        if ("inInterceptors".equals(name) || "inFaultInterceptors".equals(name) || "outInterceptors".equals(name) || "outFaultInterceptors".equals(name) || "features".equals(name)) {
            List list2 = ctx.getDelegate().parseListElement(e2, bean.getBeanDefinition());
            bean.addPropertyValue(name, list2);
        } else if ("properties".equals(name)) {
            Map map3 = ctx.getDelegate().parseMapElement(e2, bean.getBeanDefinition());
            bean.addPropertyValue("properties", map3);
        }
    }

    protected String getIdOrName(Element elem2) {
        String id2 = super.getIdOrName(elem2);
        if (StringUtils.isEmpty(id2)) {
            id2 = "cxf.config" + counter.getAndIncrement();
        }
        return id2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @NoJSR250Annotations
    public static class BusConfig
    extends AbstractBasicInterceptorProvider
    implements ApplicationContextAware {
        CXFBusImpl bus;
        String busName;
        Collection<AbstractFeature> features;
        Map<String, Object> properties;

        public BusConfig(String busName) {
            this.busName = busName;
        }

        public void setBus(Bus bb) {
            CXFBusImpl b = (CXFBusImpl)bb;
            if (this.features != null) {
                b.setFeatures(this.features);
                this.features = null;
            }
            if (this.properties != null) {
                b.setProperties(this.properties);
                this.properties = null;
            }
            if (!this.getInInterceptors().isEmpty()) {
                b.setInInterceptors(this.getInInterceptors());
            }
            if (!this.getOutInterceptors().isEmpty()) {
                b.setOutInterceptors(this.getOutInterceptors());
            }
            if (!this.getInFaultInterceptors().isEmpty()) {
                b.setInFaultInterceptors(this.getInFaultInterceptors());
            }
            if (!this.getOutFaultInterceptors().isEmpty()) {
                b.setOutFaultInterceptors(this.getOutFaultInterceptors());
            }
            this.bus = b;
        }

        @Override
        public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
            if (this.bus != null) {
                return;
            }
            if (this.busName == null) {
                this.setBus(BusWiringBeanFactoryPostProcessor.addDefaultBus(applicationContext));
            } else {
                this.setBus(BusWiringBeanFactoryPostProcessor.addBus(applicationContext, this.busName));
            }
        }

        @Override
        public List<Interceptor<? extends Message>> getOutFaultInterceptors() {
            if (this.bus != null) {
                return this.bus.getOutFaultInterceptors();
            }
            return super.getOutFaultInterceptors();
        }

        @Override
        public List<Interceptor<? extends Message>> getInFaultInterceptors() {
            if (this.bus != null) {
                return this.bus.getInFaultInterceptors();
            }
            return super.getInFaultInterceptors();
        }

        @Override
        public List<Interceptor<? extends Message>> getInInterceptors() {
            if (this.bus != null) {
                return this.bus.getInInterceptors();
            }
            return super.getInInterceptors();
        }

        @Override
        public List<Interceptor<? extends Message>> getOutInterceptors() {
            if (this.bus != null) {
                return this.bus.getOutInterceptors();
            }
            return super.getOutInterceptors();
        }

        @Override
        public void setInInterceptors(List<Interceptor<? extends Message>> interceptors) {
            if (this.bus != null) {
                this.bus.setInInterceptors(interceptors);
            } else {
                super.setInInterceptors(interceptors);
            }
        }

        @Override
        public void setInFaultInterceptors(List<Interceptor<? extends Message>> interceptors) {
            if (this.bus != null) {
                this.bus.setInFaultInterceptors(interceptors);
            } else {
                super.setInFaultInterceptors(interceptors);
            }
        }

        @Override
        public void setOutInterceptors(List<Interceptor<? extends Message>> interceptors) {
            if (this.bus != null) {
                this.bus.setOutInterceptors(interceptors);
            } else {
                super.setOutInterceptors(interceptors);
            }
        }

        @Override
        public void setOutFaultInterceptors(List<Interceptor<? extends Message>> interceptors) {
            if (this.bus != null) {
                this.bus.setOutFaultInterceptors(interceptors);
            } else {
                super.setOutFaultInterceptors(interceptors);
            }
        }

        public Collection<AbstractFeature> getFeatures() {
            if (this.bus != null) {
                return this.bus.getFeatures();
            }
            return this.features;
        }

        public void setFeatures(Collection<AbstractFeature> features) {
            if (this.bus != null) {
                this.bus.setFeatures(features);
            } else {
                this.features = features;
            }
        }

        public Map<String, Object> getProperties() {
            if (this.bus != null) {
                return this.bus.getProperties();
            }
            return this.properties;
        }

        public void setProperties(Map<String, Object> s2) {
            if (this.bus != null) {
                this.bus.setProperties(s2);
            } else {
                this.properties = s2;
            }
        }
    }
}

