/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.bus.spring;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import org.apache.cxf.bus.spring.TunedDocumentLoader;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.core.io.support.EncodedResource;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class ControlledValidationXmlBeanDefinitionReader
extends XmlBeanDefinitionReader {
    private boolean noFastinfoset;
    private int visibleValidationMode = 1;
    private TunedDocumentLoader tunedDocumentLoader = new TunedDocumentLoader();

    public ControlledValidationXmlBeanDefinitionReader(BeanDefinitionRegistry beanFactory) {
        super(beanFactory);
        this.setDocumentLoader(this.tunedDocumentLoader);
        this.noFastinfoset = System.getProperty("org.apache.cxf.nofastinfoset") != null || !TunedDocumentLoader.hasFastInfoSet();
    }

    protected int doLoadBeanDefinitions(InputSource inputSource, Resource resource) throws BeanDefinitionStoreException {
        boolean suppressValidation = false;
        try {
            URL url = resource.getURL();
            if (url.getFile().contains("META-INF/cxf/")) {
                suppressValidation = true;
            }
        }
        catch (IOException e2) {
            // empty catch block
        }
        int savedValidation = this.visibleValidationMode;
        if (suppressValidation) {
            this.setValidationMode(0);
        }
        int r = super.doLoadBeanDefinitions(inputSource, resource);
        this.setValidationMode(savedValidation);
        return r;
    }

    public void setValidationMode(int validationMode) {
        this.visibleValidationMode = validationMode;
        super.setValidationMode(validationMode);
    }

    public int loadBeanDefinitions(EncodedResource encodedResource) throws BeanDefinitionStoreException {
        if (!this.noFastinfoset) {
            try {
                return this.fastInfosetLoadBeanDefinitions(encodedResource);
            }
            catch (BeanDefinitionStoreException bdse) {
                throw bdse;
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
        }
        return super.loadBeanDefinitions(encodedResource);
    }

    private int fastInfosetLoadBeanDefinitions(EncodedResource encodedResource) throws IOException, StaleFastinfosetException, ParserConfigurationException, XMLStreamException {
        URL resUrl = encodedResource.getResource().getURL();
        if (!resUrl.getPath().endsWith(".xml")) {
            throw new StaleFastinfosetException();
        }
        String fixmlPath = resUrl.getPath().replaceFirst("\\.xml$", ".fixml");
        String protocol = resUrl.getProtocol();
        if ("jar".equals(protocol)) {
            fixmlPath = fixmlPath.replaceFirst("^.*!", "");
        }
        URL fixmlUrl = new URL(resUrl, fixmlPath);
        if ("file".equals(protocol)) {
            URLConnection resCon = null;
            URLConnection fixCon = null;
            resCon = resUrl.openConnection();
            fixCon = fixmlUrl.openConnection();
            if (resCon.getLastModified() > fixCon.getLastModified()) {
                throw new StaleFastinfosetException();
            }
        }
        UrlResource newResource = new UrlResource(fixmlUrl);
        Document doc = TunedDocumentLoader.loadFastinfosetDocument(fixmlUrl);
        if (doc == null) {
            throw new StaleFastinfosetException();
        }
        return this.registerBeanDefinitions(doc, newResource);
    }

    private static class StaleFastinfosetException
    extends Exception {
        private StaleFastinfosetException() {
        }
    }
}

