/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.catalog;

import java.io.IOException;
import java.net.MalformedURLException;
import javax.wsdl.xml.WSDLLocator;
import org.apache.cxf.Bus;
import org.apache.cxf.catalog.OASISCatalogManager;
import org.apache.cxf.resource.ExtendedURIResolver;
import org.apache.cxf.transport.TransportURIResolver;
import org.xml.sax.InputSource;

public class CatalogWSDLLocator
implements WSDLLocator {
    private String wsdlUrl;
    private ExtendedURIResolver resolver;
    private OASISCatalogManager manager;
    private String baseUri;

    public CatalogWSDLLocator(String wsdlUrl) {
        this.baseUri = wsdlUrl;
        this.resolver = new ExtendedURIResolver();
    }

    public CatalogWSDLLocator(String wsdlUrl, OASISCatalogManager catalogManager) {
        this.baseUri = wsdlUrl;
        this.manager = catalogManager;
        this.resolver = new ExtendedURIResolver();
    }

    public CatalogWSDLLocator(String wsdlUrl, Bus b) {
        this.baseUri = wsdlUrl;
        this.manager = OASISCatalogManager.getCatalogManager(b);
        this.resolver = new TransportURIResolver(b);
    }

    public InputSource getBaseInputSource() {
        InputSource result2 = null;
        if (this.manager != null) {
            try {
                String s2 = this.manager.resolveSystem(this.baseUri);
                if (s2 != null) {
                    result2 = this.resolver.resolve(s2, null);
                }
            }
            catch (MalformedURLException e2) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (result2 == null) {
            result2 = this.resolver.resolve(this.baseUri, null);
        }
        if (this.wsdlUrl == null && result2 != null) {
            this.wsdlUrl = result2.getSystemId();
        }
        this.baseUri = this.resolver.getURI();
        return result2;
    }

    public String getBaseURI() {
        InputSource is2;
        if (this.wsdlUrl == null && (is2 = this.getBaseInputSource()).getByteStream() != null) {
            try {
                is2.getByteStream().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.wsdlUrl;
    }

    public String getLatestImportURI() {
        return this.resolver.getLatestImportURI();
    }

    public InputSource getImportInputSource(String parent2, String importLocation) {
        String resolvedImportLocation = null;
        if (this.manager != null) {
            try {
                resolvedImportLocation = this.manager.resolveSystem(importLocation);
                if (resolvedImportLocation == null) {
                    resolvedImportLocation = this.manager.resolveURI(importLocation);
                }
                if (resolvedImportLocation == null) {
                    resolvedImportLocation = this.manager.resolvePublic(importLocation, parent2);
                }
            }
            catch (IOException e2) {
                throw new RuntimeException("Catalog resolution failed", e2);
            }
        }
        InputSource in2 = null;
        in2 = resolvedImportLocation == null ? this.resolver.resolve(importLocation, parent2) : this.resolver.resolve(resolvedImportLocation, null);
        if (in2 == null) {
            in2 = new InputSource();
        }
        return in2;
    }

    public void close() {
        this.resolver.close();
    }
}

