/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.catalog;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.cxf.Bus;
import org.apache.cxf.catalog.OASISCatalogManager;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.resource.ExtendedURIResolver;
import org.apache.cxf.transport.TransportURIResolver;
import org.apache.ws.commons.schema.XmlSchemaException;
import org.apache.ws.commons.schema.resolver.URIResolver;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CatalogXmlSchemaURIResolver
implements URIResolver {
    private ExtendedURIResolver resolver;
    private Bus bus;
    private Map<String, String> resolved = new HashMap<String, String>();

    public CatalogXmlSchemaURIResolver(Bus bus) {
        this.resolver = new TransportURIResolver(bus);
        this.bus = bus;
    }

    public Map<String, String> getResolvedMap() {
        return this.resolved;
    }

    @Override
    public InputSource resolveEntity(String targetNamespace, String schemaLocation, String baseUri) {
        String resolvedSchemaLocation = null;
        OASISCatalogManager catalogResolver = OASISCatalogManager.getCatalogManager(this.bus);
        if (catalogResolver != null) {
            try {
                resolvedSchemaLocation = catalogResolver.resolveSystem(schemaLocation);
                if (resolvedSchemaLocation == null) {
                    resolvedSchemaLocation = catalogResolver.resolveURI(schemaLocation);
                }
                if (resolvedSchemaLocation == null) {
                    resolvedSchemaLocation = catalogResolver.resolvePublic(schemaLocation, baseUri);
                }
            }
            catch (IOException e2) {
                throw new RuntimeException("Catalog resolution failed", e2);
            }
        }
        InputSource in2 = null;
        if (resolvedSchemaLocation == null) {
            in2 = this.resolver.resolve(schemaLocation, baseUri);
        } else {
            this.resolved.put(schemaLocation, resolvedSchemaLocation);
            in2 = this.resolver.resolve(resolvedSchemaLocation, baseUri);
        }
        if (in2 == null) {
            throw new XmlSchemaException("Unable to locate imported document at '" + schemaLocation + "'" + (baseUri == null ? "." : ", relative to '" + baseUri + "'."));
        }
        if (in2.getByteStream() != null && !(in2.getByteStream() instanceof ByteArrayInputStream)) {
            try {
                ByteArrayInputStream ins2 = IOUtils.loadIntoBAIS(in2.getByteStream());
                in2.setByteStream(ins2);
            }
            catch (IOException e3) {
                throw new XmlSchemaException("Unable to load imported document at '" + schemaLocation + "'" + (baseUri == null ? "." : ", relative to '" + baseUri + "'."), e3);
            }
        }
        return in2;
    }
}

