/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.clustering;

import java.util.List;
import java.util.logging.Logger;
import org.apache.cxf.clustering.FailoverTargetSelector;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.transport.Conduit;

public class LoadDistributorTargetSelector
extends FailoverTargetSelector {
    private static final Logger LOG = LogUtils.getL7dLogger(LoadDistributorTargetSelector.class);
    private static final String IS_DISTRIBUTED = "org.apache.cxf.clustering.LoadDistributorTargetSelector.IS_DISTRIBUTED";
    private List<String> addressList;
    private boolean failover = true;

    public LoadDistributorTargetSelector() {
        this(null);
    }

    public LoadDistributorTargetSelector(Conduit c2) {
        super(c2);
    }

    public boolean isFailover() {
        return this.failover;
    }

    public void setFailover(boolean failover) {
        this.failover = failover;
    }

    protected Logger getLogger() {
        return LOG;
    }

    public Conduit selectConduit(Message message) {
        Endpoint target2;
        Exchange exchange = message.getExchange();
        FailoverTargetSelector.InvocationKey key = new FailoverTargetSelector.InvocationKey(exchange);
        FailoverTargetSelector.InvocationContext invocation = (FailoverTargetSelector.InvocationContext)this.inProgress.get(key);
        if (invocation != null && !invocation.getContext().containsKey(IS_DISTRIBUTED) && (target2 = this.getDistributionTarget(exchange, invocation)) != null) {
            this.setEndpoint(target2);
            if (this.selectedConduit != null) {
                this.selectedConduit.close();
                this.selectedConduit = null;
            }
            message.put(Message.ENDPOINT_ADDRESS, target2.getEndpointInfo().getAddress());
            this.overrideAddressProperty(invocation.getContext());
            invocation.getContext().put(IS_DISTRIBUTED, null);
        }
        return this.getSelectedConduit(message);
    }

    protected Endpoint getFailoverTarget(Exchange exchange, FailoverTargetSelector.InvocationContext invocation) {
        List<String> alternateAddresses = null;
        if (!invocation.hasAlternates()) {
            alternateAddresses = this.getStrategy().getAlternateAddresses(exchange);
            if (alternateAddresses != null) {
                alternateAddresses.remove(exchange.getEndpoint().getEndpointInfo().getAddress());
                invocation.setAlternateAddresses(alternateAddresses);
            } else {
                invocation.setAlternateEndpoints(this.getStrategy().getAlternateEndpoints(exchange));
            }
        } else {
            alternateAddresses = invocation.getAlternateAddresses();
        }
        Endpoint failoverTarget = null;
        if (alternateAddresses != null) {
            String alternateAddress = this.getStrategy().selectAlternateAddress(alternateAddresses);
            if (alternateAddress != null) {
                failoverTarget = this.getEndpoint();
                failoverTarget.getEndpointInfo().setAddress(alternateAddress);
            }
        } else {
            failoverTarget = this.getStrategy().selectAlternateEndpoint(invocation.getAlternateEndpoints());
        }
        return failoverTarget;
    }

    private Endpoint getDistributionTarget(Exchange exchange, FailoverTargetSelector.InvocationContext invocation) {
        List<String> alternateAddresses = null;
        if (this.addressList == null || this.addressList.isEmpty()) {
            try {
                this.addressList = this.getStrategy().getAlternateAddresses(null);
            }
            catch (NullPointerException ex2) {
                this.getLogger().fine("Strategy " + this.getStrategy().getClass() + " cannot handle a null argument to getAlternateAddresses: " + ex2.toString());
            }
        }
        if ((alternateAddresses = this.addressList) == null || alternateAddresses.isEmpty()) {
            alternateAddresses = this.getStrategy().getAlternateAddresses(exchange);
            if (alternateAddresses != null) {
                invocation.setAlternateAddresses(alternateAddresses);
            } else {
                invocation.setAlternateEndpoints(this.getStrategy().getAlternateEndpoints(exchange));
            }
        }
        Endpoint distributionTarget = null;
        if (alternateAddresses != null && !alternateAddresses.isEmpty()) {
            String alternateAddress = this.getStrategy().selectAlternateAddress(alternateAddresses);
            if (alternateAddress != null) {
                distributionTarget = this.getEndpoint();
                distributionTarget.getEndpointInfo().setAddress(alternateAddress);
            }
        } else {
            distributionTarget = this.getStrategy().selectAlternateEndpoint(invocation.getAlternateEndpoints());
        }
        return distributionTarget;
    }

    protected boolean requiresFailover(Exchange exchange) {
        return this.failover && super.requiresFailover(exchange);
    }
}

