/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.common.classloader;

import java.net.URL;
import java.security.SecureClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FireWallClassLoader
extends SecureClassLoader {
    private final String[] filters;
    private final String[] fnFilters;
    private final String[] negativeFilters;
    private final String[] negativeFNFilters;

    public FireWallClassLoader(ClassLoader parent2, String[] fs2) {
        this(parent2, fs2, new String[0]);
    }

    public FireWallClassLoader(ClassLoader parent2, String[] fs2, String[] negativeFs) {
        super(parent2);
        this.filters = FireWallClassLoader.processFilters(fs2);
        this.negativeFilters = FireWallClassLoader.processFilters(negativeFs);
        this.fnFilters = FireWallClassLoader.filters2FNFilters(this.filters);
        this.negativeFNFilters = FireWallClassLoader.filters2FNFilters(this.negativeFilters);
        boolean javaCovered = false;
        if (this.filters == null) {
            javaCovered = true;
        } else {
            for (int i = 0; i < this.filters.length; ++i) {
                if (!this.filters[i].equals("java.")) continue;
                javaCovered = true;
            }
        }
        if (this.negativeFilters != null) {
            String java = "java.";
            for (int i = java.length(); i >= 0; --i) {
                for (int j = 0; j < this.negativeFilters.length; ++j) {
                    if (!this.negativeFilters[j].equals(java.substring(0, i))) continue;
                    javaCovered = false;
                }
            }
        }
        if (!javaCovered) {
            throw new SecurityException("It's unsafe to construct a FireWallClassLoader that does not let the java. package through.");
        }
    }

    private static String[] processFilters(String[] fs2) {
        if (fs2 == null || fs2.length == 0) {
            return null;
        }
        String[] f2 = new String[fs2.length];
        for (int i = 0; i < fs2.length; ++i) {
            String filter2 = fs2[i];
            if (filter2.endsWith("*")) {
                filter2 = filter2.substring(0, filter2.length() - 1);
            }
            f2[i] = filter2;
        }
        return f2;
    }

    private static String[] filters2FNFilters(String[] fs2) {
        if (fs2 == null || fs2.length == 0) {
            return null;
        }
        String[] f2 = new String[fs2.length];
        for (int i = 0; i < fs2.length; ++i) {
            f2[i] = fs2[i].replace('.', '/');
        }
        return f2;
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        int i;
        if (this.negativeFilters != null) {
            for (i = 0; i < this.negativeFilters.length; ++i) {
                if (!name.startsWith(this.negativeFilters[i])) continue;
                throw new ClassNotFoundException(name);
            }
        }
        if (this.filters != null) {
            for (i = 0; i < this.filters.length; ++i) {
                if (!name.startsWith(this.filters[i])) continue;
                return super.loadClass(name, resolve);
            }
        } else {
            return super.loadClass(name, resolve);
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    public URL getResource(String name) {
        int i;
        if (this.negativeFNFilters != null) {
            for (i = 0; i < this.negativeFNFilters.length; ++i) {
                if (!name.startsWith(this.negativeFNFilters[i])) continue;
                return null;
            }
        }
        if (this.fnFilters != null) {
            for (i = 0; i < this.fnFilters.length; ++i) {
                if (!name.startsWith(this.fnFilters[i])) continue;
                return super.getResource(name);
            }
        } else {
            return super.getResource(name);
        }
        return null;
    }

    public String[] getFilters() {
        if (this.filters == null) {
            return null;
        }
        return (String[])this.filters.clone();
    }

    public String[] getNegativeFilters() {
        if (this.negativeFilters == null) {
            return null;
        }
        return (String[])this.negativeFilters.clone();
    }
}

