/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.common.i18n;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.cxf.common.util.PackageUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BundleUtils {
    private static final String MESSAGE_BUNDLE = ".Messages";

    private BundleUtils() {
    }

    public static String getBundleName(Class<?> cls) {
        return PackageUtils.getPackageName(cls) + MESSAGE_BUNDLE;
    }

    public static String getBundleName(Class<?> cls, String name) {
        return PackageUtils.getPackageName(cls) + "." + name;
    }

    public static ResourceBundle getBundle(Class<?> cls) {
        try {
            return ResourceBundle.getBundle(BundleUtils.getBundleName(cls), Locale.getDefault(), cls.getClassLoader());
        }
        catch (MissingResourceException ex2) {
            return ResourceBundle.getBundle(BundleUtils.getBundleName(cls), Locale.getDefault(), Thread.currentThread().getContextClassLoader());
        }
    }

    public static ResourceBundle getBundle(Class<?> cls, String name) {
        try {
            return ResourceBundle.getBundle(BundleUtils.getBundleName(cls, name), Locale.getDefault(), cls.getClassLoader());
        }
        catch (MissingResourceException ex2) {
            return ResourceBundle.getBundle(BundleUtils.getBundleName(cls, name), Locale.getDefault(), Thread.currentThread().getContextClassLoader());
        }
    }

    public static String getFormattedString(ResourceBundle b, String key, Object ... params2) {
        return MessageFormat.format(b.getString(key), params2);
    }
}

