/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.common.logging;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public abstract class AbstractDelegatingLogger
extends Logger {
    protected AbstractDelegatingLogger(String name, String resourceBundleName) {
        super(name, resourceBundleName);
    }

    public void log(LogRecord record2) {
        if (this.isLoggable(record2.getLevel())) {
            this.doLog(record2);
        }
    }

    public void log(Level level2, String msg) {
        if (this.isLoggable(level2)) {
            LogRecord lr = new LogRecord(level2, msg);
            this.doLog(lr);
        }
    }

    public void log(Level level2, String msg, Object param1) {
        if (this.isLoggable(level2)) {
            LogRecord lr = new LogRecord(level2, msg);
            Object[] params2 = new Object[]{param1};
            lr.setParameters(params2);
            this.doLog(lr);
        }
    }

    public void log(Level level2, String msg, Object[] params2) {
        if (this.isLoggable(level2)) {
            LogRecord lr = new LogRecord(level2, msg);
            lr.setParameters(params2);
            this.doLog(lr);
        }
    }

    public void log(Level level2, String msg, Throwable thrown) {
        if (this.isLoggable(level2)) {
            LogRecord lr = new LogRecord(level2, msg);
            lr.setThrown(thrown);
            this.doLog(lr);
        }
    }

    public void logp(Level level2, String sourceClass, String sourceMethod, String msg) {
        if (this.isLoggable(level2)) {
            LogRecord lr = new LogRecord(level2, msg);
            lr.setSourceClassName(sourceClass);
            lr.setSourceMethodName(sourceMethod);
            this.doLog(lr);
        }
    }

    public void logp(Level level2, String sourceClass, String sourceMethod, String msg, Object param1) {
        if (this.isLoggable(level2)) {
            LogRecord lr = new LogRecord(level2, msg);
            lr.setSourceClassName(sourceClass);
            lr.setSourceMethodName(sourceMethod);
            Object[] params2 = new Object[]{param1};
            lr.setParameters(params2);
            this.doLog(lr);
        }
    }

    public void logp(Level level2, String sourceClass, String sourceMethod, String msg, Object[] params2) {
        if (this.isLoggable(level2)) {
            LogRecord lr = new LogRecord(level2, msg);
            lr.setSourceClassName(sourceClass);
            lr.setSourceMethodName(sourceMethod);
            lr.setParameters(params2);
            this.doLog(lr);
        }
    }

    public void logp(Level level2, String sourceClass, String sourceMethod, String msg, Throwable thrown) {
        if (this.isLoggable(level2)) {
            LogRecord lr = new LogRecord(level2, msg);
            lr.setSourceClassName(sourceClass);
            lr.setSourceMethodName(sourceMethod);
            lr.setThrown(thrown);
            this.doLog(lr);
        }
    }

    public void logrb(Level level2, String sourceClass, String sourceMethod, String bundleName, String msg) {
        if (this.isLoggable(level2)) {
            LogRecord lr = new LogRecord(level2, msg);
            lr.setSourceClassName(sourceClass);
            lr.setSourceMethodName(sourceMethod);
            this.doLog(lr, bundleName);
        }
    }

    public void logrb(Level level2, String sourceClass, String sourceMethod, String bundleName, String msg, Object param1) {
        if (this.isLoggable(level2)) {
            LogRecord lr = new LogRecord(level2, msg);
            lr.setSourceClassName(sourceClass);
            lr.setSourceMethodName(sourceMethod);
            Object[] params2 = new Object[]{param1};
            lr.setParameters(params2);
            this.doLog(lr, bundleName);
        }
    }

    public void logrb(Level level2, String sourceClass, String sourceMethod, String bundleName, String msg, Object[] params2) {
        if (this.isLoggable(level2)) {
            LogRecord lr = new LogRecord(level2, msg);
            lr.setSourceClassName(sourceClass);
            lr.setSourceMethodName(sourceMethod);
            lr.setParameters(params2);
            this.doLog(lr, bundleName);
        }
    }

    public void logrb(Level level2, String sourceClass, String sourceMethod, String bundleName, String msg, Throwable thrown) {
        if (this.isLoggable(level2)) {
            LogRecord lr = new LogRecord(level2, msg);
            lr.setSourceClassName(sourceClass);
            lr.setSourceMethodName(sourceMethod);
            lr.setThrown(thrown);
            this.doLog(lr, bundleName);
        }
    }

    public void entering(String sourceClass, String sourceMethod) {
        if (this.isLoggable(Level.FINER)) {
            this.logp(Level.FINER, sourceClass, sourceMethod, "ENTRY");
        }
    }

    public void entering(String sourceClass, String sourceMethod, Object param1) {
        if (this.isLoggable(Level.FINER)) {
            Object[] params2 = new Object[]{param1};
            this.logp(Level.FINER, sourceClass, sourceMethod, "ENTRY {0}", params2);
        }
    }

    public void entering(String sourceClass, String sourceMethod, Object[] params2) {
        if (this.isLoggable(Level.FINER)) {
            String msg = "ENTRY";
            if (params2 == null) {
                this.logp(Level.FINER, sourceClass, sourceMethod, msg);
                return;
            }
            StringBuilder builder = new StringBuilder(msg);
            for (int i = 0; i < params2.length; ++i) {
                builder.append(" {");
                builder.append(Integer.toString(i));
                builder.append("}");
            }
            this.logp(Level.FINER, sourceClass, sourceMethod, builder.toString(), params2);
        }
    }

    public void exiting(String sourceClass, String sourceMethod) {
        if (this.isLoggable(Level.FINER)) {
            this.logp(Level.FINER, sourceClass, sourceMethod, "RETURN");
        }
    }

    public void exiting(String sourceClass, String sourceMethod, Object result2) {
        if (this.isLoggable(Level.FINER)) {
            Object[] params2 = new Object[]{result2};
            this.logp(Level.FINER, sourceClass, sourceMethod, "RETURN {0}", params2);
        }
    }

    public void throwing(String sourceClass, String sourceMethod, Throwable thrown) {
        if (this.isLoggable(Level.FINER)) {
            LogRecord lr = new LogRecord(Level.FINER, "THROW");
            lr.setSourceClassName(sourceClass);
            lr.setSourceMethodName(sourceMethod);
            lr.setThrown(thrown);
            this.doLog(lr);
        }
    }

    public void severe(String msg) {
        if (this.isLoggable(Level.SEVERE)) {
            LogRecord lr = new LogRecord(Level.SEVERE, msg);
            this.doLog(lr);
        }
    }

    public void warning(String msg) {
        if (this.isLoggable(Level.WARNING)) {
            LogRecord lr = new LogRecord(Level.WARNING, msg);
            this.doLog(lr);
        }
    }

    public void info(String msg) {
        if (this.isLoggable(Level.INFO)) {
            LogRecord lr = new LogRecord(Level.INFO, msg);
            this.doLog(lr);
        }
    }

    public void config(String msg) {
        if (this.isLoggable(Level.CONFIG)) {
            LogRecord lr = new LogRecord(Level.CONFIG, msg);
            this.doLog(lr);
        }
    }

    public void fine(String msg) {
        if (this.isLoggable(Level.FINE)) {
            LogRecord lr = new LogRecord(Level.FINE, msg);
            this.doLog(lr);
        }
    }

    public void finer(String msg) {
        if (this.isLoggable(Level.FINER)) {
            LogRecord lr = new LogRecord(Level.FINER, msg);
            this.doLog(lr);
        }
    }

    public void finest(String msg) {
        if (this.isLoggable(Level.FINEST)) {
            LogRecord lr = new LogRecord(Level.FINEST, msg);
            this.doLog(lr);
        }
    }

    public void setLevel(Level newLevel) throws SecurityException {
        throw new UnsupportedOperationException();
    }

    public abstract Level getLevel();

    public boolean isLoggable(Level level2) {
        Level l = this.getLevel();
        return level2.intValue() >= l.intValue() && l != Level.OFF;
    }

    public synchronized void addHandler(Handler handler) throws SecurityException {
        throw new UnsupportedOperationException();
    }

    public synchronized void removeHandler(Handler handler) throws SecurityException {
        throw new UnsupportedOperationException();
    }

    public synchronized Handler[] getHandlers() {
        throw new UnsupportedOperationException();
    }

    public synchronized void setUseParentHandlers(boolean useParentHandlers) {
        throw new UnsupportedOperationException();
    }

    public synchronized boolean getUseParentHandlers() {
        throw new UnsupportedOperationException();
    }

    public Logger getParent() {
        return null;
    }

    public void setParent(Logger parent2) {
        throw new UnsupportedOperationException();
    }

    protected void doLog(LogRecord lr) {
        lr.setLoggerName(this.getName());
        String rbname = this.getResourceBundleName();
        if (rbname != null) {
            lr.setResourceBundleName(rbname);
            lr.setResourceBundle(this.getResourceBundle());
        }
        this.internalLog(lr);
    }

    protected void doLog(LogRecord lr, String rbname) {
        lr.setLoggerName(this.getName());
        if (rbname != null) {
            lr.setResourceBundleName(rbname);
            lr.setResourceBundle(AbstractDelegatingLogger.loadResourceBundle(rbname));
        }
        this.internalLog(lr);
    }

    protected void internalLog(LogRecord record2) {
        Filter filter2 = this.getFilter();
        if (filter2 != null && !filter2.isLoggable(record2)) {
            return;
        }
        String msg = this.formatMessage(record2);
        this.internalLogFormatted(msg, record2);
    }

    protected abstract void internalLogFormatted(String var1, LogRecord var2);

    protected String formatMessage(LogRecord record2) {
        String format2 = record2.getMessage();
        ResourceBundle catalog = record2.getResourceBundle();
        if (catalog != null) {
            try {
                format2 = catalog.getString(record2.getMessage());
            }
            catch (MissingResourceException ex2) {
                format2 = record2.getMessage();
            }
        }
        try {
            Object[] parameters2 = record2.getParameters();
            if (parameters2 == null || parameters2.length == 0) {
                return format2;
            }
            if (format2.indexOf("{0") >= 0 || format2.indexOf("{1") >= 0 || format2.indexOf("{2") >= 0 || format2.indexOf("{3") >= 0) {
                return MessageFormat.format(format2, parameters2);
            }
            return format2;
        }
        catch (Exception ex3) {
            return format2;
        }
    }

    static ResourceBundle loadResourceBundle(String resourceBundleName) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (null != cl) {
            try {
                return ResourceBundle.getBundle(resourceBundleName, Locale.getDefault(), cl);
            }
            catch (MissingResourceException e2) {
                // empty catch block
            }
        }
        if (null != (cl = ClassLoader.getSystemClassLoader())) {
            try {
                return ResourceBundle.getBundle(resourceBundleName, Locale.getDefault(), cl);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return null;
    }
}

