/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.common.logging;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.logging.AbstractDelegatingLogger;
import org.apache.cxf.common.logging.JDKBugHacks;
import org.apache.cxf.common.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LogUtils {
    public static final String KEY = "org.apache.cxf.Logger";
    private static final Object[] NO_PARAMETERS;
    private static Class<?> loggerClass;

    private LogUtils() {
    }

    public static void setLoggerClass(Class<? extends AbstractDelegatingLogger> cls) {
        loggerClass = cls;
    }

    public static Logger getLogger(Class<?> cls) {
        return LogUtils.createLogger(cls, null, cls.getName());
    }

    public static Logger getLogger(Class<?> cls, String resourcename) {
        return LogUtils.createLogger(cls, resourcename, cls.getName());
    }

    public static Logger getLogger(Class<?> cls, String resourcename, String loggerName) {
        return LogUtils.createLogger(cls, resourcename, loggerName);
    }

    public static Logger getL7dLogger(Class<?> cls) {
        return LogUtils.createLogger(cls, null, cls.getName());
    }

    public static Logger getL7dLogger(Class<?> cls, String resourcename) {
        return LogUtils.createLogger(cls, resourcename, cls.getName());
    }

    public static Logger getL7dLogger(Class<?> cls, String resourcename, String loggerName) {
        return LogUtils.createLogger(cls, resourcename, loggerName);
    }

    protected static Logger createLogger(Class<?> cls, String name, String loggerName) {
        if (loggerClass != null) {
            try {
                Constructor<?> cns = loggerClass.getConstructor(String.class, String.class);
                if (name == null) {
                    try {
                        return (Logger)cns.newInstance(loggerName, BundleUtils.getBundleName(cls));
                    }
                    catch (InvocationTargetException ite) {
                        if (ite.getTargetException() instanceof MissingResourceException) {
                            return (Logger)cns.newInstance(loggerName, null);
                        }
                        throw ite;
                    }
                }
                try {
                    return (Logger)cns.newInstance(loggerName, BundleUtils.getBundleName(cls, name));
                }
                catch (InvocationTargetException ite) {
                    if (ite.getTargetException() instanceof MissingResourceException) {
                        throw (MissingResourceException)ite.getTargetException();
                    }
                    throw ite;
                }
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
        }
        if (name == null) {
            try {
                return Logger.getLogger(loggerName, BundleUtils.getBundleName(cls));
            }
            catch (MissingResourceException rex) {
                return Logger.getLogger(loggerName, null);
            }
        }
        return Logger.getLogger(loggerName, BundleUtils.getBundleName(cls, name));
    }

    public static void log(Logger logger, Level level2, String message, Throwable throwable2, Object parameter) {
        if (logger.isLoggable(level2)) {
            String formattedMessage = MessageFormat.format(LogUtils.localize(logger, message), parameter);
            LogUtils.doLog(logger, level2, formattedMessage, throwable2);
        }
    }

    public static void log(Logger logger, Level level2, String message, Throwable throwable2, Object ... parameters2) {
        if (logger.isLoggable(level2)) {
            String formattedMessage = MessageFormat.format(LogUtils.localize(logger, message), parameters2);
            LogUtils.doLog(logger, level2, formattedMessage, throwable2);
        }
    }

    public static void log(Logger logger, Level level2, String message) {
        LogUtils.log(logger, level2, message, NO_PARAMETERS);
    }

    public static void log(Logger logger, Level level2, String message, Throwable throwable2) {
        LogUtils.log(logger, level2, message, throwable2, NO_PARAMETERS);
    }

    public static void log(Logger logger, Level level2, String message, Object parameter) {
        LogUtils.log(logger, level2, message, new Object[]{parameter});
    }

    public static void log(Logger logger, Level level2, String message, Object[] parameters2) {
        if (logger.isLoggable(level2)) {
            String msg = LogUtils.localize(logger, message);
            try {
                msg = MessageFormat.format(msg, parameters2);
            }
            catch (IllegalArgumentException ex2) {
                // empty catch block
            }
            LogUtils.doLog(logger, level2, msg, null);
        }
    }

    private static void doLog(Logger log2, Level level2, String msg, Throwable t2) {
        LogRecord record2 = new LogRecord(level2, msg);
        record2.setLoggerName(log2.getName());
        record2.setResourceBundleName(log2.getResourceBundleName());
        record2.setResourceBundle(log2.getResourceBundle());
        if (t2 != null) {
            record2.setThrown(t2);
        }
        StackTraceElement[] stack = new Throwable().getStackTrace();
        String cname = LogUtils.class.getName();
        for (int x = 0; x < stack.length; ++x) {
            StackTraceElement frame = stack[x];
            if (frame.getClassName().equals(cname)) continue;
            record2.setSourceClassName(frame.getClassName());
            record2.setSourceMethodName(frame.getMethodName());
            break;
        }
        log2.log(record2);
    }

    private static String localize(Logger logger, String message) {
        ResourceBundle bundle = logger.getResourceBundle();
        try {
            return bundle != null ? bundle.getString(message) : message;
        }
        catch (MissingResourceException ex2) {
            return message;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        block15: {
            NO_PARAMETERS = new Object[0];
            JDKBugHacks.doHacks();
            try {
                String cname = System.getProperty(KEY);
                if (StringUtils.isEmpty(cname)) {
                    InputStream ins2 = Thread.currentThread().getContextClassLoader().getResourceAsStream("META-INF/cxf/org.apache.cxf.Logger");
                    if (ins2 == null) {
                        ins2 = ClassLoader.getSystemResourceAsStream("META-INF/cxf/org.apache.cxf.Logger");
                    }
                    if (ins2 != null) {
                        BufferedReader din = new BufferedReader(new InputStreamReader(ins2));
                        try {
                            cname = din.readLine();
                        }
                        finally {
                            din.close();
                        }
                    }
                }
                if (StringUtils.isEmpty(cname)) {
                    Class.forName("org.slf4j.impl.StaticLoggerBinder");
                    Class<?> cls = Class.forName("org.slf4j.LoggerFactory");
                    Class<?> fcls = cls.getMethod("getILoggerFactory", new Class[0]).invoke(null, new Object[0]).getClass();
                    if (fcls.getName().contains("Log4j")) {
                        cname = "org.apache.cxf.common.logging.Log4jLogger";
                    } else if (fcls.getName().contains("JCL") && (fcls = (cls = Class.forName("org.apache.commons.logging.LogFactory")).getMethod("getFactory", new Class[0]).invoke(null, new Object[0]).getClass()).getName().contains("Log4j")) {
                        cname = "org.apache.cxf.common.logging.Log4jLogger";
                    }
                }
                if (StringUtils.isEmpty(cname)) break block15;
                try {
                    loggerClass = Class.forName(cname.trim(), true, Thread.currentThread().getContextClassLoader());
                }
                catch (Throwable ex2) {
                    loggerClass = Class.forName(cname.trim());
                }
                LogUtils.getLogger(LogUtils.class).fine("Using " + loggerClass.getName() + " for logging.");
            }
            catch (Throwable ex3) {
                loggerClass = null;
            }
        }
    }
}

