/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.common.logging;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.cxf.common.logging.AbstractDelegatingLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Slf4jLogger
extends AbstractDelegatingLogger {
    private final Logger logger;

    public Slf4jLogger(String name, String resourceBundleName) {
        super(name, resourceBundleName);
        this.logger = LoggerFactory.getLogger(name);
    }

    public Level getLevel() {
        Level level2 = this.logger.isTraceEnabled() ? Level.FINER : (this.logger.isDebugEnabled() ? Level.FINER : (this.logger.isInfoEnabled() ? Level.INFO : (this.logger.isWarnEnabled() ? Level.WARNING : (this.logger.isErrorEnabled() ? Level.SEVERE : Level.OFF))));
        return level2;
    }

    protected void internalLogFormatted(String msg, LogRecord record2) {
        Level level2 = record2.getLevel();
        Throwable t2 = record2.getThrown();
        if (Level.FINE.equals(level2)) {
            this.logger.debug(msg, t2);
        } else if (Level.INFO.equals(level2)) {
            this.logger.info(msg, t2);
        } else if (Level.WARNING.equals(level2)) {
            this.logger.warn(msg, t2);
        } else if (Level.FINER.equals(level2)) {
            this.logger.trace(msg, t2);
        } else if (Level.FINEST.equals(level2)) {
            this.logger.trace(msg, t2);
        } else if (Level.ALL.equals(level2)) {
            this.logger.error(msg, t2);
        } else if (Level.SEVERE.equals(level2)) {
            this.logger.error(msg, t2);
        } else if (Level.CONFIG.equals(level2)) {
            this.logger.debug(msg, t2);
        } else if (Level.OFF.equals(level2)) {
            // empty if block
        }
    }
}

