/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.common.util;

import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.cxf.common.util.WeakIdentityHashMap;
import org.objectweb.asm.ClassWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASMHelper {
    protected static final Map<Class<?>, String> PRIMITIVE_MAP = new HashMap();
    protected static final Map<Class<?>, String> NONPRIMITIVE_MAP = new HashMap();
    protected static final Map<Class<?>, WeakReference<TypeHelperClassLoader>> LOADER_MAP = new WeakIdentityHashMap();
    protected static boolean oldASM;

    protected static String getMethodSignature(Method m) {
        StringBuilder buf = new StringBuilder("(");
        for (Class<?> cl : m.getParameterTypes()) {
            buf.append(ASMHelper.getClassCode(cl));
        }
        buf.append(")");
        buf.append(ASMHelper.getClassCode(m.getReturnType()));
        return buf.toString();
    }

    protected static String periodToSlashes(String s2) {
        char[] ch = s2.toCharArray();
        for (int x = 0; x < ch.length; ++x) {
            if (ch[x] != '.') continue;
            ch[x] = 47;
        }
        return new String(ch);
    }

    public static String getClassCode(Class<?> cl) {
        if (cl == Void.TYPE) {
            return "V";
        }
        if (cl.isPrimitive()) {
            return PRIMITIVE_MAP.get(cl);
        }
        if (cl.isArray()) {
            return "[" + ASMHelper.getClassCode(cl.getComponentType());
        }
        return "L" + ASMHelper.periodToSlashes(cl.getName()) + ";";
    }

    public static String getClassCode(Type type) {
        if (type instanceof Class) {
            return ASMHelper.getClassCode((Class)type);
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType at = (GenericArrayType)type;
            return "[" + ASMHelper.getClassCode(at.getGenericComponentType());
        }
        if (type instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)type;
            Type[] bounds = tv.getBounds();
            if (bounds != null && bounds.length == 1) {
                return ASMHelper.getClassCode(bounds[0]);
            }
            throw new IllegalArgumentException("Unable to determine type for: " + tv);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            StringBuilder a2 = new StringBuilder(ASMHelper.getClassCode(pt.getRawType()));
            a2.setLength(a2.length() - 1);
            a2.append('<');
            for (Type t2 : pt.getActualTypeArguments()) {
                a2.append(ASMHelper.getClassCode(t2));
            }
            a2.append(">;");
            return a2.toString();
        }
        if (type instanceof WildcardType) {
            Type[] upBounds;
            WildcardType wt = (WildcardType)type;
            StringBuilder a3 = new StringBuilder();
            Type[] lowBounds = wt.getLowerBounds();
            for (Type t3 : upBounds = wt.getUpperBounds()) {
                a3.append("+");
                a3.append(ASMHelper.getClassCode(t3));
            }
            for (Type t3 : lowBounds) {
                a3.append("-");
                a3.append(ASMHelper.getClassCode(t3));
            }
            return a3.toString();
        }
        return null;
    }

    public ClassWriter createClassWriter() {
        ClassWriter newCw = null;
        if (!oldASM) {
            Class<ClassWriter> cls;
            try {
                cls = ClassWriter.class;
            }
            catch (NoClassDefFoundError error2) {
                throw new RuntimeException("No ASM ClassWriterFound", error2);
            }
            try {
                Constructor cons2 = cls.getConstructor(Boolean.TYPE);
                try {
                    cls.getMethod("newConstInt", Integer.TYPE);
                    newCw = null;
                    oldASM = true;
                }
                catch (Throwable t2) {
                    newCw = (ClassWriter)cons2.newInstance(Boolean.TRUE);
                }
            }
            catch (Throwable e2) {
                try {
                    Constructor cons3 = cls.getConstructor(Integer.TYPE);
                    int i = cls.getField("COMPUTE_MAXS").getInt(null);
                    newCw = (ClassWriter)cons3.newInstance(i |= cls.getField("COMPUTE_FRAMES").getInt(null));
                }
                catch (Throwable e1) {
                    // empty catch block
                }
            }
        }
        return newCw;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> loadClass(String className, Class clz, byte[] bytes2) {
        TypeHelperClassLoader loader;
        TypeHelperClassLoader typeHelperClassLoader = loader = ASMHelper.getTypeHelperClassLoader(clz);
        synchronized (typeHelperClassLoader) {
            Class<?> cls = loader.lookupDefinedClass(className);
            if (cls == null) {
                return loader.defineClass(className, bytes2);
            }
            return cls;
        }
    }

    public Class<?> findClass(String className, Class clz) {
        TypeHelperClassLoader loader = ASMHelper.getTypeHelperClassLoader(clz);
        return loader.lookupDefinedClass(className);
    }

    private static synchronized TypeHelperClassLoader getTypeHelperClassLoader(Class<?> l) {
        TypeHelperClassLoader ret;
        WeakReference<TypeHelperClassLoader> ref = LOADER_MAP.get(l);
        if (ref == null || ref.get() == null) {
            ret = new TypeHelperClassLoader(l.getClassLoader());
            LOADER_MAP.put(l, new WeakReference<TypeHelperClassLoader>(ret));
        } else {
            ret = (TypeHelperClassLoader)ref.get();
        }
        return ret;
    }

    static {
        PRIMITIVE_MAP.put(Byte.TYPE, "B");
        PRIMITIVE_MAP.put(Boolean.TYPE, "Z");
        PRIMITIVE_MAP.put(Long.TYPE, "J");
        PRIMITIVE_MAP.put(Integer.TYPE, "I");
        PRIMITIVE_MAP.put(Short.TYPE, "S");
        PRIMITIVE_MAP.put(Character.TYPE, "C");
        PRIMITIVE_MAP.put(Float.TYPE, "F");
        PRIMITIVE_MAP.put(Double.TYPE, "D");
        NONPRIMITIVE_MAP.put(Byte.TYPE, Byte.class.getName().replaceAll("\\.", "/"));
        NONPRIMITIVE_MAP.put(Boolean.TYPE, Boolean.class.getName().replaceAll("\\.", "/"));
        NONPRIMITIVE_MAP.put(Long.TYPE, Long.class.getName().replaceAll("\\.", "/"));
        NONPRIMITIVE_MAP.put(Integer.TYPE, Integer.class.getName().replaceAll("\\.", "/"));
        NONPRIMITIVE_MAP.put(Short.TYPE, Short.class.getName().replaceAll("\\.", "/"));
        NONPRIMITIVE_MAP.put(Character.TYPE, Character.class.getName().replaceAll("\\.", "/"));
        NONPRIMITIVE_MAP.put(Float.TYPE, Float.class.getName().replaceAll("\\.", "/"));
        NONPRIMITIVE_MAP.put(Double.TYPE, Double.class.getName().replaceAll("\\.", "/"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TypeHelperClassLoader
    extends ClassLoader {
        Map<String, Class<?>> defined = new ConcurrentHashMap();

        TypeHelperClassLoader(ClassLoader parent2) {
            super(parent2);
        }

        public Class<?> lookupDefinedClass(String name) {
            return this.defined.get(name.replace('/', '.'));
        }

        public synchronized Class<?> defineClass(String name, byte[] bytes2) {
            Package p;
            Class<?> ret = this.defined.get(name.replace('/', '.'));
            if (ret != null) {
                return ret;
            }
            if (name.endsWith("package-info") && (p = super.getPackage(name.substring(0, name.length() - 13))) == null) {
                this.definePackage(name.substring(0, name.length() - 13).replace('/', '.'), null, null, null, null, null, null, null);
            }
            ret = super.defineClass(name.replace('/', '.'), bytes2, 0, bytes2.length);
            this.defined.put(name.replace('/', '.'), ret);
            return ret;
        }
    }
}

