/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.common.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassReader
extends ByteArrayInputStream {
    private static final int CONSTANT_CLASS = 7;
    private static final int CONSTANT_FIELDREF = 9;
    private static final int CONSTANT_METHODREF = 10;
    private static final int CONSTANT_INTERFACE_METHOD_REF = 11;
    private static final int CONSTANT_STRING = 8;
    private static final int CONSTANT_INTEGER = 3;
    private static final int CONSTANT_FLOAT = 4;
    private static final int CONSTANT_LONG = 5;
    private static final int CONSTANT_DOUBLE = 6;
    private static final int CONSTANT_NAME_AND_TYPE = 12;
    private static final int CONSTANT_UTF_8 = 1;
    private int[] cpoolIndex;
    private Object[] cpool;
    private Map<String, Method> attrMethods;

    protected ClassReader(byte[] buf, Map<String, Method> attrMethods) {
        super(buf);
        this.attrMethods = attrMethods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static byte[] getBytes(Class c2) throws IOException {
        byte[] byArray;
        InputStream fin = c2.getResourceAsStream('/' + c2.getName().replace('.', '/') + ".class");
        if (fin == null) {
            throw new IOException();
        }
        try {
            int actual;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            do {
                if ((actual = fin.read(buf)) <= 0) continue;
                out.write(buf, 0, actual);
            } while (actual > 0);
            byArray = out.toByteArray();
            Object var7_6 = null;
        }
        catch (Throwable throwable2) {
            Object var7_7 = null;
            fin.close();
            throw throwable2;
        }
        fin.close();
        return byArray;
    }

    static String classDescriptorToName(String desc) {
        return desc.replace('/', '.');
    }

    protected static Map<String, Method> findAttributeReaders(Class c2) {
        HashMap<String, Method> map3 = new HashMap<String, Method>();
        Method[] methods2 = c2.getMethods();
        for (int i = 0; i < methods2.length; ++i) {
            String name = methods2[i].getName();
            if (!name.startsWith("read") || methods2[i].getReturnType() != Void.TYPE) continue;
            map3.put(name.substring(4), methods2[i]);
        }
        return map3;
    }

    protected static String getSignature(Member method, Class[] paramTypes2) {
        StringBuilder b = new StringBuilder(method instanceof Method ? method.getName() : "<init>");
        b.append('(');
        for (int i = 0; i < paramTypes2.length; ++i) {
            ClassReader.addDescriptor(b, paramTypes2[i]);
        }
        b.append(')');
        if (method instanceof Method) {
            ClassReader.addDescriptor(b, ((Method)method).getReturnType());
        } else if (method instanceof Constructor) {
            ClassReader.addDescriptor(b, Void.TYPE);
        }
        return b.toString();
    }

    private static void addDescriptor(StringBuilder b, Class c2) {
        if (c2.isPrimitive()) {
            if (c2 == Void.TYPE) {
                b.append('V');
            } else if (c2 == Integer.TYPE) {
                b.append('I');
            } else if (c2 == Boolean.TYPE) {
                b.append('Z');
            } else if (c2 == Byte.TYPE) {
                b.append('B');
            } else if (c2 == Short.TYPE) {
                b.append('S');
            } else if (c2 == Long.TYPE) {
                b.append('J');
            } else if (c2 == Character.TYPE) {
                b.append('C');
            } else if (c2 == Float.TYPE) {
                b.append('F');
            } else if (c2 == Double.TYPE) {
                b.append('D');
            }
        } else if (c2.isArray()) {
            b.append('[');
            ClassReader.addDescriptor(b, c2.getComponentType());
        } else {
            b.append('L').append(c2.getName().replace('.', '/')).append(';');
        }
    }

    protected final int readShort() {
        return this.read() << 8 | this.read();
    }

    protected final int readInt() {
        return this.read() << 24 | this.read() << 16 | this.read() << 8 | this.read();
    }

    protected void skipFully(int n) throws IOException {
        while (n > 0) {
            int c2 = (int)this.skip(n);
            if (c2 <= 0) {
                throw new EOFException();
            }
            n -= c2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final Member resolveMethod(int index2) throws IOException, ClassNotFoundException, NoSuchMethodException {
        Constructor<?> constructor;
        int oldPos = this.pos;
        try {
            Executable m = (Constructor<?>)this.cpool[index2];
            if (m == null) {
                this.pos = this.cpoolIndex[index2];
                Class owner = this.resolveClass(this.readShort());
                NameAndType nt = this.resolveNameAndType(this.readShort());
                String signature2 = nt.name + nt.type;
                if ("<init>".equals(nt.name)) {
                    Constructor<?>[] ctors = owner.getConstructors();
                    int i = 0;
                    while (i < ctors.length) {
                        String sig = ClassReader.getSignature(ctors[i], ctors[i].getParameterTypes());
                        if (sig.equals(signature2)) {
                            this.cpool[index2] = ctors[i];
                            Executable executable = m = ctors[i];
                            Object var12_16 = null;
                            this.pos = oldPos;
                            return executable;
                        }
                        ++i;
                    }
                    throw new NoSuchMethodException(signature2);
                }
                Method[] methods2 = owner.getDeclaredMethods();
                int i = 0;
                while (i < methods2.length) {
                    String sig = ClassReader.getSignature(methods2[i], methods2[i].getParameterTypes());
                    if (sig.equals(signature2)) {
                        this.cpool[index2] = methods2[i];
                        Executable executable = m = methods2[i];
                        Object var12_17 = null;
                        this.pos = oldPos;
                        return executable;
                    }
                    ++i;
                }
                throw new NoSuchMethodException(signature2);
            }
            constructor = m;
        }
        catch (Throwable throwable2) {
            Object var12_19 = null;
            this.pos = oldPos;
            throw throwable2;
        }
        Object var12_18 = null;
        this.pos = oldPos;
        return constructor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Field resolveField(int i) throws IOException, ClassNotFoundException, NoSuchFieldException {
        int oldPos = this.pos;
        try {
            Field f2 = (Field)this.cpool[i];
            if (f2 == null) {
                this.pos = this.cpoolIndex[i];
                Class owner = this.resolveClass(this.readShort());
                NameAndType nt = this.resolveNameAndType(this.readShort());
                this.cpool[i] = owner.getDeclaredField(nt.name);
                f2 = owner.getDeclaredField(nt.name);
            }
            Field field2 = f2;
            Object var7_6 = null;
            this.pos = oldPos;
            return field2;
        }
        catch (Throwable throwable2) {
            Object var7_7 = null;
            this.pos = oldPos;
            throw throwable2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final NameAndType resolveNameAndType(int i) throws IOException {
        int oldPos = this.pos;
        try {
            NameAndType nt = (NameAndType)this.cpool[i];
            if (nt == null) {
                this.pos = this.cpoolIndex[i];
                String name = this.resolveUtf8(this.readShort());
                String type = this.resolveUtf8(this.readShort());
                this.cpool[i] = new NameAndType(name, type);
                nt = new NameAndType(name, type);
            }
            NameAndType nameAndType = nt;
            Object var7_6 = null;
            this.pos = oldPos;
            return nameAndType;
        }
        catch (Throwable throwable2) {
            Object var7_7 = null;
            this.pos = oldPos;
            throw throwable2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Class resolveClass(int i) throws IOException, ClassNotFoundException {
        int oldPos = this.pos;
        try {
            Class<?> c2 = (Class<?>)this.cpool[i];
            if (c2 == null) {
                this.pos = this.cpoolIndex[i];
                String name = this.resolveUtf8(this.readShort());
                this.cpool[i] = Class.forName(ClassReader.classDescriptorToName(name));
                c2 = Class.forName(ClassReader.classDescriptorToName(name));
            }
            Class<?> clazz2 = c2;
            Object var6_5 = null;
            this.pos = oldPos;
            return clazz2;
        }
        catch (Throwable throwable2) {
            Object var6_6 = null;
            this.pos = oldPos;
            throw throwable2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final String resolveUtf8(int i) throws IOException {
        int oldPos = this.pos;
        try {
            String s2 = (String)this.cpool[i];
            if (s2 == null) {
                this.pos = this.cpoolIndex[i];
                int len2 = this.readShort();
                this.skipFully(len2);
                this.cpool[i] = new String(this.buf, this.pos - len2, len2, "utf-8");
                s2 = new String(this.buf, this.pos - len2, len2, "utf-8");
            }
            String string2 = s2;
            Object var6_6 = null;
            this.pos = oldPos;
            return string2;
        }
        catch (Throwable throwable2) {
            Object var6_7 = null;
            this.pos = oldPos;
            throw throwable2;
        }
    }

    protected final void readCpool() throws IOException {
        int count2 = this.readShort();
        this.cpoolIndex = new int[count2];
        this.cpool = new Object[count2];
        block7: for (int i = 1; i < count2; ++i) {
            int c2 = this.read();
            this.cpoolIndex[i] = this.pos;
            switch (c2) {
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    this.readShort();
                }
                case 7: 
                case 8: {
                    this.readShort();
                    continue block7;
                }
                case 5: 
                case 6: {
                    this.readInt();
                    ++i;
                }
                case 3: 
                case 4: {
                    this.readInt();
                    continue block7;
                }
                case 1: {
                    int len2 = this.readShort();
                    this.skipFully(len2);
                    continue block7;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    protected final void skipAttributes() throws IOException {
        int count2 = this.readShort();
        for (int i = 0; i < count2; ++i) {
            this.readShort();
            this.skipFully(this.readInt());
        }
    }

    protected final void readAttributes() throws IOException {
        int count2 = this.readShort();
        for (int i = 0; i < count2; ++i) {
            int nameIndex = this.readShort();
            int attrLen = this.readInt();
            int curPos = this.pos;
            String attrName = this.resolveUtf8(nameIndex);
            Method m = this.attrMethods.get(attrName);
            if (m != null) {
                try {
                    m.invoke((Object)this, new Object[0]);
                }
                catch (IllegalAccessException e2) {
                    this.pos = curPos;
                    this.skipFully(attrLen);
                }
                catch (InvocationTargetException e3) {
                    try {
                        throw e3.getTargetException();
                    }
                    catch (Error ex2) {
                        throw ex2;
                    }
                    catch (RuntimeException ex3) {
                        throw ex3;
                    }
                    catch (IOException ex4) {
                        throw ex4;
                    }
                    catch (Throwable ex5) {
                        this.pos = curPos;
                        this.skipFully(attrLen);
                    }
                }
                continue;
            }
            this.skipFully(attrLen);
        }
    }

    public void readCode() throws IOException {
        this.readShort();
        this.readShort();
        this.skipFully(this.readInt());
        this.skipFully(8 * this.readShort());
        this.readAttributes();
    }

    private static class NameAndType {
        String name;
        String type;

        public NameAndType(String name, String type) {
            this.name = name;
            this.type = type;
        }
    }
}

