/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.common.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.cxf.common.util.StreamPrinter;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Compiler {
    private long maxMemory = Runtime.getRuntime().maxMemory();
    private boolean verbose;
    private String target;
    private String outputDir;
    private String classPath;
    private boolean forceFork = Boolean.getBoolean(Compiler.class.getName() + "-fork");

    public void setMaxMemory(long l) {
        this.maxMemory = l;
    }

    public void setVerbose(boolean b) {
        this.verbose = b;
    }

    public void setTarget(String s2) {
        this.target = s2;
    }

    public void setOutputDir(File s2) {
        this.outputDir = s2 != null ? s2.getAbsolutePath().replace(File.pathSeparatorChar, '/') : null;
    }

    public void setOutputDir(String s2) {
        this.outputDir = s2.replace(File.pathSeparatorChar, '/');
    }

    public void setClassPath(String s2) {
        this.classPath = StringUtils.isEmpty(s2) ? null : s2;
    }

    private void addArgs(List<String> list2) {
        if (this.verbose) {
            list2.add("-verbose");
        }
        if (!StringUtils.isEmpty(this.target)) {
            list2.add("-target");
            list2.add(this.target);
        }
        if (!StringUtils.isEmpty(this.outputDir)) {
            list2.add("-d");
            list2.add(this.outputDir);
        }
        if (StringUtils.isEmpty(this.classPath)) {
            boolean classpathSetted;
            String javaClasspath = System.getProperty("java.class.path");
            boolean bl = classpathSetted = javaClasspath != null;
            if (!classpathSetted) {
                File f2 = new File(this.getClass().getClassLoader().getResource(".").getFile());
                if ((f2 = new File(f2, "../lib")).exists() && f2.isDirectory()) {
                    list2.add("-extdirs");
                    list2.add(f2.toString());
                }
            } else {
                list2.add("-classpath");
                list2.add(javaClasspath);
            }
        } else {
            list2.add("-classpath");
            list2.add(this.classPath);
        }
    }

    public boolean compileFiles(String[] files2) {
        String endorsed = System.getProperty("java.endorsed.dirs");
        if (!this.forceFork) {
            try {
                Class.forName("javax.tools.JavaCompiler");
                return this.useJava6Compiler(files2);
            }
            catch (Exception ex2) {
                // empty catch block
            }
        }
        ArrayList<String> list2 = new ArrayList<String>();
        String fsep = System.getProperty("file.separator");
        String javacstr = "javac";
        String platformjavacname = "javac";
        if (System.getProperty("os.name").toLowerCase().indexOf("windows") > -1) {
            platformjavacname = "javac.exe";
        }
        if (new File(System.getProperty("java.home") + fsep + platformjavacname).exists()) {
            javacstr = System.getProperty("java.home") + fsep + platformjavacname;
        } else if (new File(System.getProperty("java.home") + fsep + ".." + fsep + "bin" + fsep + platformjavacname).exists()) {
            javacstr = System.getProperty("java.home") + fsep + ".." + fsep + "bin" + fsep + platformjavacname;
        }
        list2.add(javacstr);
        if (!StringUtils.isEmpty(endorsed)) {
            list2.add("-endorseddirs");
            list2.add(endorsed);
        }
        list2.add("-J-Xmx" + this.maxMemory);
        this.addArgs(list2);
        int idx = list2.size();
        list2.addAll(Arrays.asList(files2));
        return this.internalCompile(list2.toArray(new String[list2.size()]), idx);
    }

    private boolean useJava6Compiler(String[] files2) throws Exception {
        Object compiler = Class.forName("javax.tools.ToolProvider").getMethod("getSystemJavaCompiler", new Class[0]).invoke(null, new Object[0]);
        Object fileManager = compiler.getClass().getMethod("getStandardFileManager", Class.forName("javax.tools.DiagnosticListener"), Locale.class, Charset.class).invoke(compiler, null, null, null);
        Object fileList = fileManager.getClass().getMethod("getJavaFileObjectsFromStrings", Iterable.class).invoke(fileManager, Arrays.asList(files2));
        ArrayList<String> args2 = new ArrayList<String>();
        this.addArgs(args2);
        Object task = compiler.getClass().getMethod("getTask", Writer.class, Class.forName("javax.tools.JavaFileManager"), Class.forName("javax.tools.DiagnosticListener"), Iterable.class, Iterable.class, Iterable.class).invoke(compiler, null, fileManager, null, args2, null, fileList);
        Boolean ret = (Boolean)task.getClass().getMethod("call", new Class[0]).invoke(task, new Object[0]);
        fileManager.getClass().getMethod("close", new Class[0]).invoke(fileManager, new Object[0]);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean internalCompile(String[] args2, int sourceFileIndex) {
        Process p = null;
        String[] cmdArray = null;
        File tmpFile = null;
        try {
            if (this.isLongCommandLines(args2) && sourceFileIndex >= 0) {
                PrintWriter out = null;
                tmpFile = FileUtils.createTempFile("cxf-compiler", null);
                out = new PrintWriter(new FileWriter(tmpFile));
                for (int i = sourceFileIndex; i < args2.length; ++i) {
                    if (args2[i].indexOf(" ") > -1) {
                        args2[i] = args2[i].replace(File.separatorChar, '/');
                        if (args2[i].indexOf("package-info.java") > -1 && System.getProperty("os.name").toLowerCase().indexOf("windows") > -1) {
                            out.println("\"" + args2[i].replaceAll("/", "\\\\\\\\") + "\"");
                            continue;
                        }
                        out.println("\"" + args2[i] + "\"");
                        continue;
                    }
                    out.println(args2[i]);
                }
                out.flush();
                out.close();
                cmdArray = new String[sourceFileIndex + 1];
                System.arraycopy(args2, 0, cmdArray, 0, sourceFileIndex);
                cmdArray[sourceFileIndex] = "@" + tmpFile;
            } else {
                cmdArray = new String[args2.length];
                System.arraycopy(args2, 0, cmdArray, 0, args2.length);
            }
            if (System.getProperty("os.name").toLowerCase().indexOf("windows") > -1) {
                for (int i = 0; i < cmdArray.length; ++i) {
                    if (cmdArray[i].indexOf("package-info") != -1) continue;
                    cmdArray[i] = cmdArray[i].replace('\\', '/');
                }
            }
            if ((p = Runtime.getRuntime().exec(cmdArray)).getErrorStream() != null) {
                StreamPrinter errorStreamPrinter = new StreamPrinter(p.getErrorStream(), "", System.out);
                errorStreamPrinter.start();
            }
            if (p.getInputStream() != null) {
                StreamPrinter infoStreamPrinter = new StreamPrinter(p.getInputStream(), "[INFO]", System.out);
                infoStreamPrinter.start();
            }
            if (p != null) {
                boolean infoStreamPrinter = p.waitFor() == 0;
                return infoStreamPrinter;
            }
        }
        catch (SecurityException e2) {
            System.err.println("[ERROR] SecurityException during exec() of compiler \"" + args2[0] + "\".");
        }
        catch (InterruptedException e3) {
        }
        catch (IOException e4) {
            System.err.print("[ERROR] IOException during exec() of compiler \"" + args2[0] + "\"");
            System.err.println(". Check your path environment variable.");
        }
        finally {
            if (tmpFile != null && tmpFile.exists()) {
                FileUtils.delete(tmpFile);
            }
        }
        return false;
    }

    private boolean isLongCommandLines(String[] args2) {
        StringBuilder strBuffer = new StringBuilder();
        for (int i = 0; i < args2.length; ++i) {
            strBuffer.append(args2[i]);
        }
        return strBuffer.toString().length() > 4096;
    }
}

