/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.common.util;

import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModCountCopyOnWriteArrayList<T>
extends CopyOnWriteArrayList<T> {
    AtomicInteger modCount = new AtomicInteger();

    public ModCountCopyOnWriteArrayList() {
    }

    public ModCountCopyOnWriteArrayList(Collection<? extends T> c2) {
        super(c2);
        if (c2 instanceof ModCountCopyOnWriteArrayList) {
            this.modCount.set(((ModCountCopyOnWriteArrayList)c2).getModCount());
        }
    }

    public int getModCount() {
        return this.modCount.get();
    }

    public void setModCount(int i) {
        this.modCount.set(i);
    }

    @Override
    public void add(int index2, T element2) {
        super.add(index2, element2);
        this.modCount.incrementAndGet();
    }

    @Override
    public boolean add(T element2) {
        if (super.add(element2)) {
            this.modCount.incrementAndGet();
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends T> c2) {
        if (super.addAll(c2)) {
            this.modCount.incrementAndGet();
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(int index2, Collection<? extends T> c2) {
        if (super.addAll(index2, c2)) {
            this.modCount.incrementAndGet();
            return true;
        }
        return false;
    }

    @Override
    public int addAllAbsent(Collection<? extends T> c2) {
        int i = super.addAllAbsent(c2);
        if (i > 0) {
            this.modCount.incrementAndGet();
        }
        return i;
    }

    @Override
    public boolean addIfAbsent(T element2) {
        if (super.addIfAbsent(element2)) {
            this.modCount.incrementAndGet();
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        super.clear();
        this.modCount.incrementAndGet();
    }

    @Override
    public T remove(int index2) {
        Object t2 = super.remove(index2);
        if (t2 != null) {
            this.modCount.incrementAndGet();
        }
        return (T)t2;
    }

    @Override
    public boolean remove(Object o) {
        if (super.remove(o)) {
            this.modCount.incrementAndGet();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection c2) {
        if (super.removeAll(c2)) {
            this.modCount.incrementAndGet();
            return true;
        }
        return false;
    }

    @Override
    public boolean retainAll(Collection c2) {
        if (super.retainAll(c2)) {
            this.modCount.incrementAndGet();
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.modCount.get();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof ModCountCopyOnWriteArrayList) {
            return super.equals(o) && this.modCount.get() == ((ModCountCopyOnWriteArrayList)o).getModCount();
        }
        return false;
    }
}

