/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.common.util;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import org.apache.cxf.common.util.ClassReader;

public class ParamReader
extends ClassReader {
    private String methodName;
    private Map<String, MethodInfo> methods = new HashMap<String, MethodInfo>();
    private Class[] paramTypes;

    public ParamReader(Class c2) throws IOException {
        this(ParamReader.getBytes(c2));
    }

    public ParamReader(byte[] b) throws IOException {
        super(b, ParamReader.findAttributeReaders(ParamReader.class));
        int i;
        if (this.readInt() != -889275714) {
            throw new IOException();
        }
        this.readShort();
        this.readShort();
        this.readCpool();
        this.readShort();
        this.readShort();
        this.readShort();
        int count2 = this.readShort();
        for (i = 0; i < count2; ++i) {
            this.readShort();
        }
        count2 = this.readShort();
        for (i = 0; i < count2; ++i) {
            this.readShort();
            this.readShort();
            this.readShort();
            this.skipAttributes();
        }
        count2 = this.readShort();
        for (i = 0; i < count2; ++i) {
            this.readShort();
            int m = this.readShort();
            String name = this.resolveUtf8(m);
            int d = this.readShort();
            this.methodName = name + this.resolveUtf8(d);
            this.readAttributes();
        }
    }

    public static String[] getParameterNamesFromDebugInfo(Method method) {
        int numParams = method.getParameterTypes().length;
        if (numParams == 0) {
            return null;
        }
        Class<?> c2 = method.getDeclaringClass();
        if (Proxy.isProxyClass(c2)) {
            return null;
        }
        try {
            ParamReader pr = new ParamReader(c2);
            return pr.getParameterNames(method);
        }
        catch (IOException e2) {
            return null;
        }
    }

    public void readCode() throws IOException {
        this.readShort();
        int maxLocals = this.readShort();
        MethodInfo info2 = new MethodInfo(maxLocals);
        if (this.methods != null && this.methodName != null) {
            this.methods.put(this.methodName, info2);
        }
        this.skipFully(this.readInt());
        this.skipFully(8 * this.readShort());
        this.readAttributes();
    }

    public String[] getParameterNames(Constructor ctor) {
        this.paramTypes = ctor.getParameterTypes();
        return this.getParameterNames(ctor, this.paramTypes);
    }

    public String[] getParameterNames(Method method) {
        this.paramTypes = method.getParameterTypes();
        return this.getParameterNames(method, this.paramTypes);
    }

    protected String[] getParameterNames(Member member, Class[] pTypes) {
        MethodInfo info2 = this.methods.get(ParamReader.getSignature(member, pTypes));
        if (info2 != null) {
            String[] paramNames = new String[pTypes.length];
            int j = Modifier.isStatic(member.getModifiers()) ? 0 : 1;
            boolean found2 = false;
            for (int i = 0; i < paramNames.length; ++i) {
                if (info2.names[j] != null) {
                    found2 = true;
                    paramNames[i] = info2.names[j];
                }
                ++j;
                if (pTypes[i] != Double.TYPE && pTypes[i] != Long.TYPE) continue;
                ++j;
            }
            if (found2) {
                return paramNames;
            }
            return null;
        }
        return null;
    }

    private MethodInfo getMethodInfo() {
        MethodInfo info2 = null;
        if (this.methods != null && this.methodName != null) {
            info2 = this.methods.get(this.methodName);
        }
        return info2;
    }

    public void readLocalVariableTable() throws IOException {
        int len2 = this.readShort();
        MethodInfo info2 = this.getMethodInfo();
        for (int j = 0; j < len2; ++j) {
            this.readShort();
            this.readShort();
            int nameIndex = this.readShort();
            this.readShort();
            int index2 = this.readShort();
            if (info2 == null) continue;
            info2.names[index2] = this.resolveUtf8(nameIndex);
        }
    }

    private static class MethodInfo {
        String[] names;

        public MethodInfo(int maxLocals) {
            this.names = new String[maxLocals];
        }
    }
}

