/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.common.util;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionInvokationHandler
implements InvocationHandler {
    private Object target;

    public ReflectionInvokationHandler(Object obj) {
        this.target = obj;
    }

    public Object getTarget() {
        return this.target;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args2) throws Throwable {
        WrapReturn wr = method.getAnnotation(WrapReturn.class);
        try {
            Method m = this.target.getClass().getMethod(method.getName(), method.getParameterTypes());
            m.setAccessible(true);
            return ReflectionInvokationHandler.wrapReturn(wr, m.invoke(this.target, args2));
        }
        catch (NoSuchMethodException e2) {
            for (Method m2 : this.target.getClass().getMethods()) {
                if (!m2.getName().equals(method.getName()) || m2.getParameterTypes().length != method.getParameterTypes().length) continue;
                boolean found2 = true;
                for (int x = 0; x < m2.getParameterTypes().length; ++x) {
                    if (args2[x] == null || m2.getParameterTypes()[x].isInstance(args2[x])) continue;
                    found2 = false;
                }
                if (!found2) continue;
                m2.setAccessible(true);
                return ReflectionInvokationHandler.wrapReturn(wr, m2.invoke(this.target, args2));
            }
            throw e2;
        }
    }

    private static Object wrapReturn(WrapReturn wr, Object t2) {
        if (wr == null || t2 == null) {
            return t2;
        }
        if (wr.iterator()) {
            return new WrapperIterator(wr.value(), (Iterator)t2);
        }
        return ReflectionInvokationHandler.createProxyWrapper(t2, wr.value());
    }

    public static final <T> T createProxyWrapper(Object target2, Class<T> inf) {
        ReflectionInvokationHandler h = new ReflectionInvokationHandler(target2);
        return inf.cast(Proxy.newProxyInstance(inf.getClassLoader(), new Class[]{inf}, (InvocationHandler)h));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WrapperIterator
    implements Iterator {
        Class<?> cls;
        Iterator internal;

        public WrapperIterator(Class<?> c2, Iterator it) {
            this.internal = it;
            this.cls = c2;
        }

        @Override
        public boolean hasNext() {
            return this.internal.hasNext();
        }

        public Object next() {
            Object obj = this.internal.next();
            return ReflectionInvokationHandler.createProxyWrapper(obj, this.cls);
        }

        @Override
        public void remove() {
            this.internal.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface WrapReturn {
        public Class<?> value();

        public boolean iterator() default false;
    }
}

