/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.common.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StringUtils {
    private StringUtils() {
    }

    public static String extract(String string2, String startToken, String endToken) {
        int start2 = string2.indexOf(startToken) + startToken.length();
        int end2 = string2.lastIndexOf(endToken);
        if (start2 == -1 || end2 == -1) {
            return null;
        }
        return string2.substring(start2, end2);
    }

    public static String wrapper(String string2, String startToken, String endToken) {
        StringBuilder sb = new StringBuilder();
        sb.append(startToken);
        sb.append(string2);
        sb.append(endToken);
        return sb.toString();
    }

    public static boolean isFileExist(String file) {
        return new File(file).exists() && new File(file).isFile();
    }

    public static boolean isFileAbsolute(String file) {
        return StringUtils.isFileExist(file) && new File(file).isAbsolute();
    }

    public static URL getURL(String spec2) throws MalformedURLException {
        try {
            return new URL(spec2);
        }
        catch (MalformedURLException e2) {
            return new File(spec2).toURI().toURL();
        }
    }

    public static boolean isEmpty(String str) {
        if (str != null) {
            int len2 = str.length();
            for (int x = 0; x < len2; ++x) {
                if (str.charAt(x) <= ' ') continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isEmpty(List<String> list2) {
        if (list2 == null || list2.size() == 0) {
            return true;
        }
        return list2.size() == 1 && StringUtils.isEmpty(list2.get(0));
    }

    public static boolean isEqualUri(String uri1, String uri2) {
        if (uri1.substring(uri1.length() - 1).equals("/") && !uri2.substring(uri2.length() - 1).equals("/")) {
            return uri1.substring(0, uri1.length() - 1).equals(uri2);
        }
        if (uri2.substring(uri2.length() - 1).equals("/") && !uri1.substring(uri1.length() - 1).equals("/")) {
            return uri2.substring(0, uri2.length() - 1).equals(uri1);
        }
        return uri1.equals(uri2);
    }

    public static String diff(String str1, String str2) {
        int index2 = str1.lastIndexOf(str2);
        if (index2 > -1) {
            return str1.substring(str2.length());
        }
        return str1;
    }

    public static List<String> getParts(String str, String sperator) {
        ArrayList<String> ret = new ArrayList<String>();
        List<String> parts = Arrays.asList(str.split("/"));
        for (String part : parts) {
            if (StringUtils.isEmpty(part)) continue;
            ret.add(part);
        }
        return ret;
    }

    public static String getFirstNotEmpty(String str, String sperator) {
        List<String> parts = Arrays.asList(str.split("/"));
        for (String part : parts) {
            if (StringUtils.isEmpty(part)) continue;
            return part;
        }
        return str;
    }

    public static String getFirstNotEmpty(List<String> list2) {
        if (StringUtils.isEmpty(list2)) {
            return null;
        }
        for (String item : list2) {
            if (StringUtils.isEmpty(item)) continue;
            return item;
        }
        return null;
    }

    public static List<String> getFound(String contents, String regex) {
        if (StringUtils.isEmpty(regex) || StringUtils.isEmpty(contents)) {
            return null;
        }
        ArrayList<String> results2 = new ArrayList<String>();
        Pattern pattern = Pattern.compile(regex, 64);
        Matcher matcher2 = pattern.matcher(contents);
        while (matcher2.find()) {
            if (matcher2.groupCount() > 0) {
                results2.add(matcher2.group(1));
                continue;
            }
            results2.add(matcher2.group());
        }
        return results2;
    }

    public static String getFirstFound(String contents, String regex) {
        List<String> founds = StringUtils.getFound(contents, regex);
        if (StringUtils.isEmpty(founds)) {
            return null;
        }
        return founds.get(0);
    }

    public static String formatVersionNumber(String target2) {
        List<String> found2 = StringUtils.getFound(target2, "\\d+\\.\\d+\\.?\\d*");
        if (StringUtils.isEmpty(found2)) {
            return target2;
        }
        return StringUtils.getFirstNotEmpty(found2);
    }

    public static String addDefaultPortIfMissing(String urlString) {
        return StringUtils.addDefaultPortIfMissing(urlString, "80");
    }

    public static String addDefaultPortIfMissing(String urlString, String defaultPort) {
        URL url = null;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e2) {
            return urlString;
        }
        if (url.getPort() != -1) {
            return urlString;
        }
        String regex = "http://([^/]+)";
        String found2 = StringUtils.getFirstFound(urlString, regex);
        String replacer = "http://" + found2 + ":" + defaultPort;
        if (!StringUtils.isEmpty(found2)) {
            urlString = urlString.replaceFirst(regex, replacer);
        }
        return urlString;
    }

    public static String capitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    public static String uncapitalize(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        return new StringBuilder(str.length()).append(Character.toLowerCase(str.charAt(0))).append(str.substring(1)).toString();
    }
}

