/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.common.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;

public final class UrlUtils {
    private static final Logger LOG = LogUtils.getL7dLogger(UrlUtils.class);
    private static final String[] RESERVED_CHARS = new String[]{"+"};
    private static final String[] ENCODED_CHARS = new String[]{"%2b"};

    private UrlUtils() {
    }

    public static String urlDecode(String value2) {
        try {
            value2 = URLDecoder.decode(value2, "UTF-8");
        }
        catch (UnsupportedEncodingException e2) {
            LOG.warning("UTF-8 encoding can not be used to decode " + value2);
        }
        return value2;
    }

    public static String pathDecode(String value2) {
        for (int i = 0; i < RESERVED_CHARS.length; ++i) {
            if (value2.indexOf(RESERVED_CHARS[i]) == -1) continue;
            value2 = value2.replace(RESERVED_CHARS[i], ENCODED_CHARS[i]);
        }
        return UrlUtils.urlDecode(value2);
    }
}

