/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.common.xmlschema;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.xmlschema.SchemaCollection;
import org.apache.cxf.common.xmlschema.UnsupportedConstruct;
import org.apache.cxf.common.xmlschema.XmlSchemaInvalidOperation;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaAnnotated;
import org.apache.ws.commons.schema.XmlSchemaAny;
import org.apache.ws.commons.schema.XmlSchemaAnyAttribute;
import org.apache.ws.commons.schema.XmlSchemaAttribute;
import org.apache.ws.commons.schema.XmlSchemaAttributeOrGroupRef;
import org.apache.ws.commons.schema.XmlSchemaComplexContentExtension;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaContent;
import org.apache.ws.commons.schema.XmlSchemaContentModel;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaEnumerationFacet;
import org.apache.ws.commons.schema.XmlSchemaExternal;
import org.apache.ws.commons.schema.XmlSchemaFacet;
import org.apache.ws.commons.schema.XmlSchemaForm;
import org.apache.ws.commons.schema.XmlSchemaImport;
import org.apache.ws.commons.schema.XmlSchemaObject;
import org.apache.ws.commons.schema.XmlSchemaParticle;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaSequenceMember;
import org.apache.ws.commons.schema.XmlSchemaSimpleType;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeContent;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeRestriction;
import org.apache.ws.commons.schema.XmlSchemaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XmlSchemaUtils {
    public static final String XSI_NIL = "xsi:nil='true'";
    public static final String XSI_NS_ATTR = "xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'";
    public static final String XSI_NIL_WITH_PREFIX = "xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xsi:nil='true'";
    private static final Logger LOG = LogUtils.getL7dLogger(XmlSchemaUtils.class);
    private static final XmlSchemaSequence EMPTY_SEQUENCE = new XmlSchemaSequence();

    private XmlSchemaUtils() {
    }

    public static void setElementName(XmlSchemaElement element2, String name) {
        if (name != null && element2.isRef() && !element2.getRef().getTargetQName().getLocalPart().equals(name) && (element2.getQName() == null || element2.getQName().getLocalPart().equals(name))) {
            LOG.severe("Attempt to set the name of an element with a reference name.");
            throw new XmlSchemaInvalidOperation("Attempt to set the name of an element with a reference name.");
        }
        element2.setName(name);
    }

    public static void setElementRefName(XmlSchemaElement element2, QName name) {
        if (name != null && (element2.getQName() != null && !element2.getQName().equals(name) || element2.getName() != null && !element2.getName().equals(name.getLocalPart()))) {
            LOG.severe("Attempt to set the refName of an element with a name or QName");
            throw new XmlSchemaInvalidOperation("Attempt to set the refName of an element with a name or QName.");
        }
        element2.getRef().setTargetQName(name);
    }

    public static boolean isEumeration(XmlSchemaSimpleType type) {
        XmlSchemaSimpleTypeContent content2 = type.getContent();
        if (!(content2 instanceof XmlSchemaSimpleTypeRestriction)) {
            return false;
        }
        XmlSchemaSimpleTypeRestriction restriction = (XmlSchemaSimpleTypeRestriction)content2;
        List<XmlSchemaFacet> facets = restriction.getFacets();
        for (XmlSchemaFacet facet : facets) {
            if (facet instanceof XmlSchemaEnumerationFacet) continue;
            return false;
        }
        return true;
    }

    public static List<String> enumeratorValues(XmlSchemaSimpleType type) {
        XmlSchemaSimpleTypeContent content2 = type.getContent();
        XmlSchemaSimpleTypeRestriction restriction = (XmlSchemaSimpleTypeRestriction)content2;
        List<XmlSchemaFacet> facets = restriction.getFacets();
        ArrayList<String> values2 = new ArrayList<String>();
        for (XmlSchemaFacet facet : facets) {
            XmlSchemaEnumerationFacet enumFacet = (XmlSchemaEnumerationFacet)facet;
            values2.add(enumFacet.getValue().toString());
        }
        return values2;
    }

    public static boolean schemaImportsNamespace(XmlSchema schema, String namespaceUri) {
        List<XmlSchemaExternal> externals = schema.getExternals();
        for (XmlSchemaExternal what : externals) {
            XmlSchemaImport imp;
            if (!(what instanceof XmlSchemaImport) || !namespaceUri.equals((imp = (XmlSchemaImport)what).getNamespace())) continue;
            return true;
        }
        return false;
    }

    public static void addImportIfNeeded(XmlSchema schema, String namespaceUri) {
        if ("".equals(namespaceUri) || "http://www.w3.org/2001/XMLSchema".equals(namespaceUri) || schema.getTargetNamespace().equals(namespaceUri)) {
            return;
        }
        List<XmlSchemaExternal> externals = schema.getExternals();
        for (XmlSchemaExternal what : externals) {
            XmlSchemaImport imp;
            if (!(what instanceof XmlSchemaImport) || !namespaceUri.equals((imp = (XmlSchemaImport)what).getNamespace())) continue;
            return;
        }
        XmlSchemaImport imp = new XmlSchemaImport(schema);
        imp.setNamespace(namespaceUri);
    }

    public static void addImportIfNeeded(XmlSchema schema, QName qname) {
        if (qname == null) {
            return;
        }
        if (qname.getNamespaceURI() == null) {
            return;
        }
        XmlSchemaUtils.addImportIfNeeded(schema, qname.getNamespaceURI());
    }

    public static XmlSchemaElement findElementByRefName(SchemaCollection xmlSchemaCollection, QName name, String referencingURI) {
        String uri = name.getNamespaceURI();
        if ("".equals(uri)) {
            uri = referencingURI;
        }
        QName copyName = new QName(uri, name.getLocalPart());
        XmlSchemaElement target2 = xmlSchemaCollection.getElementByQName(copyName);
        assert (target2 != null);
        return target2;
    }

    public static QName getBaseType(XmlSchemaComplexType type) {
        XmlSchemaContentModel model = type.getContentModel();
        if (model == null) {
            return null;
        }
        XmlSchemaContent content2 = model.getContent();
        if (content2 == null) {
            return null;
        }
        if (!(content2 instanceof XmlSchemaComplexContentExtension)) {
            return null;
        }
        XmlSchemaComplexContentExtension ext = (XmlSchemaComplexContentExtension)content2;
        return ext.getBaseTypeName();
    }

    public static List<XmlSchemaAttributeOrGroupRef> getContentAttributes(XmlSchemaComplexType type) {
        XmlSchemaContentModel model = type.getContentModel();
        if (model == null) {
            return null;
        }
        XmlSchemaContent content2 = model.getContent();
        if (content2 == null) {
            return null;
        }
        if (!(content2 instanceof XmlSchemaComplexContentExtension)) {
            return null;
        }
        XmlSchemaComplexContentExtension ext = (XmlSchemaComplexContentExtension)content2;
        return ext.getAttributes();
    }

    public static List<XmlSchemaAnnotated> getContentAttributes(XmlSchemaComplexType type, SchemaCollection collection) {
        ArrayList<XmlSchemaAnnotated> results2 = new ArrayList<XmlSchemaAnnotated>();
        QName baseTypeName = XmlSchemaUtils.getBaseType(type);
        if (baseTypeName != null) {
            XmlSchemaComplexType baseType = (XmlSchemaComplexType)collection.getTypeByQName(baseTypeName);
            results2.addAll(XmlSchemaUtils.getContentAttributes(baseType, collection));
            List<XmlSchemaAttributeOrGroupRef> extAttrs = XmlSchemaUtils.getContentAttributes(type);
            results2.addAll(extAttrs);
            return results2;
        }
        List<XmlSchemaAttributeOrGroupRef> attrs = type.getAttributes();
        results2.addAll(attrs);
        return results2;
    }

    public static List<XmlSchemaObject> getContentElements(XmlSchemaComplexType type, SchemaCollection collection) {
        ArrayList<XmlSchemaObject> results2 = new ArrayList<XmlSchemaObject>();
        QName baseTypeName = XmlSchemaUtils.getBaseType(type);
        if (baseTypeName != null) {
            XmlSchemaComplexType baseType = (XmlSchemaComplexType)collection.getTypeByQName(baseTypeName);
            results2.addAll(XmlSchemaUtils.getContentElements(baseType, collection));
            XmlSchemaSequence extSequence = XmlSchemaUtils.getContentSequence(type);
            if (extSequence != null) {
                for (XmlSchemaSequenceMember item : extSequence.getItems()) {
                    results2.add((XmlSchemaObject)((Object)item));
                }
            }
            return results2;
        }
        XmlSchemaSequence sequence2 = XmlSchemaUtils.getSequence(type);
        for (XmlSchemaSequenceMember item : sequence2.getItems()) {
            results2.add((XmlSchemaObject)((Object)item));
        }
        return results2;
    }

    public static XmlSchemaSequence getContentSequence(XmlSchemaComplexType type) {
        XmlSchemaContentModel model = type.getContentModel();
        if (model == null) {
            return null;
        }
        XmlSchemaContent content2 = model.getContent();
        if (content2 == null) {
            return null;
        }
        if (!(content2 instanceof XmlSchemaComplexContentExtension)) {
            return null;
        }
        XmlSchemaComplexContentExtension ext = (XmlSchemaComplexContentExtension)content2;
        XmlSchemaParticle particle = ext.getParticle();
        if (particle == null) {
            return null;
        }
        XmlSchemaSequence sequence2 = null;
        try {
            sequence2 = (XmlSchemaSequence)particle;
        }
        catch (ClassCastException cce) {
            XmlSchemaUtils.unsupportedConstruct("NON_SEQUENCE_PARTICLE", type);
        }
        return sequence2;
    }

    public static QName getElementQualifiedName(XmlSchemaElement element2, XmlSchema schema) {
        if (element2.getQName() != null) {
            return element2.getQName();
        }
        if (element2.getName() != null) {
            return new QName(schema.getTargetNamespace(), element2.getName());
        }
        return null;
    }

    public static XmlSchemaType getElementType(SchemaCollection xmlSchemaCollection, String referencingURI, XmlSchemaElement element2, XmlSchemaType containingType) {
        assert (element2 != null);
        if (element2.getSchemaTypeName() != null) {
            XmlSchemaType type = xmlSchemaCollection.getTypeByQName(element2.getSchemaTypeName());
            if (type == null) {
                Message message = new Message("ELEMENT_TYPE_MISSING", LOG, element2.getQName(), element2.getSchemaTypeName().toString());
                throw new UnsupportedConstruct(message);
            }
            return type;
        }
        if (xmlSchemaCollection.getSchemaByTargetNamespace(referencingURI) == null) {
            referencingURI = null;
        }
        if (referencingURI == null && containingType != null) {
            referencingURI = containingType.getQName().getNamespaceURI();
        }
        XmlSchemaElement originalElement = element2;
        while (element2.getSchemaType() == null && element2.isRef()) {
            XmlSchemaElement nextElement = element2.getRef().getTarget();
            assert (nextElement != null);
            element2 = nextElement;
        }
        if (element2.getSchemaType() == null) {
            XmlSchemaUtils.unsupportedConstruct("ELEMENT_HAS_NO_TYPE", originalElement.getName(), containingType.getQName(), containingType);
        }
        return element2.getSchemaType();
    }

    public static XmlSchemaAnnotated getObjectAnnotated(XmlSchemaObject object, QName contextName) {
        if (!(object instanceof XmlSchemaAnnotated)) {
            XmlSchemaUtils.unsupportedConstruct("NON_ANNOTATED_ATTRIBUTE", object.getClass().getSimpleName(), contextName, object);
        }
        if (!(object instanceof XmlSchemaAttribute) && !(object instanceof XmlSchemaAnyAttribute)) {
            XmlSchemaUtils.unsupportedConstruct("EXOTIC_ATTRIBUTE", object.getClass().getSimpleName(), contextName, object);
        }
        return (XmlSchemaAnnotated)object;
    }

    public static XmlSchemaParticle getObjectParticle(XmlSchemaObject object, QName contextName) {
        if (!(object instanceof XmlSchemaParticle)) {
            XmlSchemaUtils.unsupportedConstruct("NON_PARTICLE_CHILD", object.getClass().getSimpleName(), contextName, object);
        }
        if (!(object instanceof XmlSchemaElement) && !(object instanceof XmlSchemaAny)) {
            XmlSchemaUtils.unsupportedConstruct("GROUP_CHILD", object.getClass().getSimpleName(), contextName, object);
        }
        return (XmlSchemaParticle)object;
    }

    public static XmlSchemaElement getReferredElement(XmlSchemaElement element2, SchemaCollection xmlSchemaCollection) {
        if (element2.isRef()) {
            XmlSchemaElement refElement = element2.getRef().getTarget();
            if (refElement == null) {
                throw new RuntimeException("Dangling reference");
            }
            return refElement;
        }
        return null;
    }

    public static XmlSchemaSequence getSequence(XmlSchemaComplexType type) {
        XmlSchemaParticle particle = type.getParticle();
        XmlSchemaSequence sequence2 = null;
        if (particle == null) {
            return EMPTY_SEQUENCE;
        }
        try {
            sequence2 = (XmlSchemaSequence)particle;
        }
        catch (ClassCastException cce) {
            XmlSchemaUtils.unsupportedConstruct("NON_SEQUENCE_PARTICLE", type);
        }
        return sequence2;
    }

    public static boolean isAttributeNameQualified(XmlSchemaAttribute attribute2, XmlSchema schema) {
        if (attribute2.isRef()) {
            throw new RuntimeException("isElementNameQualified on element with ref=");
        }
        if (attribute2.getForm().equals((Object)XmlSchemaForm.QUALIFIED)) {
            return true;
        }
        if (attribute2.getForm().equals((Object)XmlSchemaForm.UNQUALIFIED)) {
            return false;
        }
        return schema.getAttributeFormDefault().equals((Object)XmlSchemaForm.QUALIFIED);
    }

    public static boolean isAttributeQualified(XmlSchemaAttribute attribute2, boolean global2, XmlSchema localSchema, XmlSchema attributeSchema) {
        if (attribute2.getQName() == null) {
            throw new RuntimeException("getSchemaQualifier on anonymous element.");
        }
        if (attribute2.isRef()) {
            throw new RuntimeException("getSchemaQualified on the 'from' side of ref=.");
        }
        if (global2) {
            return XmlSchemaUtils.isAttributeNameQualified(attribute2, attributeSchema) || localSchema != null && !attribute2.getQName().getNamespaceURI().equals(localSchema.getTargetNamespace());
        }
        return XmlSchemaUtils.isAttributeNameQualified(attribute2, attributeSchema);
    }

    public static boolean isComplexType(XmlSchemaType type) {
        return type instanceof XmlSchemaComplexType;
    }

    public static boolean isElementNameQualified(XmlSchemaElement element2, XmlSchema schema) {
        if (element2.isRef()) {
            throw new RuntimeException("isElementNameQualified on element with ref=");
        }
        if (element2.getForm().equals((Object)XmlSchemaForm.QUALIFIED)) {
            return true;
        }
        if (element2.getForm().equals((Object)XmlSchemaForm.UNQUALIFIED)) {
            return false;
        }
        return schema.getElementFormDefault().equals((Object)XmlSchemaForm.QUALIFIED);
    }

    public static boolean isElementQualified(XmlSchemaElement element2, boolean global2, XmlSchema localSchema, XmlSchema elementSchema) {
        QName qn = XmlSchemaUtils.getElementQualifiedName(element2, localSchema);
        if (qn == null) {
            throw new RuntimeException("isElementQualified on anonymous element.");
        }
        if (element2.isRef()) {
            throw new RuntimeException("isElementQualified on the 'from' side of ref=.");
        }
        if (global2) {
            return XmlSchemaUtils.isElementNameQualified(element2, elementSchema) || localSchema != null && !qn.getNamespaceURI().equals(localSchema.getTargetNamespace());
        }
        return XmlSchemaUtils.isElementNameQualified(element2, elementSchema);
    }

    public static boolean isParticleArray(XmlSchemaParticle particle) {
        return particle.getMaxOccurs() > 1L;
    }

    public static boolean isParticleOptional(XmlSchemaParticle particle) {
        return particle.getMinOccurs() == 0L && particle.getMaxOccurs() == 1L;
    }

    public static void unsupportedConstruct(String messageKey, String what, QName subjectName, XmlSchemaObject subject) {
        Message message = new Message(messageKey, LOG, what, subjectName == null ? "anonymous" : subjectName, XmlSchemaUtils.cleanedUpSchemaSource(subject));
        LOG.severe(message.toString());
        throw new UnsupportedConstruct(message);
    }

    public static void unsupportedConstruct(String messageKey, XmlSchemaType subject) {
        Message message = new Message(messageKey, LOG, subject.getQName(), XmlSchemaUtils.cleanedUpSchemaSource(subject));
        LOG.severe(message.toString());
        throw new UnsupportedConstruct(message);
    }

    public static String cleanedUpSchemaSource(XmlSchemaObject subject) {
        if (subject == null || subject.getSourceURI() == null) {
            return "";
        }
        return subject.getSourceURI() + ":" + subject.getLineNumber();
    }
}

