/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.configuration.jsse.spring;

import java.io.IOException;
import java.io.StringReader;
import java.security.GeneralSecurityException;
import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.configuration.jsse.spring.TLSParameterJaxBUtils;
import org.apache.cxf.configuration.security.TLSClientParametersType;
import org.apache.cxf.jaxb.JAXBContextCache;
import org.apache.cxf.staxutils.StaxUtils;

@NoJSR250Annotations
public final class TLSClientParametersConfig {
    private static Set<Class<?>> classes;
    private static JAXBContext context;

    private TLSClientParametersConfig() {
    }

    private static synchronized JAXBContext getContext() throws JAXBException {
        if (context == null || classes == null) {
            HashSet c2 = new HashSet();
            JAXBContextCache.addPackage(c2, PackageUtils.getPackageName(TLSClientParametersType.class), TLSClientParametersConfig.class.getClassLoader());
            JAXBContextCache.CachedContextAndSchemas ccs = JAXBContextCache.getCachedContextAndSchemas(c2, null, null, null, false);
            classes = ccs.getClasses();
            context = ccs.getContext();
        }
        return context;
    }

    static TLSClientParameters createTLSClientParametersFromType(TLSClientParametersType params2) throws GeneralSecurityException, IOException {
        TLSClientParameters ret = new TLSClientParameters();
        boolean usingDefaults = params2.isUseHttpsURLConnectionDefaultSslSocketFactory();
        if (params2.isDisableCNCheck()) {
            ret.setDisableCNCheck(true);
        }
        if (params2.isUseHttpsURLConnectionDefaultHostnameVerifier()) {
            ret.setUseHttpsURLConnectionDefaultHostnameVerifier(true);
        }
        if (params2.isUseHttpsURLConnectionDefaultSslSocketFactory()) {
            ret.setUseHttpsURLConnectionDefaultSslSocketFactory(true);
        }
        if (params2.isSetSecureSocketProtocol()) {
            ret.setSecureSocketProtocol(params2.getSecureSocketProtocol());
        }
        if (params2.isSetCipherSuitesFilter()) {
            ret.setCipherSuitesFilter(params2.getCipherSuitesFilter());
        }
        if (params2.isSetCipherSuites()) {
            ret.setCipherSuites(params2.getCipherSuites().getCipherSuite());
        }
        if (params2.isSetJsseProvider()) {
            ret.setJsseProvider(params2.getJsseProvider());
        }
        if (params2.isSetSecureRandomParameters() && !usingDefaults) {
            ret.setSecureRandom(TLSParameterJaxBUtils.getSecureRandom(params2.getSecureRandomParameters()));
        }
        if (params2.isSetKeyManagers() && !usingDefaults) {
            ret.setKeyManagers(TLSParameterJaxBUtils.getKeyManagers(params2.getKeyManagers()));
        }
        if (params2.isSetTrustManagers() && !usingDefaults) {
            ret.setTrustManagers(TLSParameterJaxBUtils.getTrustManagers(params2.getTrustManagers()));
        }
        if (params2.isSetCertConstraints()) {
            ret.setCertConstraints(params2.getCertConstraints());
        }
        if (params2.isSetSslCacheTimeout()) {
            ret.setSslCacheTimeout(params2.getSslCacheTimeout());
        }
        return ret;
    }

    public static Object createTLSClientParameters(String s2) {
        StringReader reader2 = new StringReader(s2);
        XMLStreamReader data2 = StaxUtils.createXMLStreamReader(reader2);
        try {
            Unmarshaller u = TLSClientParametersConfig.getContext().createUnmarshaller();
            Object obj = u.unmarshal(data2, TLSClientParametersType.class);
            if (obj instanceof JAXBElement) {
                JAXBElement el = obj;
                obj = el.getValue();
            }
            TLSClientParametersType cpt = (TLSClientParametersType)obj;
            return TLSClientParametersConfig.createTLSClientParametersFromType(cpt);
        }
        catch (RuntimeException e2) {
            throw e2;
        }
        catch (Exception e3) {
            throw new RuntimeException(e3);
        }
    }
}

