/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.configuration.spring;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.spring.BusWiringType;
import org.apache.cxf.configuration.spring.JAXBBeanFactory;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.jaxb.JAXBContextCache;
import org.apache.cxf.staxutils.StaxUtils;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    public static final String WIRE_BUS_ATTRIBUTE = AbstractBeanDefinitionParser.class.getName() + ".wireBus";
    public static final String WIRE_BUS_NAME = AbstractBeanDefinitionParser.class.getName() + ".wireBusName";
    private static final Logger LOG = LogUtils.getL7dLogger(AbstractBeanDefinitionParser.class);
    private Class beanClass;
    private JAXBContext context;
    private Set<Class<?>> classes;

    @Override
    protected void doParse(Element element2, ParserContext ctx, BeanDefinitionBuilder bean) {
        boolean setBus = this.parseAttributes(element2, ctx, bean);
        if (!setBus && this.hasBusProperty()) {
            this.addBusWiringAttribute(bean, BusWiringType.PROPERTY);
        }
        this.parseChildElements(element2, ctx, bean);
    }

    protected boolean parseAttributes(Element element2, ParserContext ctx, BeanDefinitionBuilder bean) {
        NamedNodeMap atts = element2.getAttributes();
        boolean setBus = false;
        for (int i = 0; i < atts.getLength(); ++i) {
            String prefix2;
            Attr node4 = (Attr)atts.item(i);
            String val = node4.getValue();
            String pre = node4.getPrefix();
            String name = node4.getLocalName();
            if (this.isNamespace(name, prefix2 = node4.getPrefix())) continue;
            if ("createdFromAPI".equals(name)) {
                bean.setAbstract(true);
                continue;
            }
            if ("abstract".equals(name)) {
                bean.setAbstract(true);
                continue;
            }
            if ("depends-on".equals(name)) {
                bean.addDependsOn(val);
                continue;
            }
            if ("id".equals(name) || "name".equals(name) || !this.isAttribute(pre, name)) continue;
            if ("bus".equals(name)) {
                if (val == null || val.trim().length() <= 0 || !ctx.getRegistry().containsBeanDefinition(val)) continue;
                bean.addPropertyReference(name, val);
                setBus = true;
                continue;
            }
            this.mapAttribute(bean, element2, name, val);
        }
        return setBus;
    }

    private boolean isNamespace(String name, String prefix2) {
        return "xmlns".equals(prefix2) || prefix2 == null && "xmlns".equals(name);
    }

    protected void parseChildElements(Element element2, ParserContext ctx, BeanDefinitionBuilder bean) {
        Element el = DOMUtils.getFirstElement(element2);
        while (el != null) {
            String name = el.getLocalName();
            this.mapElement(ctx, bean, el, name);
            el = DOMUtils.getNextElement(el);
        }
    }

    public Class getBeanClass() {
        return this.beanClass;
    }

    public void setBeanClass(Class beanClass) {
        this.beanClass = beanClass;
    }

    protected Class getBeanClass(Element e2) {
        return this.beanClass;
    }

    protected void mapAttribute(BeanDefinitionBuilder bean, Element e2, String name, String val) {
        this.mapAttribute(bean, name, val);
    }

    protected void mapAttribute(BeanDefinitionBuilder bean, String name, String val) {
        this.mapToProperty(bean, name, val);
    }

    protected void mapElement(ParserContext ctx, BeanDefinitionBuilder bean, Element e2, String name) {
    }

    @Override
    protected String resolveId(Element elem2, AbstractBeanDefinition definition, ParserContext ctx) throws BeanDefinitionStoreException {
        String id2 = this.getIdOrName(elem2);
        String createdFromAPI = elem2.getAttribute("createdFromAPI");
        if (null == id2 || "".equals(id2)) {
            return super.resolveId(elem2, definition, ctx);
        }
        if (createdFromAPI != null && "true".equals(createdFromAPI.toLowerCase())) {
            return id2 + this.getSuffix();
        }
        return id2;
    }

    protected boolean hasBusProperty() {
        return false;
    }

    protected String getSuffix() {
        return "";
    }

    protected void setFirstChildAsProperty(Element element2, ParserContext ctx, BeanDefinitionBuilder bean, String propertyName) {
        Element first2 = this.getFirstChild(element2);
        if (first2 == null) {
            throw new IllegalStateException(propertyName + " property must have child elements!");
        }
        if (first2.getNamespaceURI().equals("http://www.springframework.org/schema/beans")) {
            String name = first2.getLocalName();
            if ("ref".equals(name)) {
                String id2 = first2.getAttribute("bean");
                if (id2 == null) {
                    throw new IllegalStateException("<ref> elements must have a \"bean\" attribute!");
                }
                bean.addPropertyReference(propertyName, id2);
                return;
            }
            if ("bean".equals(name)) {
                BeanDefinitionHolder bdh = ctx.getDelegate().parseBeanDefinitionElement(first2);
                BeanDefinition child = bdh.getBeanDefinition();
                bean.addPropertyValue(propertyName, child);
                return;
            }
            throw new UnsupportedOperationException("Elements with the name " + name + " are not currently " + "supported as sub elements of " + element2.getLocalName());
        }
        BeanDefinition child = ctx.getDelegate().parseCustomElement(first2, bean.getBeanDefinition());
        bean.addPropertyValue(propertyName, child);
    }

    protected Element getFirstChild(Element element2) {
        return DOMUtils.getFirstElement(element2);
    }

    protected void addBusWiringAttribute(BeanDefinitionBuilder bean, BusWiringType type) {
        this.addBusWiringAttribute(bean, type, null);
    }

    protected void addBusWiringAttribute(BeanDefinitionBuilder bean, BusWiringType type, String busName) {
        LOG.fine("Adding " + WIRE_BUS_ATTRIBUTE + " attribute " + (Object)((Object)type) + " to bean " + bean);
        bean.getRawBeanDefinition().setAttribute(WIRE_BUS_ATTRIBUTE, (Object)type);
        if (busName != null) {
            bean.getRawBeanDefinition().setAttribute(WIRE_BUS_NAME, busName);
        }
    }

    protected void mapElementToJaxbProperty(Element parent2, BeanDefinitionBuilder bean, QName name, String propertyName) {
        this.mapElementToJaxbProperty(parent2, bean, name, propertyName, null);
    }

    protected void mapElementToJaxbProperty(Element parent2, BeanDefinitionBuilder bean, QName name, String propertyName, Class<?> c2) {
        Element data2 = null;
        for (Node node4 = parent2.getFirstChild(); node4 != null; node4 = node4.getNextSibling()) {
            if (node4.getNodeType() != 1 || !name.getLocalPart().equals(node4.getLocalName()) || !name.getNamespaceURI().equals(node4.getNamespaceURI())) continue;
            data2 = (Element)node4;
            break;
        }
        if (data2 == null) {
            return;
        }
        this.mapElementToJaxbProperty(data2, bean, propertyName, c2);
    }

    private synchronized JAXBContext getContext(Class<?> cls) {
        if (this.context == null || this.classes == null || !this.classes.contains(cls)) {
            try {
                HashSet tmp = new HashSet();
                if (this.classes != null) {
                    tmp.addAll(this.classes);
                }
                JAXBContextCache.addPackage(tmp, this.getJaxbPackage(), cls == null ? this.getClass().getClassLoader() : cls.getClassLoader());
                if (cls != null) {
                    boolean hasOf = false;
                    for (Class clazz2 : tmp) {
                        if (clazz2.getPackage() != cls.getPackage() || !"ObjectFactory".equals(clazz2.getSimpleName())) continue;
                        hasOf = true;
                    }
                    if (!hasOf) {
                        tmp.add(cls);
                    }
                }
                JAXBContextCache.scanPackages(tmp);
                JAXBContextCache.CachedContextAndSchemas ccs = JAXBContextCache.getCachedContextAndSchemas(tmp, null, null, null, false);
                this.classes = ccs.getClasses();
                this.context = ccs.getContext();
            }
            catch (JAXBException e2) {
                throw new RuntimeException(e2);
            }
        }
        return this.context;
    }

    protected void mapElementToJaxbProperty(Element data2, BeanDefinitionBuilder bean, String propertyName, Class<?> c2) {
        try {
            try {
                StringWriter writer = new StringWriter();
                XMLStreamWriter xmlWriter = StaxUtils.createXMLStreamWriter(writer);
                StaxUtils.copy(data2, xmlWriter);
                xmlWriter.flush();
                BeanDefinitionBuilder jaxbbean = BeanDefinitionBuilder.rootBeanDefinition(JAXBBeanFactory.class);
                jaxbbean.getRawBeanDefinition().setFactoryMethodName("createJAXBBean");
                jaxbbean.addConstructorArg(this.getContext(c2));
                jaxbbean.addConstructorArg(writer.toString());
                jaxbbean.addConstructorArg(c2);
                bean.addPropertyValue(propertyName, jaxbbean.getBeanDefinition());
            }
            catch (Exception ex2) {
                Unmarshaller u = this.getContext(c2).createUnmarshaller();
                Object obj = c2 != null ? u.unmarshal((Node)data2, c2) : u.unmarshal((Node)data2);
                if (obj instanceof JAXBElement) {
                    JAXBElement el = (JAXBElement)obj;
                    obj = el.getValue();
                }
                if (obj != null) {
                    bean.addPropertyValue(propertyName, obj);
                }
            }
        }
        catch (JAXBException e2) {
            throw new RuntimeException("Could not parse configuration.", e2);
        }
    }

    public void mapElementToJaxbPropertyFactory(Element data2, BeanDefinitionBuilder bean, String propertyName, Class<?> type, Class<?> factory, String method, Object ... args2) {
        bean.addPropertyValue(propertyName, this.mapElementToJaxbBean(data2, factory, null, type, method, args2));
    }

    public AbstractBeanDefinition mapElementToJaxbBean(Element data2, Class<?> cls, Class<?> factory, String method, Object ... args2) {
        return this.mapElementToJaxbBean(data2, cls, factory, cls, method, args2);
    }

    public AbstractBeanDefinition mapElementToJaxbBean(Element data2, Class<?> cls, Class<?> factory, Class<?> jaxbClass, String method, Object ... args2) {
        StringWriter writer = new StringWriter();
        XMLStreamWriter xmlWriter = StaxUtils.createXMLStreamWriter(writer);
        try {
            StaxUtils.copy(data2, xmlWriter);
            xmlWriter.flush();
        }
        catch (XMLStreamException e2) {
            throw new RuntimeException(e2);
        }
        BeanDefinitionBuilder jaxbbean = BeanDefinitionBuilder.rootBeanDefinition(cls);
        if (factory != null) {
            jaxbbean.getRawBeanDefinition().setFactoryBeanName(factory.getName());
        }
        jaxbbean.getRawBeanDefinition().setFactoryMethodName(method);
        jaxbbean.addConstructorArg(writer.toString());
        jaxbbean.addConstructorArg(this.getContext(jaxbClass));
        if (args2 != null) {
            for (Object o : args2) {
                jaxbbean.addConstructorArg(o);
            }
        }
        return jaxbbean.getBeanDefinition();
    }

    protected static <T> T unmarshalFactoryString(String s2, JAXBContext ctx, Class<T> cls) {
        StringReader reader2 = new StringReader(s2);
        XMLStreamReader data2 = StaxUtils.createXMLStreamReader(reader2);
        try {
            Unmarshaller u = ctx.createUnmarshaller();
            JAXBElement obj = u.unmarshal(data2, cls);
            return cls.cast(obj.getValue());
        }
        catch (RuntimeException e2) {
            throw e2;
        }
        catch (Exception e3) {
            throw new RuntimeException(e3);
        }
    }

    protected String getJaxbPackage() {
        return "";
    }

    protected void mapToProperty(BeanDefinitionBuilder bean, String propertyName, String val) {
        if ("id".equals(propertyName)) {
            return;
        }
        if (StringUtils.hasText(val)) {
            if (val.startsWith("#")) {
                bean.addPropertyReference(propertyName, val.substring(1));
            } else {
                bean.addPropertyValue(propertyName, val);
            }
        }
    }

    protected boolean isAttribute(String pre, String name) {
        return !"xmlns".equals(name) && (pre == null || !pre.equals("xmlns")) && !"abstract".equals(name) && !"lazy-init".equals(name) && !"id".equals(name);
    }

    protected QName parseQName(Element element2, String t2) {
        int colIdx;
        String ns = null;
        String pre = null;
        String local = null;
        if (t2.startsWith("{")) {
            int i = t2.indexOf(125);
            if (i == -1) {
                throw new RuntimeException("Namespace bracket '{' must having a closing bracket '}'.");
            }
            ns = t2.substring(1, i);
            t2 = t2.substring(i + 1);
        }
        if ((colIdx = t2.indexOf(58)) == -1) {
            local = t2;
            pre = "";
            ns = DOMUtils.getNamespace(element2, "");
        } else {
            pre = t2.substring(0, colIdx);
            local = t2.substring(colIdx + 1);
            ns = DOMUtils.getNamespace(element2, pre);
        }
        return new QName(ns, local, pre);
    }

    protected String getIdOrName(Element elem2) {
        StringTokenizer st;
        String names;
        String id2 = elem2.getAttribute("id");
        if ((null == id2 || "".equals(id2)) && null != (names = elem2.getAttribute("name")) && (st = new StringTokenizer(names, ",; ")).countTokens() > 0) {
            id2 = st.nextToken();
        }
        return id2;
    }
}

