/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.configuration.spring;

import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.configuration.spring.AbstractBeanDefinitionParser;
import org.apache.cxf.configuration.spring.BusWiringType;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public abstract class AbstractFactoryBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    private static boolean factoriesAreAbstract = true;

    public static void setFactoriesAreAbstract(boolean b) {
        factoriesAreAbstract = b;
    }

    protected void doParse(Element element2, ParserContext ctx, BeanDefinitionBuilder bean) {
        Class factoryClass = this.getFactoryClass();
        BeanDefinitionBuilder factoryBean = bean;
        if (!FactoryBean.class.isAssignableFrom(factoryClass)) {
            factoryBean = BeanDefinitionBuilder.rootBeanDefinition(this.getFactoryClass());
        }
        NamedNodeMap atts = element2.getAttributes();
        boolean createdFromAPI = false;
        boolean setBus = false;
        for (int i = 0; i < atts.getLength(); ++i) {
            Attr node4 = (Attr)atts.item(i);
            String val = node4.getValue();
            String pre = node4.getPrefix();
            String name = node4.getLocalName();
            if ("createdFromAPI".equals(name)) {
                factoryBean.setAbstract(true);
                bean.setAbstract(true);
                createdFromAPI = true;
                continue;
            }
            if ("abstract".equals(name)) {
                factoryBean.setAbstract(true);
                bean.setAbstract(true);
                continue;
            }
            if ("id".equals(name) || "name".equals(name) || !this.isAttribute(pre, name)) continue;
            if ("bus".equals(name)) {
                setBus = true;
                if (!val.startsWith("#")) {
                    val = "#" + val;
                }
            }
            this.mapAttribute(factoryBean, element2, name, val);
        }
        if (!setBus) {
            this.addBusWiringAttribute(factoryBean, BusWiringType.PROPERTY);
        }
        for (Node node5 = element2.getFirstChild(); node5 != null; node5 = node5.getNextSibling()) {
            if (node5.getNodeType() != 1) continue;
            String name = node5.getLocalName();
            this.mapElement(ctx, factoryBean, (Element)node5, name);
        }
        String id2 = this.getIdOrName(element2);
        BeanDefinition container = ctx.getContainingBeanDefinition();
        boolean noFactory = false;
        if (StringUtils.isEmpty(id2)) {
            if (container == null) {
                id2 = BeanDefinitionReaderUtils.generateBeanName(bean.getBeanDefinition(), ctx.getRegistry(), false);
            } else {
                id2 = BeanDefinitionReaderUtils.generateBeanName(bean.getBeanDefinition(), ctx.getRegistry(), true);
                noFactory = true;
            }
        }
        if (createdFromAPI) {
            id2 = id2 + this.getSuffix();
        }
        if (FactoryBean.class.isAssignableFrom(this.getFactoryClass())) {
            if (!noFactory) {
                AbstractBeanDefinition def = factoryBean.getRawBeanDefinition().cloneBeanDefinition();
                def.setBeanClass(this.getRawFactoryClass());
                def.setAbstract(factoriesAreAbstract);
                def.setLazyInit(true);
                ctx.getRegistry().registerBeanDefinition(id2 + this.getFactoryIdSuffix(), def);
            }
            bean.getBeanDefinition().setAttribute("id", id2);
        } else {
            String factoryId = id2 + this.getFactoryIdSuffix();
            ctx.getRegistry().registerBeanDefinition(factoryId, factoryBean.getBeanDefinition());
            bean.getBeanDefinition().setAttribute("id", id2);
            bean.setFactoryBean(factoryId, "create");
        }
    }

    protected abstract Class getFactoryClass();

    protected Class getRawFactoryClass() {
        return this.getFactoryClass();
    }

    protected abstract String getFactoryIdSuffix();
}

