/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.configuration.spring;

import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.cxf.configuration.spring.MapProvider;
import org.apache.cxf.helpers.CastUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractSpringBeanMap<X, V>
implements ApplicationContextAware,
InitializingBean,
MapProvider<X, V>,
Serializable {
    protected ApplicationContext context;
    protected Class<?> type;
    protected String idsProperty;
    protected String staticFieldName;
    protected Map<X, List<String>> idToBeanName = new ConcurrentHashMap<X, List<String>>();
    protected Map<X, V> putStore = new ConcurrentHashMap<X, V>();

    AbstractSpringBeanMap() {
    }

    @Override
    public void setApplicationContext(ApplicationContext ctx) throws BeansException {
        this.context = ctx;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        this.processBeans(this.context);
    }

    @Override
    public Map<X, V> createMap() {
        return new SpringBeanMapWrapper();
    }

    protected abstract void processBeans(ApplicationContext var1);

    protected synchronized List<String> getBeanListForId(X id2) {
        List<String> lst = this.idToBeanName.get(id2);
        if (lst == null) {
            lst = new CopyOnWriteArrayList<String>();
            this.idToBeanName.put(id2, lst);
        }
        return lst;
    }

    protected Collection<X> getIds(Object bean) {
        try {
            PropertyDescriptor pd = BeanUtils.getPropertyDescriptor(bean.getClass(), this.idsProperty);
            Method method = pd.getReadMethod();
            Object o = method.invoke(bean, new Object[0]);
            if (o instanceof Collection) {
                return CastUtils.cast((Collection)method.invoke(bean, new Object[0]));
            }
            Object[] ar = (Object[])o;
            return Arrays.asList(ar);
        }
        catch (IllegalArgumentException e2) {
            throw new BeanInitializationException("Could not retrieve ids.", e2);
        }
        catch (IllegalAccessException e3) {
            throw new BeanInitializationException("Could not access id getter.", e3);
        }
        catch (InvocationTargetException e4) {
            throw new BeanInitializationException("Could not invoke id getter.", e4);
        }
        catch (SecurityException e5) {
            throw new BeanInitializationException("Could not invoke id getter.", e5);
        }
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Class<?> getType() {
        return this.type;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    public String getIdsProperty() {
        return this.idsProperty;
    }

    public void setIdsProperty(String idsProperty) {
        this.idsProperty = idsProperty;
    }

    public String getStaticFieldName() {
        return this.staticFieldName;
    }

    public void setStaticFieldName(String staticFieldName) {
        this.staticFieldName = staticFieldName;
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public boolean containsKey(Object key) {
        return this.idToBeanName.containsKey(key) || this.putStore.containsKey(key);
    }

    public boolean containsValue(Object arg0) {
        throw new UnsupportedOperationException();
    }

    public Set<Map.Entry<X, V>> entrySet() {
        LinkedHashSet<Map.Entry<X, V>> entries = new LinkedHashSet<Map.Entry<X, V>>();
        for (X k : this.keySet()) {
            entries.add(new Entry(this, k));
        }
        return entries;
    }

    public V get(Object key) {
        List<String> names = this.idToBeanName.get(key);
        if (names != null) {
            for (String name : names) {
                this.context.getBean(name);
            }
            if (this.putStore.containsKey(key)) {
                return this.putStore.get(key);
            }
            Object v = this.context.getBean(names.get(0));
            this.putStore.put(key, v);
            this.idToBeanName.remove(key);
            return (V)v;
        }
        return this.putStore.get(key);
    }

    public boolean isEmpty() {
        return this.idToBeanName.isEmpty() && this.putStore.isEmpty();
    }

    public Set<X> keySet() {
        LinkedHashSet<X> keys2 = new LinkedHashSet<X>();
        keys2.addAll(this.putStore.keySet());
        keys2.addAll(this.idToBeanName.keySet());
        return keys2;
    }

    public V put(X key, V value2) {
        this.idToBeanName.remove(key);
        return this.putStore.put(key, value2);
    }

    public void putAll(Map<? extends X, ? extends V> m) {
        this.putStore.putAll(m);
    }

    public V remove(Object key) {
        V v = this.get(key);
        if (v != null) {
            this.idToBeanName.remove(key);
        } else {
            v = this.putStore.get(key);
        }
        return v;
    }

    public int size() {
        return this.idToBeanName.size() + this.putStore.size();
    }

    public Collection<V> values() {
        ArrayList<V> values2 = new ArrayList<V>();
        values2.addAll(this.putStore.values());
        for (X id2 : this.idToBeanName.keySet()) {
            values2.add(this.get(id2));
        }
        return values2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SpringBeanMapWrapper
    extends ConcurrentHashMap<X, V>
    implements Map<X, V> {
        private SpringBeanMapWrapper() {
        }

        @Override
        public void clear() {
            AbstractSpringBeanMap.this.clear();
        }

        @Override
        public boolean containsKey(Object key) {
            return AbstractSpringBeanMap.this.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value2) {
            return AbstractSpringBeanMap.this.containsValue(value2);
        }

        @Override
        public Set<Map.Entry<X, V>> entrySet() {
            return AbstractSpringBeanMap.this.entrySet();
        }

        @Override
        public V get(Object key) {
            return AbstractSpringBeanMap.this.get(key);
        }

        @Override
        public boolean isEmpty() {
            return AbstractSpringBeanMap.this.isEmpty();
        }

        @Override
        public Set<X> keySet() {
            return AbstractSpringBeanMap.this.keySet();
        }

        @Override
        public V put(X key, V value2) {
            return AbstractSpringBeanMap.this.put(key, value2);
        }

        @Override
        public void putAll(Map<? extends X, ? extends V> t2) {
            AbstractSpringBeanMap.this.putAll(t2);
        }

        @Override
        public V remove(Object key) {
            return AbstractSpringBeanMap.this.remove(key);
        }

        @Override
        public int size() {
            return AbstractSpringBeanMap.this.size();
        }

        @Override
        public Collection<V> values() {
            return AbstractSpringBeanMap.this.values();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Entry<X, V>
    implements Map.Entry<X, V> {
        private AbstractSpringBeanMap<X, V> map;
        private X key;

        public Entry(AbstractSpringBeanMap<X, V> map3, X key) {
            this.map = map3;
            this.key = key;
        }

        @Override
        public X getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.map.get(this.key);
        }

        @Override
        public V setValue(V value2) {
            return this.map.put(this.key, value2);
        }
    }
}

