/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.configuration.spring;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.configuration.spring.AbstractSpringBeanMap;
import org.apache.cxf.helpers.CastUtils;
import org.springframework.beans.Mergeable;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.BeanIsAbstractException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.BeanReference;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NoJSR250Annotations
public class SpringBeanQNameMap<V>
extends AbstractSpringBeanMap<QName, V> {
    @Override
    protected void processBeans(ApplicationContext beanFactory) {
        if (beanFactory == null) {
            return;
        }
        String[] beanNames = beanFactory.getBeanNamesForType(this.type);
        ConfigurableApplicationContext ctxt = (ConfigurableApplicationContext)beanFactory;
        for (int i = 0; i < beanNames.length; ++i) {
            BeanDefinition def = ctxt.getBeanFactory().getBeanDefinition(beanNames[i]);
            if (!beanFactory.isSingleton(beanNames[i]) || def.isAbstract()) continue;
            try {
                ArrayList<Object> ids = null;
                PropertyValue pv2 = def.getPropertyValues().getPropertyValue(this.idsProperty);
                if (pv2 != null) {
                    Object value2 = pv2.getValue();
                    if (!(value2 instanceof Collection)) {
                        throw new RuntimeException("The property " + this.idsProperty + " must be a collection!");
                    }
                    if (value2 instanceof Mergeable) {
                        if (!((Mergeable)value2).isMergeEnabled()) {
                            ids = (ArrayList<Object>)value2;
                        }
                    } else {
                        ids = (Collection)value2;
                    }
                }
                if (ids == null && this.staticFieldName != null) {
                    Class<?> cls = this.context.getType(beanNames[i]);
                    try {
                        Field field2 = cls.getDeclaredField(this.staticFieldName);
                        field2.setAccessible(true);
                        Collection collection = CastUtils.cast((Collection)field2.get(null));
                        if (collection != null) {
                            ids = new ArrayList(collection);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (null != ids) {
                    ArrayList<Object> checked = new ArrayList<Object>(ids.size());
                    for (Object e2 : ids) {
                        if (e2 instanceof QName) {
                            checked.add(e2);
                            continue;
                        }
                        if (e2 instanceof BeanReference) {
                            BeanReference br2 = (BeanReference)e2;
                            Object refId = this.context.getBean(br2.getBeanName());
                            checked.add(refId);
                            continue;
                        }
                        if (!(e2 instanceof BeanDefinitionHolder)) break;
                        BeanDefinitionHolder bdh = (BeanDefinitionHolder)e2;
                        if (!QName.class.getName().equals(bdh.getBeanDefinition().getBeanClassName())) break;
                        try {
                            List<ConstructorArgumentValues.ValueHolder> l = bdh.getBeanDefinition().getConstructorArgumentValues().getGenericArgumentValues();
                            ConstructorArgumentValues.ValueHolder v = l.get(0);
                            TypedStringValue nss = (TypedStringValue)v.getValue();
                            v = l.get(1);
                            TypedStringValue ln = (TypedStringValue)v.getValue();
                            checked.add(new QName(nss.getValue(), ln.getValue()));
                        }
                        catch (Exception ex3) {
                            break;
                        }
                    }
                    ids = checked.size() < ids.size() ? null : checked;
                }
                if (ids == null && (ids = this.getIds(ctxt.getBean(beanNames[i]))) == null) continue;
                for (Object e3 : ids) {
                    QName qName = (QName)e3;
                    this.getBeanListForId(qName).add(beanNames[i]);
                }
                continue;
            }
            catch (BeanIsAbstractException e2) {
                // empty catch block
            }
        }
        this.processBeans(ctxt.getParent());
    }
}

