/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.databinding;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.cxf.databinding.WrapperHelper;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWrapperHelper
implements WrapperHelper {
    public static final Class[] NO_CLASSES = new Class[0];
    public static final Object[] NO_PARAMS = new Object[0];
    protected final Class<?> wrapperType;
    protected final Method[] setMethods;
    protected final Method[] getMethods;
    protected final Field[] fields;

    protected AbstractWrapperHelper(Class<?> wt, Method[] sets, Method[] gets2, Field[] f2) {
        this.setMethods = sets;
        this.getMethods = gets2;
        this.fields = f2;
        this.wrapperType = wt;
    }

    @Override
    public String getSignature() {
        return "" + System.identityHashCode(this);
    }

    protected abstract Object createWrapperObject(Class var1) throws Exception;

    protected abstract Object getWrapperObject(Object var1) throws Exception;

    protected Object getPartObject(int index2, Object object) throws Exception {
        return object;
    }

    protected Object getValue(Method method, Object in2) throws IllegalAccessException, InvocationTargetException {
        return method.invoke(in2, new Object[0]);
    }

    @Override
    public Object createWrapperObject(List<?> lst) throws Fault {
        try {
            Object wrapperObject = this.createWrapperObject(this.wrapperType);
            for (int x = 0; x < this.setMethods.length; ++x) {
                if (this.getMethods[x] == null && this.setMethods[x] == null && this.fields[x] == null) continue;
                Object o = lst.get(x);
                if ((o = this.getPartObject(x, o)) instanceof List && this.getMethods[x] != null) {
                    List col = CastUtils.cast((List)this.getMethods[x].invoke(wrapperObject, new Object[0]));
                    if (col == null) {
                        if (this.setMethods[x] != null) {
                            this.setMethods[x].invoke(wrapperObject, o);
                            continue;
                        }
                        this.fields[x].set(wrapperObject, lst.get(x));
                        continue;
                    }
                    List olst = CastUtils.cast((List)o);
                    col.addAll(olst);
                    continue;
                }
                if (this.setMethods[x] != null) {
                    this.setMethods[x].invoke(wrapperObject, o);
                    continue;
                }
                if (this.fields[x] == null) continue;
                this.fields[x].set(wrapperObject, lst.get(x));
            }
            return wrapperObject;
        }
        catch (Exception ex2) {
            ex2.printStackTrace();
            throw new Fault(ex2.getCause());
        }
    }

    @Override
    public List<Object> getWrapperParts(Object o) throws Fault {
        try {
            Object wrapperObject = this.getWrapperObject(o);
            ArrayList<Object> ret = new ArrayList<Object>(this.getMethods.length);
            for (int x = 0; x < this.getMethods.length; ++x) {
                if (this.getMethods[x] != null) {
                    ret.add(this.getValue(this.getMethods[x], wrapperObject));
                    continue;
                }
                if (this.fields[x] != null) {
                    ret.add(this.fields[x].get(wrapperObject));
                    continue;
                }
                ret.add(null);
            }
            return ret;
        }
        catch (Exception ex2) {
            throw new Fault(ex2.getCause());
        }
    }
}

