/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.databinding.source;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.logging.Logger;
import javax.activation.DataSource;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.databinding.DataReader;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.staxutils.DepthXMLStreamReader;
import org.apache.cxf.staxutils.FragmentStreamReader;
import org.apache.cxf.staxutils.StaxSource;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.staxutils.W3CDOMStreamReader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLStreamDataReader
implements DataReader<XMLStreamReader> {
    private static final Logger LOG = LogUtils.getL7dLogger(XMLStreamDataReader.class);
    private Schema schema;
    private Message message;

    @Override
    public Object read(MessagePartInfo part, XMLStreamReader input2) {
        return this.read((QName)null, input2, (Class)part.getTypeClass());
    }

    @Override
    public Object read(final QName name, XMLStreamReader input2, Class type) {
        if (Source.class.equals((Object)type) && this.message != null) {
            String s2 = (String)this.message.getContextualProperty("source-preferred-format");
            if (StringUtils.isEmpty(s2)) {
                s2 = "sax";
            }
            if ("dom".equalsIgnoreCase(s2)) {
                type = DOMSource.class;
            } else if ("stream".equalsIgnoreCase(s2)) {
                type = StreamSource.class;
            } else if ("sax".equalsIgnoreCase(s2) || "cxf.stax".equalsIgnoreCase(s2)) {
                type = SAXSource.class;
            } else if ("stax".equals(s2)) {
                try {
                    type = ClassLoaderUtils.loadClass("javax.xml.transform.stax.StAXSource", this.getClass());
                }
                catch (ClassNotFoundException e2) {
                    type = SAXSource.class;
                }
            } else {
                type = DOMSource.class;
            }
        }
        try {
            Element dom = null;
            if (this.schema != null) {
                dom = this.validate(input2);
                input2 = StaxUtils.createXMLStreamReader(dom);
            }
            if (type != null) {
                Object o;
                Object retVal = null;
                if (SAXSource.class.isAssignableFrom(type) || StaxSource.class.isAssignableFrom(type)) {
                    retVal = new StaxSource(this.resetForStreaming(input2));
                } else if (StreamSource.class.isAssignableFrom(type)) {
                    retVal = new StreamSource(this.getInputStream(input2));
                } else if (XMLStreamReader.class.isAssignableFrom(type)) {
                    retVal = this.resetForStreaming(input2);
                } else if (Element.class.isAssignableFrom(type)) {
                    retVal = dom == null ? this.read(input2).getNode() : dom;
                } else if (Document.class.isAssignableFrom(type)) {
                    retVal = dom == null ? this.read(input2).getNode() : dom;
                } else if (DataSource.class.isAssignableFrom(type)) {
                    final InputStream ins2 = this.getInputStream(input2);
                    retVal = new DataSource(){

                        public String getContentType() {
                            return "text/xml";
                        }

                        public InputStream getInputStream() throws IOException {
                            return ins2;
                        }

                        public String getName() {
                            return name.toString();
                        }

                        public OutputStream getOutputStream() throws IOException {
                            return null;
                        }
                    };
                } else if ("javax.xml.transform.stax.StAXSource".equals(type.getName()) && (o = this.createStaxSource(input2 = this.resetForStreaming(input2), type)) != null) {
                    retVal = o;
                }
                if (retVal != null) {
                    return retVal;
                }
            }
            return dom == null ? this.read(input2) : new DOMSource(dom);
        }
        catch (IOException e3) {
            throw new Fault("COULD_NOT_READ_XML_STREAM", LOG, (Throwable)e3);
        }
        catch (XMLStreamException e4) {
            throw new Fault("COULD_NOT_READ_XML_STREAM", LOG, (Throwable)e4);
        }
        catch (SAXException e5) {
            throw new Fault("COULD_NOT_READ_XML_STREAM", LOG, (Throwable)e5);
        }
    }

    private Object createStaxSource(XMLStreamReader input2, Class<?> type) {
        try {
            return type.getConstructor(XMLStreamReader.class).newInstance(input2);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private XMLStreamReader resetForStreaming(XMLStreamReader input2) throws XMLStreamException {
        if (this.message != null) {
            this.message.removeContent(XMLStreamReader.class);
            final InputStream ins2 = this.message.getContent(InputStream.class);
            this.message.removeContent(InputStream.class);
            input2 = new FragmentStreamReader(input2, true){
                boolean closed;

                public boolean hasNext() throws XMLStreamException {
                    boolean b = super.hasNext();
                    if (!b && !this.closed) {
                        this.closed = true;
                        try {
                            ins2.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    return b;
                }
            };
        }
        return input2;
    }

    private Element validate(XMLStreamReader input2) throws XMLStreamException, SAXException, IOException {
        DOMSource ds = this.read(input2);
        this.schema.newValidator().validate(ds);
        Node nd = ds.getNode();
        if (nd instanceof Document) {
            return ((Document)nd).getDocumentElement();
        }
        return (Element)ds.getNode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream getInputStream(XMLStreamReader input2) throws XMLStreamException, IOException {
        CachedOutputStream out = new CachedOutputStream();
        try {
            StaxUtils.copy(input2, (OutputStream)out);
            InputStream inputStream = out.getInputStream();
            return inputStream;
        }
        finally {
            out.close();
        }
    }

    public DOMSource read(XMLStreamReader reader2) {
        try {
            XMLStreamReader reader22 = reader2;
            if (reader22 instanceof DepthXMLStreamReader) {
                reader22 = ((DepthXMLStreamReader)reader22).getReader();
            }
            if (reader22 instanceof W3CDOMStreamReader) {
                W3CDOMStreamReader domreader = (W3CDOMStreamReader)reader22;
                DOMSource o = new DOMSource(domreader.getCurrentElement());
                domreader.consumeFrame();
                return o;
            }
            Document document2 = StaxUtils.read(reader2);
            if (reader2.hasNext()) {
                reader2.next();
            }
            return new DOMSource(document2);
        }
        catch (XMLStreamException e2) {
            throw new Fault("COULD_NOT_READ_XML_STREAM", LOG, (Throwable)e2);
        }
    }

    @Override
    public void setSchema(Schema s2) {
        this.schema = s2;
    }

    @Override
    public void setAttachments(Collection<Attachment> attachments) {
    }

    @Override
    public void setProperty(String prop2, Object value2) {
        if (Message.class.getName().equals(prop2)) {
            this.message = (Message)value2;
        }
    }
}

