/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.frontend;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.frontend.MethodDispatcher;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.service.model.BindingOperationInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientProxy
implements InvocationHandler {
    private static final Logger LOG = LogUtils.getL7dLogger(ClientProxy.class);
    protected Client client;
    private Endpoint endpoint;

    public ClientProxy(Client c2) {
        this.endpoint = c2.getEndpoint();
        this.client = c2;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args2) throws Throwable {
        MethodDispatcher dispatcher = (MethodDispatcher)this.endpoint.getService().get(MethodDispatcher.class.getName());
        BindingOperationInfo oi = dispatcher.getBindingOperation(method, this.endpoint);
        if (oi == null) {
            if (method.getDeclaringClass().equals(Object.class)) {
                return method.invoke((Object)this, new Object[0]);
            }
            throw new Fault(new Message("NO_OPERATION_INFO", LOG, method.getName()));
        }
        Object[] params2 = args2;
        if (null == params2) {
            params2 = new Object[]{};
        }
        return this.invokeSync(method, oi, params2);
    }

    public Object invokeSync(Method method, BindingOperationInfo oi, Object[] params2) throws Exception {
        Object[] rawRet = this.client.invoke(oi, params2);
        if (rawRet != null && rawRet.length > 0) {
            return rawRet[0];
        }
        return null;
    }

    public Map<String, Object> getRequestContext() {
        return this.client.getRequestContext();
    }

    public Map<String, Object> getResponseContext() {
        return this.client.getResponseContext();
    }

    public Client getClient() {
        return this.client;
    }

    public static Client getClient(Object o) {
        return ((ClientProxy)Proxy.getInvocationHandler(o)).getClient();
    }
}

