/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.frontend;

import java.io.IOException;
import java.util.List;
import org.apache.cxf.BusException;
import org.apache.cxf.common.util.ClassHelper;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.EndpointException;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.endpoint.ServerImpl;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.frontend.AbstractWSDLBasedEndpointFactory;
import org.apache.cxf.service.factory.FactoryBeanListener;
import org.apache.cxf.service.factory.ReflectionServiceFactoryBean;
import org.apache.cxf.service.factory.ServiceConstructionException;
import org.apache.cxf.service.invoker.BeanInvoker;
import org.apache.cxf.service.invoker.FactoryInvoker;
import org.apache.cxf.service.invoker.Invoker;
import org.apache.cxf.service.invoker.SingletonFactory;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.ConduitInitiatorManager;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.DestinationFactoryManager;
import org.apache.cxf.wsdl11.WSDLEndpointFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerFactoryBean
extends AbstractWSDLBasedEndpointFactory {
    private Server server;
    private boolean start = true;
    private Object serviceBean;
    private List<String> schemaLocations;
    private Invoker invoker;

    public ServerFactoryBean() {
        this(new ReflectionServiceFactoryBean());
    }

    public ServerFactoryBean(ReflectionServiceFactoryBean sbean) {
        super(sbean);
    }

    public String getBeanName() {
        return this.getClass().getName();
    }

    @Override
    protected String detectTransportIdFromAddress(String ad) {
        DestinationFactoryManager dfm;
        DestinationFactory df = this.getDestinationFactory();
        if (df == null && (df = (dfm = this.getBus().getExtension(DestinationFactoryManager.class)).getDestinationFactoryForUri(this.getAddress())) != null) {
            return df.getTransportIds().get(0);
        }
        return null;
    }

    @Override
    protected WSDLEndpointFactory getWSDLEndpointFactory() {
        if (this.destinationFactory == null) {
            try {
                this.destinationFactory = this.getBus().getExtension(DestinationFactoryManager.class).getDestinationFactory(this.transportId);
            }
            catch (Throwable t2) {
                try {
                    ConduitInitiator o = this.getBus().getExtension(ConduitInitiatorManager.class).getConduitInitiator(this.transportId);
                    if (o instanceof WSDLEndpointFactory) {
                        return (WSDLEndpointFactory)((Object)o);
                    }
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
            }
        }
        if (this.destinationFactory instanceof WSDLEndpointFactory) {
            return (WSDLEndpointFactory)((Object)this.destinationFactory);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Server create() {
        ClassLoader orig = Thread.currentThread().getContextClassLoader();
        try {
            try {
                ClassLoader loader;
                if (this.bus != null && (loader = this.bus.getExtension(ClassLoader.class)) != null) {
                    Thread.currentThread().setContextClassLoader(loader);
                }
                if (this.getServiceFactory().getProperties() == null) {
                    this.getServiceFactory().setProperties(this.getProperties());
                } else if (this.getProperties() != null) {
                    this.getServiceFactory().getProperties().putAll(this.getProperties());
                }
                if (this.serviceBean != null && this.getServiceClass() == null) {
                    this.setServiceClass(ClassHelper.getRealClass(this.serviceBean));
                }
                if (this.invoker != null) {
                    this.getServiceFactory().setInvoker(this.invoker);
                } else if (this.serviceBean != null) {
                    this.invoker = this.createInvoker();
                    this.getServiceFactory().setInvoker(this.invoker);
                }
                Endpoint ep = this.createEndpoint();
                this.server = new ServerImpl(this.getBus(), ep, this.getDestinationFactory(), this.getBindingFactory());
                if (ep.getService().getInvoker() == null) {
                    if (this.invoker == null) {
                        ep.getService().setInvoker(this.createInvoker());
                    } else {
                        ep.getService().setInvoker(this.invoker);
                    }
                }
            }
            catch (EndpointException e2) {
                throw new ServiceConstructionException(e2);
            }
            catch (BusException e3) {
                throw new ServiceConstructionException(e3);
            }
            catch (IOException e4) {
                throw new ServiceConstructionException(e4);
            }
            if (this.serviceBean != null) {
                this.initializeAnnotationInterceptors(this.server.getEndpoint(), ClassHelper.getRealClass(this.getServiceBean()));
            } else if (this.getServiceClass() != null) {
                this.initializeAnnotationInterceptors(this.server.getEndpoint(), this.getServiceClass());
            }
            this.applyFeatures();
            Object[] objectArray = new Object[3];
            objectArray[0] = this.server;
            objectArray[1] = this.serviceBean;
            objectArray[2] = this.serviceBean == null ? (this.getServiceClass() == null ? this.getServiceFactory().getServiceClass() : this.getServiceClass()) : ClassHelper.getRealClass(this.getServiceBean());
            this.getServiceFactory().sendEvent(FactoryBeanListener.Event.SERVER_CREATED, objectArray);
            if (this.start) {
                this.server.start();
            }
            Server server = this.server;
            return server;
        }
        finally {
            Thread.currentThread().setContextClassLoader(orig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        if (this.getServer() == null) {
            ClassLoader orig = Thread.currentThread().getContextClassLoader();
            try {
                ClassLoader loader;
                if (this.bus != null && (loader = this.bus.getExtension(ClassLoader.class)) != null) {
                    Thread.currentThread().setContextClassLoader(loader);
                }
                this.create();
            }
            finally {
                Thread.currentThread().setContextClassLoader(orig);
            }
        }
    }

    public void destroy() {
        if (this.getServer() != null) {
            this.getServer().destroy();
            this.setServer(null);
        }
    }

    @Override
    protected void initializeServiceFactory() {
        super.initializeServiceFactory();
        this.getServiceFactory().setSchemaLocations(this.schemaLocations);
    }

    protected void applyFeatures() {
        if (this.getFeatures() != null) {
            for (AbstractFeature feature : this.getFeatures()) {
                feature.initialize(this.server, this.getBus());
            }
        }
    }

    protected Invoker createInvoker() {
        if (this.getServiceBean() == null) {
            return new FactoryInvoker(new SingletonFactory(this.getServiceClass()));
        }
        return new BeanInvoker(this.getServiceBean());
    }

    public Server getServer() {
        return this.server;
    }

    public void setServer(Server server) {
        this.server = server;
    }

    public boolean isStart() {
        return this.start;
    }

    public void setStart(boolean start2) {
        this.start = start2;
    }

    public Object getServiceBean() {
        return this.serviceBean;
    }

    public Class<?> getServiceBeanClass() {
        if (this.serviceBean != null) {
            return ClassHelper.getRealClass(this.serviceBean);
        }
        return this.getServiceFactory().getServiceClass();
    }

    public void setServiceBean(Object serviceBean) {
        this.serviceBean = serviceBean;
    }

    public List<String> getSchemaLocations() {
        return this.schemaLocations;
    }

    public void setSchemaLocations(List<String> schemaLocations) {
        this.schemaLocations = schemaLocations;
    }

    public Invoker getInvoker() {
        return this.invoker;
    }

    public void setInvoker(Invoker invoker) {
        this.invoker = invoker;
    }

    public void setWsdlLocation(String location2) {
        this.setWsdlURL(location2);
    }

    public String getWsdlLocation() {
        return this.getWsdlURL();
    }
}

