/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.frontend;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.extensions.schema.SchemaImport;
import javax.wsdl.extensions.schema.SchemaReference;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap12.SOAP12Address;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.Bus;
import org.apache.cxf.catalog.OASISCatalogManager;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.frontend.WSDLQueryException;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.helpers.XMLUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.http.UrlUtilities;
import org.apache.cxf.wsdl.WSDLManager;
import org.apache.cxf.wsdl11.ResourceManagerWSDLLocator;
import org.apache.cxf.wsdl11.ServiceWSDLBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLGetInterceptor
extends AbstractPhaseInterceptor<Message> {
    public static final WSDLGetInterceptor INSTANCE = new WSDLGetInterceptor();
    public static final String AUTO_REWRITE_ADDRESS = "autoRewriteSoapAddress";
    public static final String PUBLISHED_ENDPOINT_URL = "publishedEndpointUrl";
    private static final String WSDLS_KEY = WSDLGetInterceptor.class.getName() + ".WSDLs";
    private static final String SCHEMAS_KEY = WSDLGetInterceptor.class.getName() + ".Schemas";
    private static final Logger LOG = LogUtils.getL7dLogger(WSDLGetInterceptor.class);

    public WSDLGetInterceptor() {
        super("read");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMessage(Message message) throws Fault {
        String method = (String)message.get("org.apache.cxf.request.method");
        String query2 = (String)message.get(Message.QUERY_STRING);
        if (!"GET".equals(method) || StringUtils.isEmpty(query2)) {
            return;
        }
        String baseUri = (String)message.get("org.apache.cxf.request.url");
        String ctx = (String)message.get(Message.PATH_INFO);
        Endpoint endpoint = message.getExchange().getEndpoint();
        synchronized (endpoint) {
            Map<String, String> map3 = UrlUtilities.parseQueryString(query2);
            if (this.isRecognizedQuery(map3, baseUri, ctx, message.getExchange().getEndpoint().getEndpointInfo())) {
                try {
                    Conduit c2 = message.getExchange().getDestination().getBackChannel(message, null, null);
                    MessageImpl mout = new MessageImpl();
                    mout.setExchange(message.getExchange());
                    message.getExchange().setOutMessage(mout);
                    mout.put("Content-Type", "text/xml");
                    c2.prepare(mout);
                    OutputStream os2 = mout.getContent(OutputStream.class);
                    this.writeResponse(message, baseUri, map3, ctx, message.getExchange().getEndpoint().getEndpointInfo(), os2);
                    os2.close();
                    message.getInterceptorChain().abort();
                }
                catch (IOException e2) {
                    throw new Fault(e2);
                }
                finally {
                    message.getExchange().setOutMessage(null);
                }
            }
        }
    }

    public boolean isRecognizedQuery(Map<String, String> map3, String baseUri, String ctx, EndpointInfo endpointInfo) {
        return map3.containsKey("wsdl") || map3.containsKey("xsd");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeResponse(Message message, String base, Map<String, String> params2, String ctxUri, EndpointInfo endpointInfo, OutputStream os2) {
        try {
            Document doc;
            String xsd;
            String wsdl;
            Bus bus = message.getExchange().getBus();
            Object prop2 = message.getContextualProperty(PUBLISHED_ENDPOINT_URL);
            if (prop2 != null) {
                base = String.valueOf(prop2);
            }
            if ((wsdl = params2.get("wsdl")) != null) {
                wsdl = URLDecoder.decode(wsdl, "utf-8");
            }
            if ((xsd = params2.get("xsd")) != null) {
                xsd = URLDecoder.decode(xsd, "utf-8");
            }
            Map<String, Definition> mp = CastUtils.cast((Map)endpointInfo.getService().getProperty(WSDLS_KEY));
            Map<String, SchemaReference> smp = CastUtils.cast((Map)endpointInfo.getService().getProperty(SCHEMAS_KEY));
            if (mp == null) {
                endpointInfo.getService().setProperty(WSDLS_KEY, new ConcurrentHashMap());
                mp = CastUtils.cast((Map)endpointInfo.getService().getProperty(WSDLS_KEY));
            }
            if (smp == null) {
                endpointInfo.getService().setProperty(SCHEMAS_KEY, new ConcurrentHashMap());
                smp = CastUtils.cast((Map)endpointInfo.getService().getProperty(SCHEMAS_KEY));
            }
            if (!mp.containsKey("")) {
                Definition def = new ServiceWSDLBuilder(bus, endpointInfo.getService()).build();
                mp.put("", def);
                this.updateDefinition(bus, def, mp, smp, base, endpointInfo);
            }
            if (xsd == null) {
                Object wsdl2;
                Definition def = (Definition)mp.get(wsdl);
                if (def == null && (wsdl2 = WSDLGetInterceptor.resolveWithCatalogs(OASISCatalogManager.getCatalogManager(bus), wsdl, base)) != null) {
                    def = (Definition)mp.get(wsdl2);
                }
                if (def == null) {
                    throw new WSDLQueryException(new org.apache.cxf.common.i18n.Message("WSDL_NOT_FOUND", LOG, wsdl), null);
                }
                wsdl2 = def;
                synchronized (wsdl2) {
                    if (endpointInfo.getProperty(PUBLISHED_ENDPOINT_URL) != null) {
                        String epurl = String.valueOf(endpointInfo.getProperty(PUBLISHED_ENDPOINT_URL));
                        this.updatePublishedEndpointUrl(epurl, def, endpointInfo.getName());
                        base = epurl;
                    }
                    WSDLWriter wsdlWriter = bus.getExtension(WSDLManager.class).getWSDLFactory().newWSDLWriter();
                    def.setExtensionRegistry(bus.getExtension(WSDLManager.class).getExtensionRegistry());
                    doc = wsdlWriter.getDocument(def);
                }
            } else {
                String xsd2;
                SchemaReference si = (SchemaReference)smp.get(xsd);
                if (si == null && (xsd2 = WSDLGetInterceptor.resolveWithCatalogs(OASISCatalogManager.getCatalogManager(bus), xsd, base)) != null) {
                    si = (SchemaReference)smp.get(xsd2);
                }
                if (si == null) {
                    throw new WSDLQueryException(new org.apache.cxf.common.i18n.Message("SCHEMA_NOT_FOUND", LOG, wsdl), null);
                }
                String uri = si.getReferencedSchema().getDocumentBaseURI();
                uri = WSDLGetInterceptor.resolveWithCatalogs(OASISCatalogManager.getCatalogManager(bus), uri, si.getReferencedSchema().getDocumentBaseURI());
                if (uri == null) {
                    uri = si.getReferencedSchema().getDocumentBaseURI();
                }
                ResourceManagerWSDLLocator rml = new ResourceManagerWSDLLocator(uri, bus);
                InputSource src = rml.getBaseInputSource();
                doc = XMLUtils.getParser().parse(src);
            }
            this.updateDoc(doc, base, mp, smp, message);
            String enc = null;
            try {
                enc = doc.getXmlEncoding();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            if (enc == null) {
                enc = "utf-8";
            }
            XMLStreamWriter writer = StaxUtils.createXMLStreamWriter(os2, enc);
            StaxUtils.writeNode(doc, writer, true);
            writer.flush();
        }
        catch (WSDLQueryException wex) {
            throw wex;
        }
        catch (Exception wex) {
            throw new WSDLQueryException(new org.apache.cxf.common.i18n.Message("COULD_NOT_PROVIDE_WSDL", LOG, base), (Throwable)wex);
        }
    }

    protected void updateDoc(Document doc, String base, Map<String, Definition> mp, Map<String, SchemaReference> smp, Message message) {
        List<Element> elementList = null;
        Object rewriteSoapAddress = message.getContextualProperty(AUTO_REWRITE_ADDRESS);
        try {
            String sl;
            elementList = DOMUtils.findAllElementsByTagNameNS(doc.getDocumentElement(), "http://www.w3.org/2001/XMLSchema", "import");
            for (Element el : elementList) {
                sl = el.getAttribute("schemaLocation");
                if (!smp.containsKey(URLDecoder.decode(sl, "utf-8"))) continue;
                el.setAttribute("schemaLocation", base + "?xsd=" + sl.replace(" ", "%20"));
            }
            elementList = DOMUtils.findAllElementsByTagNameNS(doc.getDocumentElement(), "http://www.w3.org/2001/XMLSchema", "include");
            for (Element el : elementList) {
                sl = el.getAttribute("schemaLocation");
                if (!smp.containsKey(URLDecoder.decode(sl, "utf-8"))) continue;
                el.setAttribute("schemaLocation", base + "?xsd=" + sl.replace(" ", "%20"));
            }
            elementList = DOMUtils.findAllElementsByTagNameNS(doc.getDocumentElement(), "http://www.w3.org/2001/XMLSchema", "redefine");
            for (Element el : elementList) {
                sl = el.getAttribute("schemaLocation");
                if (!smp.containsKey(URLDecoder.decode(sl, "utf-8"))) continue;
                el.setAttribute("schemaLocation", base + "?xsd=" + sl.replace(" ", "%20"));
            }
            elementList = DOMUtils.findAllElementsByTagNameNS(doc.getDocumentElement(), "http://schemas.xmlsoap.org/wsdl/", "import");
            for (Element el : elementList) {
                sl = el.getAttribute("location");
                if (!mp.containsKey(URLDecoder.decode(sl, "utf-8"))) continue;
                el.setAttribute("location", base + "?wsdl=" + sl.replace(" ", "%20"));
            }
        }
        catch (UnsupportedEncodingException e2) {
            throw new WSDLQueryException(new org.apache.cxf.common.i18n.Message("COULD_NOT_PROVIDE_WSDL", LOG, base), (Throwable)e2);
        }
        if (rewriteSoapAddress == null || MessageUtils.isTrue(rewriteSoapAddress)) {
            List<Element> serviceList = DOMUtils.findAllElementsByTagNameNS(doc.getDocumentElement(), "http://schemas.xmlsoap.org/wsdl/", "service");
            for (Element serviceEl : serviceList) {
                String serviceName = serviceEl.getAttribute("name");
                if (!serviceName.equals(message.getExchange().getService().getName().getLocalPart())) continue;
                elementList = DOMUtils.findAllElementsByTagNameNS(doc.getDocumentElement(), "http://schemas.xmlsoap.org/wsdl/", "port");
                for (Element el : elementList) {
                    String name = el.getAttribute("name");
                    if (!name.equals(message.getExchange().getEndpoint().getEndpointInfo().getName().getLocalPart())) continue;
                    List<Element> sadEls = DOMUtils.findAllElementsByTagNameNS(el, "http://schemas.xmlsoap.org/wsdl/soap/", "address");
                    for (Element soapAddress : sadEls) {
                        soapAddress.setAttribute("location", base);
                    }
                }
            }
        }
        try {
            doc.setXmlStandalone(true);
        }
        catch (Exception ex2) {
            // empty catch block
        }
    }

    static String resolveWithCatalogs(OASISCatalogManager catalogs, String start2, String base) {
        if (catalogs == null) {
            return null;
        }
        String resolvedSchemaLocation = null;
        try {
            resolvedSchemaLocation = catalogs.resolveSystem(start2);
            if (resolvedSchemaLocation == null) {
                resolvedSchemaLocation = catalogs.resolveURI(start2);
            }
            if (resolvedSchemaLocation == null) {
                resolvedSchemaLocation = catalogs.resolvePublic(start2, base);
            }
        }
        catch (Exception ex2) {
            // empty catch block
        }
        return resolvedSchemaLocation;
    }

    protected void updateDefinition(Bus bus, Definition def, Map<String, Definition> done, Map<String, SchemaReference> doneSchemas, String base, EndpointInfo ei) {
        OASISCatalogManager catalogs = OASISCatalogManager.getCatalogManager(bus);
        Collection<List> imports = CastUtils.cast(def.getImports().values());
        for (List lst : imports) {
            List<Import> impLst = CastUtils.cast(lst);
            for (Import imp : impLst) {
                String start2 = imp.getLocationURI();
                String decodedStart = null;
                try {
                    decodedStart = URLDecoder.decode(start2, "utf-8");
                }
                catch (UnsupportedEncodingException e2) {
                    throw new WSDLQueryException(new org.apache.cxf.common.i18n.Message("COULD_NOT_PROVIDE_WSDL", LOG, start2), (Throwable)e2);
                }
                String resolvedSchemaLocation = WSDLGetInterceptor.resolveWithCatalogs(catalogs, start2, base);
                if (resolvedSchemaLocation == null) {
                    try {
                        new URL(start2);
                    }
                    catch (MalformedURLException e3) {
                        if (done.put(decodedStart, imp.getDefinition()) != null) continue;
                        this.updateDefinition(bus, imp.getDefinition(), done, doneSchemas, base, ei);
                    }
                    continue;
                }
                if (done.put(decodedStart, imp.getDefinition()) != null) continue;
                done.put(resolvedSchemaLocation, imp.getDefinition());
                this.updateDefinition(bus, imp.getDefinition(), done, doneSchemas, base, ei);
            }
        }
        Types types2 = def.getTypes();
        if (types2 != null) {
            for (ExtensibilityElement el : CastUtils.cast(types2.getExtensibilityElements(), ExtensibilityElement.class)) {
                if (!(el instanceof Schema)) continue;
                Schema see2 = (Schema)el;
                this.updateSchemaImports(bus, see2, doneSchemas, base);
            }
        }
    }

    protected void updatePublishedEndpointUrl(String publishingUrl, Definition def, QName name) {
        Collection<Service> services = CastUtils.cast(def.getAllServices().values());
        for (Service service : services) {
            Collection<Port> ports = CastUtils.cast(service.getPorts().values());
            if (ports.isEmpty()) continue;
            if (name == null) {
                this.setSoapAddressLocationOn(ports.iterator().next(), publishingUrl);
                break;
            }
            for (Port port : ports) {
                if (!name.getLocalPart().equals(port.getName())) continue;
                this.setSoapAddressLocationOn(port, publishingUrl);
            }
        }
    }

    private void setSoapAddressLocationOn(Port port, String url) {
        List extensions = port.getExtensibilityElements();
        for (Object extension2 : extensions) {
            if (extension2 instanceof SOAP12Address) {
                ((SOAP12Address)extension2).setLocationURI(url);
                continue;
            }
            if (!(extension2 instanceof SOAPAddress)) continue;
            ((SOAPAddress)extension2).setLocationURI(url);
        }
    }

    protected void updateSchemaImports(Bus bus, Schema schema, Map<String, SchemaReference> doneSchemas, String base) {
        OASISCatalogManager catalogs = OASISCatalogManager.getCatalogManager(bus);
        Collection<List> imports = CastUtils.cast(schema.getImports().values());
        for (List lst : imports) {
            List<SchemaImport> impLst = CastUtils.cast(lst);
            for (SchemaImport imp : impLst) {
                String start2 = imp.getSchemaLocationURI();
                if (start2 == null) continue;
                String decodedStart = null;
                try {
                    decodedStart = URLDecoder.decode(start2, "utf-8");
                }
                catch (UnsupportedEncodingException e2) {
                    throw new WSDLQueryException(new org.apache.cxf.common.i18n.Message("COULD_NOT_PROVIDE_WSDL", LOG, start2), (Throwable)e2);
                }
                if (doneSchemas.containsKey(decodedStart)) continue;
                String resolvedSchemaLocation = WSDLGetInterceptor.resolveWithCatalogs(catalogs, start2, base);
                if (resolvedSchemaLocation == null) {
                    try {
                        new URL(start2);
                    }
                    catch (MalformedURLException e3) {
                        if (doneSchemas.put(decodedStart, imp) != null) continue;
                        this.updateSchemaImports(bus, imp.getReferencedSchema(), doneSchemas, base);
                    }
                    continue;
                }
                if (doneSchemas.put(decodedStart, imp) != null) continue;
                doneSchemas.put(resolvedSchemaLocation, imp);
                this.updateSchemaImports(bus, imp.getReferencedSchema(), doneSchemas, base);
            }
        }
        List<SchemaReference> includes2 = CastUtils.cast(schema.getIncludes());
        for (SchemaReference included : includes2) {
            String start3 = included.getSchemaLocationURI();
            if (start3 == null) continue;
            String decodedStart = null;
            try {
                decodedStart = URLDecoder.decode(start3, "utf-8");
            }
            catch (UnsupportedEncodingException e4) {
                throw new WSDLQueryException(new org.apache.cxf.common.i18n.Message("COULD_NOT_PROVIDE_WSDL", LOG, start3), (Throwable)e4);
            }
            String resolvedSchemaLocation = WSDLGetInterceptor.resolveWithCatalogs(catalogs, start3, base);
            if (resolvedSchemaLocation == null) {
                if (doneSchemas.containsKey(decodedStart)) continue;
                try {
                    new URL(start3);
                }
                catch (MalformedURLException e5) {
                    if (doneSchemas.put(decodedStart, included) != null) continue;
                    this.updateSchemaImports(bus, included.getReferencedSchema(), doneSchemas, base);
                }
                continue;
            }
            if (doneSchemas.containsKey(decodedStart) && doneSchemas.containsKey(resolvedSchemaLocation)) continue;
            doneSchemas.put(decodedStart, included);
            doneSchemas.put(resolvedSchemaLocation, included);
            this.updateSchemaImports(bus, included.getReferencedSchema(), doneSchemas, base);
        }
        List<SchemaReference> redefines = CastUtils.cast(schema.getRedefines());
        for (SchemaReference included : redefines) {
            String start4 = included.getSchemaLocationURI();
            if (start4 == null) continue;
            String decodedStart = null;
            try {
                decodedStart = URLDecoder.decode(start4, "utf-8");
            }
            catch (UnsupportedEncodingException e6) {
                throw new WSDLQueryException(new org.apache.cxf.common.i18n.Message("COULD_NOT_PROVIDE_WSDL", LOG, start4), (Throwable)e6);
            }
            String resolvedSchemaLocation = WSDLGetInterceptor.resolveWithCatalogs(catalogs, start4, base);
            if (resolvedSchemaLocation == null) {
                if (doneSchemas.containsKey(decodedStart)) continue;
                try {
                    new URL(start4);
                }
                catch (MalformedURLException e7) {
                    if (doneSchemas.put(decodedStart, included) != null) continue;
                    this.updateSchemaImports(bus, included.getReferencedSchema(), doneSchemas, base);
                }
                continue;
            }
            if (doneSchemas.containsKey(decodedStart) && doneSchemas.containsKey(resolvedSchemaLocation)) continue;
            doneSchemas.put(decodedStart, included);
            doneSchemas.put(resolvedSchemaLocation, included);
            this.updateSchemaImports(bus, included.getReferencedSchema(), doneSchemas, base);
        }
    }
}

