/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.frontend.spring;

import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.cxf.bus.spring.BusWiringBeanFactoryPostProcessor;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.configuration.spring.AbstractBeanDefinitionParser;
import org.apache.cxf.frontend.ServerFactoryBean;
import org.apache.cxf.service.factory.ReflectionServiceFactoryBean;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.w3c.dom.Element;

public class ServerFactoryBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    public ServerFactoryBeanDefinitionParser() {
        this.setBeanClass(SpringServerFactoryBean.class);
    }

    protected void mapAttribute(BeanDefinitionBuilder bean, Element e2, String name, String val) {
        if ("endpointName".equals(name) || "serviceName".equals(name)) {
            QName q = this.parseQName(e2, val);
            bean.addPropertyValue(name, q);
        } else {
            this.mapToProperty(bean, name, val);
        }
    }

    protected void mapElement(ParserContext ctx, BeanDefinitionBuilder bean, Element el, String name) {
        if ("properties".equals(name)) {
            Map map3 = ctx.getDelegate().parseMapElement(el, bean.getBeanDefinition());
            bean.addPropertyValue("properties", map3);
        } else if ("executor".equals(name)) {
            this.setFirstChildAsProperty(el, ctx, bean, "serviceFactory.executor");
        } else if ("invoker".equals(name)) {
            this.setFirstChildAsProperty(el, ctx, bean, "serviceFactory.invoker");
        } else if ("binding".equals(name)) {
            this.setFirstChildAsProperty(el, ctx, bean, "bindingConfig");
        } else if ("inInterceptors".equals(name) || "inFaultInterceptors".equals(name) || "outInterceptors".equals(name) || "outFaultInterceptors".equals(name) || "features".equals(name) || "schemaLocations".equals(name)) {
            List list2 = ctx.getDelegate().parseListElement(el, bean.getBeanDefinition());
            bean.addPropertyValue(name, list2);
        } else {
            this.setFirstChildAsProperty(el, ctx, bean, name);
        }
    }

    protected void doParse(Element element2, ParserContext ctx, BeanDefinitionBuilder bean) {
        super.doParse(element2, ctx, bean);
        bean.setInitMethodName("create");
        bean.setDestroyMethodName("destroy");
        bean.setLazyInit(false);
    }

    protected String resolveId(Element elem2, AbstractBeanDefinition definition, ParserContext ctx) throws BeanDefinitionStoreException {
        String id2 = super.resolveId(elem2, definition, ctx);
        if (StringUtils.isEmpty(id2)) {
            id2 = this.getBeanClass().getName() + "--" + definition.hashCode();
        }
        return id2;
    }

    protected boolean hasBusProperty() {
        return true;
    }

    @NoJSR250Annotations
    public static class SpringServerFactoryBean
    extends ServerFactoryBean
    implements ApplicationContextAware {
        public SpringServerFactoryBean() {
        }

        public SpringServerFactoryBean(ReflectionServiceFactoryBean fact) {
            super(fact);
        }

        public void setApplicationContext(ApplicationContext ctx) throws BeansException {
            if (this.getBus() == null) {
                this.setBus(BusWiringBeanFactoryPostProcessor.addDefaultBus(ctx));
            }
        }
    }
}

