/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.helpers;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.cxf.common.util.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DOMUtils {
    private static final DocumentBuilderFactory FACTORY = DocumentBuilderFactory.newInstance();
    private static DocumentBuilder builder;
    private static final String XMLNAMESPACE = "xmlns";

    private DOMUtils() {
    }

    private static synchronized DocumentBuilder getBuilder() throws ParserConfigurationException {
        if (builder == null) {
            FACTORY.setNamespaceAware(true);
            builder = FACTORY.newDocumentBuilder();
        }
        return builder;
    }

    public static String getAttributeValueEmptyNull(Element e2, String attributeName) {
        Attr node4 = e2.getAttributeNode(attributeName);
        if (node4 == null) {
            return null;
        }
        return node4.getValue();
    }

    public static String getContent(Node n) {
        String s2 = DOMUtils.getRawContent(n);
        if (s2 != null) {
            s2 = s2.trim();
        }
        return s2;
    }

    public static String getRawContent(Node n) {
        if (n == null) {
            return null;
        }
        StringBuilder b = null;
        String s2 = null;
        for (Node n1 = n.getFirstChild(); n1 != null; n1 = n1.getNextSibling()) {
            if (n1.getNodeType() != 3) continue;
            if (b != null) {
                b.append(((Text)n1).getNodeValue());
                continue;
            }
            if (s2 == null) {
                s2 = ((Text)n1).getNodeValue();
                continue;
            }
            b = new StringBuilder(s2).append(((Text)n1).getNodeValue());
            s2 = null;
        }
        if (b != null) {
            return b.toString();
        }
        return s2;
    }

    public static Node getChild(Node parent2, String name) {
        if (parent2 == null) {
            return null;
        }
        Node first2 = parent2.getFirstChild();
        if (first2 == null) {
            return null;
        }
        for (Node node4 = first2; node4 != null; node4 = node4.getNextSibling()) {
            if (node4.getNodeType() != 1) continue;
            if (name != null && name.equals(node4.getNodeName())) {
                return node4;
            }
            if (name != null) continue;
            return node4;
        }
        return null;
    }

    public static String getAttribute(Node element2, String attName) {
        NamedNodeMap attrs = element2.getAttributes();
        if (attrs == null) {
            return null;
        }
        Node attN = attrs.getNamedItem(attName);
        if (attN == null) {
            return null;
        }
        return attN.getNodeValue();
    }

    public static String getAttribute(Element element2, QName attName) {
        Attr attr = StringUtils.isEmpty(attName.getNamespaceURI()) ? element2.getAttributeNode(attName.getLocalPart()) : element2.getAttributeNodeNS(attName.getNamespaceURI(), attName.getLocalPart());
        return attr == null ? null : attr.getValue();
    }

    public static void setAttribute(Node node4, String attName, String val) {
        NamedNodeMap attributes2 = node4.getAttributes();
        Attr attNode = node4.getOwnerDocument().createAttributeNS(null, attName);
        attNode.setNodeValue(val);
        attributes2.setNamedItem(attNode);
    }

    public static void removeAttribute(Node node4, String attName) {
        NamedNodeMap attributes2 = node4.getAttributes();
        attributes2.removeNamedItem(attName);
    }

    public static void setText(Node node4, String val) {
        Node chld = DOMUtils.getChild(node4, 3);
        if (chld == null) {
            Text textN = node4.getOwnerDocument().createTextNode(val);
            node4.appendChild(textN);
            return;
        }
        chld.setNodeValue(val);
    }

    public static Node findChildWithAtt(Node parent2, String elemName, String attName, String attVal) {
        Node child = DOMUtils.getChild(parent2, 1);
        if (attVal == null) {
            while (child != null && (elemName == null || elemName.equals(child.getNodeName())) && DOMUtils.getAttribute(child, attName) != null) {
                child = DOMUtils.getNext(child, elemName, 1);
            }
        } else {
            while (child != null && (elemName == null || elemName.equals(child.getNodeName())) && !attVal.equals(DOMUtils.getAttribute(child, attName))) {
                child = DOMUtils.getNext(child, elemName, 1);
            }
        }
        return child;
    }

    public static String getChildContent(Node parent2, String name) {
        Node first2 = parent2.getFirstChild();
        if (first2 == null) {
            return null;
        }
        for (Node node4 = first2; node4 != null; node4 = node4.getNextSibling()) {
            if (!name.equals(node4.getNodeName())) continue;
            return DOMUtils.getRawContent(node4);
        }
        return null;
    }

    public static QName getElementQName(Element el) {
        return new QName(el.getNamespaceURI(), el.getLocalName());
    }

    public static Element getFirstElement(Node parent2) {
        Node n;
        for (n = parent2.getFirstChild(); n != null && 1 != n.getNodeType(); n = n.getNextSibling()) {
        }
        if (n == null) {
            return null;
        }
        return (Element)n;
    }

    public static Element getNextElement(Element el) {
        for (Node nd = el.getNextSibling(); nd != null; nd = nd.getNextSibling()) {
            if (nd.getNodeType() != 1) continue;
            return (Element)nd;
        }
        return null;
    }

    public static Element getFirstChildWithName(Element parent2, QName q) {
        String ns = q.getNamespaceURI();
        String lp = q.getLocalPart();
        return DOMUtils.getFirstChildWithName(parent2, ns, lp);
    }

    public static Element getFirstChildWithName(Element parent2, String ns, String lp) {
        for (Node n = parent2.getFirstChild(); n != null; n = n.getNextSibling()) {
            String ens;
            if (!(n instanceof Element)) continue;
            Element e2 = (Element)n;
            String string2 = ens = e2.getNamespaceURI() == null ? "" : e2.getNamespaceURI();
            if (!ns.equals(ens) || !lp.equals(e2.getLocalName())) continue;
            return e2;
        }
        return null;
    }

    public static List<Element> getChildrenWithName(Element parent2, String ns, String localName) {
        ArrayList<Element> r = new ArrayList<Element>();
        for (Node n = parent2.getFirstChild(); n != null; n = n.getNextSibling()) {
            String eNs;
            if (!(n instanceof Element)) continue;
            Element e2 = (Element)n;
            String string2 = eNs = e2.getNamespaceURI() == null ? "" : e2.getNamespaceURI();
            if (!ns.equals(eNs) || !localName.equals(e2.getLocalName())) continue;
            r.add(e2);
        }
        return r;
    }

    public static List<Element> getChildrenWithNamespace(Element parent2, String ns) {
        ArrayList<Element> r = new ArrayList<Element>();
        for (Node n = parent2.getFirstChild(); n != null; n = n.getNextSibling()) {
            String eNs;
            if (!(n instanceof Element)) continue;
            Element e2 = (Element)n;
            String string2 = eNs = e2.getNamespaceURI() == null ? "" : e2.getNamespaceURI();
            if (!ns.equals(eNs)) continue;
            r.add(e2);
        }
        return r;
    }

    public static Node getChild(Node parent2, int type) {
        Node n;
        for (n = parent2.getFirstChild(); n != null && type != n.getNodeType(); n = n.getNextSibling()) {
        }
        if (n == null) {
            return null;
        }
        return n;
    }

    public static Node getNext(Node current) {
        String name = current.getNodeName();
        short type = current.getNodeType();
        return DOMUtils.getNext(current, name, type);
    }

    public static Node getNext(Node current, String name, int type) {
        Node first2 = current.getNextSibling();
        if (first2 == null) {
            return null;
        }
        for (Node node4 = first2; node4 != null; node4 = node4.getNextSibling()) {
            if (type >= 0 && node4.getNodeType() != type) continue;
            if (name == null) {
                return node4;
            }
            if (!name.equals(node4.getNodeName())) continue;
            return node4;
        }
        return null;
    }

    public static Document readXml(InputStream is2) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        dbf.setIgnoringComments(false);
        dbf.setIgnoringElementContentWhitespace(true);
        dbf.setNamespaceAware(true);
        DocumentBuilder db = null;
        db = dbf.newDocumentBuilder();
        db.setEntityResolver(new NullResolver());
        return db.parse(is2);
    }

    public static Document readXml(Reader is2) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        dbf.setIgnoringComments(false);
        dbf.setIgnoringElementContentWhitespace(true);
        dbf.setNamespaceAware(true);
        DocumentBuilder db = null;
        db = dbf.newDocumentBuilder();
        db.setEntityResolver(new NullResolver());
        InputSource ips = new InputSource(is2);
        return db.parse(ips);
    }

    public static Document readXml(StreamSource is2) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        dbf.setIgnoringComments(false);
        dbf.setIgnoringElementContentWhitespace(true);
        dbf.setNamespaceAware(true);
        DocumentBuilder db = null;
        db = dbf.newDocumentBuilder();
        db.setEntityResolver(new NullResolver());
        InputSource is22 = new InputSource();
        is22.setSystemId(is2.getSystemId());
        is22.setByteStream(is2.getInputStream());
        is22.setCharacterStream(is2.getReader());
        return db.parse(is22);
    }

    public static void writeXml(Node n, OutputStream os2) throws TransformerException {
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer t2 = tf.newTransformer();
        t2.setOutputProperty("indent", "yes");
        t2.transform(new DOMSource(n), new StreamResult(os2));
    }

    public static DocumentBuilder createDocumentBuilder() {
        try {
            return FACTORY.newDocumentBuilder();
        }
        catch (ParserConfigurationException e2) {
            throw new RuntimeException("Couldn't find a DOM parser.", e2);
        }
    }

    public static Document createDocument() {
        try {
            return DOMUtils.getBuilder().newDocument();
        }
        catch (ParserConfigurationException e2) {
            throw new RuntimeException("Couldn't find a DOM parser.", e2);
        }
    }

    public static String getPrefixRecursive(Element el, String ns) {
        String prefix2 = DOMUtils.getPrefix(el, ns);
        if (prefix2 == null && el.getParentNode() instanceof Element) {
            prefix2 = DOMUtils.getPrefixRecursive((Element)el.getParentNode(), ns);
        }
        return prefix2;
    }

    public static String getPrefix(Element el, String ns) {
        NamedNodeMap atts = el.getAttributes();
        for (int i = 0; i < atts.getLength(); ++i) {
            Node node4 = atts.item(i);
            String name = node4.getNodeName();
            if (!ns.equals(node4.getNodeValue()) || name == null || !XMLNAMESPACE.equals(name) && !name.startsWith("xmlns:")) continue;
            return node4.getLocalName();
        }
        return null;
    }

    public static void getPrefixesRecursive(Element element2, String namespaceUri, List<String> prefixes) {
        DOMUtils.getPrefixes(element2, namespaceUri, prefixes);
        Node parent2 = element2.getParentNode();
        if (parent2 instanceof Element) {
            DOMUtils.getPrefixesRecursive((Element)parent2, namespaceUri, prefixes);
        }
    }

    public static void getPrefixes(Element element2, String namespaceUri, List<String> prefixes) {
        NamedNodeMap atts = element2.getAttributes();
        for (int i = 0; i < atts.getLength(); ++i) {
            Node node4 = atts.item(i);
            String name = node4.getNodeName();
            if (!namespaceUri.equals(node4.getNodeValue()) || name == null || !XMLNAMESPACE.equals(name) && !name.startsWith("xmlns:")) continue;
            prefixes.add(node4.getPrefix());
        }
    }

    public static String createNamespace(Element el, String ns) {
        String p = "ns1";
        int i = 1;
        while (DOMUtils.getPrefix(el, ns) != null) {
            p = "ns" + i;
            ++i;
        }
        DOMUtils.addNamespacePrefix(el, ns, p);
        return p;
    }

    public static String getNamespace(Node node4, String searchPrefix) {
        while (!(node4 instanceof Element)) {
            node4 = node4.getParentNode();
        }
        Element el = (Element)node4;
        NamedNodeMap atts = el.getAttributes();
        for (int i = 0; i < atts.getLength(); ++i) {
            Node currentAttribute = atts.item(i);
            String currentLocalName = currentAttribute.getLocalName();
            String currentPrefix = currentAttribute.getPrefix();
            if (searchPrefix.equals(currentLocalName) && XMLNAMESPACE.equals(currentPrefix)) {
                return currentAttribute.getNodeValue();
            }
            if (!StringUtils.isEmpty(searchPrefix) || !XMLNAMESPACE.equals(currentLocalName) || !StringUtils.isEmpty(currentPrefix)) continue;
            return currentAttribute.getNodeValue();
        }
        Node parent2 = el.getParentNode();
        if (parent2 instanceof Element) {
            return DOMUtils.getNamespace((Element)parent2, searchPrefix);
        }
        return null;
    }

    public static List<Element> findAllElementsByTagNameNS(Element elem2, String nameSpaceURI, String localName) {
        LinkedList<Element> ret = new LinkedList<Element>();
        DOMUtils.findAllElementsByTagNameNS(elem2, nameSpaceURI, localName, ret);
        return ret;
    }

    private static void findAllElementsByTagNameNS(Element el, String nameSpaceURI, String localName, List<Element> elementList) {
        if (localName.equals(el.getLocalName()) && nameSpaceURI.contains(el.getNamespaceURI())) {
            elementList.add(el);
        }
        Element elem2 = DOMUtils.getFirstElement(el);
        while (elem2 != null) {
            DOMUtils.findAllElementsByTagNameNS(elem2, nameSpaceURI, localName, elementList);
            elem2 = DOMUtils.getNextElement(elem2);
        }
    }

    public static List<Element> findAllElementsByTagName(Element elem2, String tagName) {
        LinkedList<Element> ret = new LinkedList<Element>();
        DOMUtils.findAllElementsByTagName(elem2, tagName, ret);
        return ret;
    }

    private static void findAllElementsByTagName(Element el, String tagName, List<Element> elementList) {
        if (tagName.equals(el.getTagName())) {
            elementList.add(el);
        }
        Element elem2 = DOMUtils.getFirstElement(el);
        while (elem2 != null) {
            DOMUtils.findAllElementsByTagName(elem2, tagName, elementList);
            elem2 = DOMUtils.getNextElement(elem2);
        }
    }

    public static boolean hasElementInNS(Element el, String namespace) {
        if (namespace.equals(el.getNamespaceURI())) {
            return true;
        }
        Element elem2 = DOMUtils.getFirstElement(el);
        while (elem2 != null) {
            if (DOMUtils.hasElementInNS(elem2, namespace)) {
                return true;
            }
            elem2 = DOMUtils.getNextElement(elem2);
        }
        return false;
    }

    public static String setNamespace(Element element2, String namespace, String prefix2) {
        String pre = DOMUtils.getPrefixRecursive(element2, namespace);
        if (pre != null) {
            return pre;
        }
        element2.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix2, namespace);
        return prefix2;
    }

    public static void addNamespacePrefix(Element element2, String namespaceUri, String prefix2) {
        element2.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix2, namespaceUri);
    }

    public static class NullResolver
    implements EntityResolver {
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            return new InputSource(new StringReader(""));
        }
    }
}

