/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.helpers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileUtils {
    private static final int RETRY_SLEEP_MILLIS = 10;
    private static File defaultTempDir;

    private FileUtils() {
    }

    public static synchronized File getDefaultTempDir() {
        File f2;
        if (defaultTempDir != null && defaultTempDir.exists()) {
            return defaultTempDir;
        }
        String s2 = null;
        try {
            s2 = System.getProperty(FileUtils.class.getName() + ".TempDirectory");
        }
        catch (SecurityException e2) {
            // empty catch block
        }
        if (s2 != null && (f2 = new File(s2)).mkdirs()) {
            defaultTempDir = f2;
        }
        if (defaultTempDir == null) {
            int x = (int)(Math.random() * 1000000.0);
            s2 = System.getProperty("java.io.tmpdir");
            File checkExists = new File(s2);
            if (!checkExists.exists() || !checkExists.isDirectory()) {
                throw new RuntimeException("The directory " + checkExists.getAbsolutePath() + " does not exist, please set java.io.tempdir" + " to an existing directory");
            }
            if (!checkExists.canWrite()) {
                throw new RuntimeException("The directory " + checkExists.getAbsolutePath() + " is now writable, please set java.io.tempdir" + " to an writable directory");
            }
            File f3 = new File(s2, "cxf-tmp-" + x);
            while (!f3.mkdir()) {
                x = (int)(Math.random() * 1000000.0);
                f3 = new File(s2, "cxf-tmp-" + x);
            }
            defaultTempDir = f3;
            final File f22 = f3;
            Thread hook = new Thread(){

                public void run() {
                    FileUtils.removeDir(f22, true);
                }
            };
            Runtime.getRuntime().addShutdownHook(hook);
        }
        return defaultTempDir;
    }

    public static void mkDir(File dir) {
        boolean result2;
        if (dir == null) {
            throw new RuntimeException("dir attribute is required");
        }
        if (dir.isFile()) {
            throw new RuntimeException("Unable to create directory as a file already exists with that name: " + dir.getAbsolutePath());
        }
        if (!dir.exists() && !(result2 = FileUtils.doMkDirs(dir))) {
            String msg = "Directory " + dir.getAbsolutePath() + " creation was not successful for an unknown reason";
            throw new RuntimeException(msg);
        }
    }

    private static boolean doMkDirs(File f2) {
        if (!f2.mkdirs()) {
            try {
                Thread.sleep(10L);
                return f2.mkdirs();
            }
            catch (InterruptedException ex2) {
                return f2.mkdirs();
            }
        }
        return true;
    }

    public static void removeDir(File d) {
        FileUtils.removeDir(d, false);
    }

    private static void removeDir(File d, boolean inShutdown) {
        String[] list2 = d.list();
        if (list2 == null) {
            list2 = new String[]{};
        }
        for (int i = 0; i < list2.length; ++i) {
            String s2 = list2[i];
            File f2 = new File(d, s2);
            if (f2.isDirectory()) {
                FileUtils.removeDir(f2, inShutdown);
                continue;
            }
            FileUtils.delete(f2, inShutdown);
        }
        FileUtils.delete(d, inShutdown);
    }

    public static void delete(File f2) {
        FileUtils.delete(f2, false);
    }

    public static void delete(File f2, boolean inShutdown) {
        if (!f2.delete()) {
            if (FileUtils.isWindows()) {
                System.gc();
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!f2.delete() && !inShutdown) {
                f2.deleteOnExit();
            }
        }
    }

    private static boolean isWindows() {
        String osName = System.getProperty("os.name").toLowerCase(Locale.US);
        return osName.indexOf("windows") > -1;
    }

    public static File createTempFile(String prefix2, String suffix) throws IOException {
        return FileUtils.createTempFile(prefix2, suffix, null, false);
    }

    public static File createTempFile(String prefix2, String suffix, File parentDir2, boolean deleteOnExit) throws IOException {
        File parent2;
        File result2 = null;
        File file = parent2 = parentDir2 == null ? FileUtils.getDefaultTempDir() : parentDir2;
        if (suffix == null) {
            suffix = ".tmp";
        }
        if (prefix2 == null) {
            prefix2 = "cxf";
        } else if (prefix2.length() < 3) {
            prefix2 = prefix2 + "cxf";
        }
        result2 = File.createTempFile(prefix2, suffix, parent2);
        if (deleteOnExit && parentDir2 != null) {
            result2.deleteOnExit();
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getStringFromFile(File location2) {
        FileInputStream is2 = null;
        String result2 = null;
        is2 = new FileInputStream(location2);
        result2 = FileUtils.normalizeCRLF(is2);
        Object var5_3 = null;
        if (is2 == null) return result2;
        try {
            ((InputStream)is2).close();
            return result2;
        }
        catch (Exception e2) {}
        return result2;
        {
            catch (Exception e3) {
                e3.printStackTrace();
                Object var5_4 = null;
                if (is2 == null) return result2;
                try {
                    ((InputStream)is2).close();
                    return result2;
                }
                catch (Exception e2) {}
                return result2;
            }
        }
        catch (Throwable throwable2) {
            Object var5_5 = null;
            if (is2 == null) throw throwable2;
            try {
                ((InputStream)is2).close();
                throw throwable2;
            }
            catch (Exception e2) {
                // empty catch block
            }
            throw throwable2;
        }
    }

    public static String normalizeCRLF(InputStream instream) {
        BufferedReader in2 = new BufferedReader(new InputStreamReader(instream));
        StringBuilder result2 = new StringBuilder();
        String line = null;
        try {
            line = in2.readLine();
            while (line != null) {
                String[] tok = line.split("\\s");
                for (int x = 0; x < tok.length; ++x) {
                    String token2 = tok[x];
                    result2.append("  " + token2);
                }
                line = in2.readLine();
            }
        }
        catch (Exception ex2) {
            ex2.printStackTrace();
        }
        String rtn = result2.toString();
        rtn = FileUtils.ignoreTokens(rtn, "<!--", "-->");
        rtn = FileUtils.ignoreTokens(rtn, "/*", "*/");
        return rtn;
    }

    private static String ignoreTokens(String contents, String startToken, String endToken) {
        String rtn = contents;
        int headerIndexStart = rtn.indexOf(startToken);
        int headerIndexEnd = rtn.indexOf(endToken);
        if (headerIndexStart != -1 && headerIndexEnd != -1 && headerIndexStart < headerIndexEnd) {
            rtn = rtn.substring(0, headerIndexStart - 1) + rtn.substring(headerIndexEnd + endToken.length() + 1);
        }
        return rtn;
    }

    public static List<File> getFiles(File dir, String pattern) {
        return FileUtils.getFiles(dir, pattern, null);
    }

    public static List<File> getFilesRecurse(File dir, String pattern) {
        return FileUtils.getFilesRecurse(dir, pattern, null);
    }

    public static List<File> getFiles(File dir, String pattern, File exclude2) {
        return FileUtils.getFilesRecurse(dir, Pattern.compile(pattern), exclude2, false, new ArrayList<File>());
    }

    public static List<File> getFilesRecurse(File dir, String pattern, File exclude2) {
        return FileUtils.getFilesRecurse(dir, Pattern.compile(pattern), exclude2, true, new ArrayList<File>());
    }

    private static List<File> getFilesRecurse(File dir, Pattern pattern, File exclude2, boolean rec2, List<File> fileList) {
        for (File file : dir.listFiles()) {
            if (file.equals(exclude2)) continue;
            if (file.isDirectory() && rec2) {
                FileUtils.getFilesRecurse(file, pattern, exclude2, rec2, fileList);
                continue;
            }
            Matcher m = pattern.matcher(file.getName());
            if (!m.matches()) continue;
            fileList.add(file);
        }
        return fileList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readLines(File file) throws Exception {
        if (!file.exists()) {
            return new ArrayList<String>();
        }
        BufferedReader reader2 = new BufferedReader(new FileReader(file));
        ArrayList<String> results2 = new ArrayList<String>();
        try {
            String line = reader2.readLine();
            while (line != null) {
                results2.add(line);
                line = reader2.readLine();
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable2) {
            Object var5_5 = null;
            reader2.close();
            throw throwable2;
        }
        reader2.close();
        return results2;
    }
}

