/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.helpers;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import org.apache.cxf.helpers.LoadingByteArrayOutputStream;

public final class IOUtils {
    public static final Charset UTF8_CHARSET = Charset.forName("utf-8");
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    private IOUtils() {
    }

    public static String newStringFromBytes(byte[] bytes2, String charsetName) {
        try {
            return new String(bytes2, charsetName);
        }
        catch (UnsupportedEncodingException e2) {
            throw new RuntimeException("Impossible failure: Charset.forName(\"" + charsetName + "\") returns invalid name.");
        }
    }

    public static String newStringFromBytes(byte[] bytes2) {
        return IOUtils.newStringFromBytes(bytes2, UTF8_CHARSET.name());
    }

    public static String newStringFromBytes(byte[] bytes2, String charsetName, int start2, int length2) {
        try {
            return new String(bytes2, start2, length2, charsetName);
        }
        catch (UnsupportedEncodingException e2) {
            throw new RuntimeException("Impossible failure: Charset.forName(\"" + charsetName + "\") returns invalid name.");
        }
    }

    public static String newStringFromBytes(byte[] bytes2, int start2, int length2) {
        return IOUtils.newStringFromBytes(bytes2, UTF8_CHARSET.name(), start2, length2);
    }

    public static int copy(InputStream input2, OutputStream output) throws IOException {
        return IOUtils.copy(input2, output, 4096);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copyAndCloseInput(InputStream input2, OutputStream output) throws IOException {
        try {
            int n = IOUtils.copy(input2, output, 4096);
            return n;
        }
        finally {
            input2.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copyAndCloseInput(InputStream input2, OutputStream output, int bufferSize) throws IOException {
        try {
            int n = IOUtils.copy(input2, output, bufferSize);
            return n;
        }
        finally {
            input2.close();
        }
    }

    public static int copy(InputStream input2, OutputStream output, int bufferSize) throws IOException {
        int avail = input2.available();
        if (avail > 262144) {
            avail = 262144;
        }
        if (avail > bufferSize) {
            bufferSize = avail;
        }
        byte[] buffer = new byte[bufferSize];
        int n = 0;
        n = input2.read(buffer);
        int total2 = 0;
        while (-1 != n) {
            if (n == 0) {
                throw new IOException("0 bytes read in violation of InputStream.read(byte[])");
            }
            output.write(buffer, 0, n);
            total2 += n;
            n = input2.read(buffer);
        }
        return total2;
    }

    public static void copy(Reader input2, Writer output, int bufferSize) throws IOException {
        char[] buffer = new char[bufferSize];
        int n = 0;
        n = input2.read(buffer);
        while (-1 != n) {
            if (n == 0) {
                throw new IOException("0 bytes read in violation of InputStream.read(byte[])");
            }
            output.write(buffer, 0, n);
            n = input2.read(buffer);
        }
    }

    public static String toString(InputStream input2) throws IOException {
        return IOUtils.toString(input2, 4096);
    }

    public static String toString(InputStream input2, String charset) throws IOException {
        return IOUtils.toString(input2, 4096, charset);
    }

    public static String toString(InputStream input2, int bufferSize) throws IOException {
        return IOUtils.toString(input2, bufferSize, null);
    }

    public static String toString(InputStream input2, int bufferSize, String charset) throws IOException {
        int avail = input2.available();
        if (avail > bufferSize) {
            bufferSize = avail;
        }
        InputStreamReader reader2 = charset == null ? new InputStreamReader(input2, UTF8_CHARSET) : new InputStreamReader(input2, charset);
        return IOUtils.toString(reader2, bufferSize);
    }

    public static String toString(Reader input2) throws IOException {
        return IOUtils.toString(input2, 4096);
    }

    public static String toString(Reader input2, int bufSize) throws IOException {
        StringBuilder buf = new StringBuilder();
        char[] buffer = new char[bufSize];
        int n = 0;
        n = input2.read(buffer);
        while (-1 != n) {
            if (n == 0) {
                throw new IOException("0 bytes read in violation of InputStream.read(byte[])");
            }
            buf.append(new String(buffer, 0, n));
            n = input2.read(buffer);
        }
        input2.close();
        return buf.toString();
    }

    public static String readStringFromStream(InputStream in2) throws IOException {
        StringBuilder sb = new StringBuilder(1024);
        int i = in2.read();
        while (i != -1) {
            sb.append((char)i);
            i = in2.read();
        }
        in2.close();
        return sb.toString();
    }

    public static ByteArrayInputStream loadIntoBAIS(InputStream in2) throws IOException {
        int i = in2.available();
        if (i < 4096) {
            i = 4096;
        }
        LoadingByteArrayOutputStream bout = new LoadingByteArrayOutputStream(i);
        IOUtils.copy(in2, bout);
        in2.close();
        return bout.createInputStream();
    }

    public static byte[] readBytesFromStream(InputStream in2) throws IOException {
        int i = in2.available();
        if (i < 4096) {
            i = 4096;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream(i);
        IOUtils.copy(in2, bos);
        in2.close();
        return bos.toByteArray();
    }
}

