/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.helpers;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import org.apache.cxf.helpers.DOMUtils;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MapNamespaceContext
implements NamespaceContext {
    private Map<String, String> namespaces = new HashMap<String, String>();
    private Node targetNode;

    public MapNamespaceContext() {
    }

    public MapNamespaceContext(Map<String, String> ns) {
        this();
        this.namespaces = ns;
    }

    public MapNamespaceContext(Node node4) {
        this();
        this.targetNode = node4;
    }

    public void setTargetNode(Node node4) {
        this.targetNode = node4;
    }

    public void addNamespace(String prefix2, String namespaceURI) {
        this.namespaces.put(prefix2, namespaceURI);
    }

    public void addNamespaces(Map<String, String> ns) {
        this.namespaces.putAll(ns);
    }

    @Override
    public String getNamespaceURI(String prefix2) {
        String uri;
        if (null == prefix2) {
            throw new IllegalArgumentException("Null prefix to getNamespaceURI");
        }
        if ("xml".equals(prefix2)) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if ("xmlns".equals(prefix2)) {
            return "http://www.w3.org/2000/xmlns/";
        }
        if (this.targetNode != null && (uri = DOMUtils.getNamespace(this.targetNode, prefix2)) != null) {
            return uri;
        }
        return this.namespaces.get(prefix2);
    }

    @Override
    public String getPrefix(String namespaceURI) {
        if (namespaceURI == null) {
            throw new IllegalArgumentException("Null namespace to getPrefix");
        }
        if ("http://www.w3.org/XML/1998/namespace".equals(namespaceURI)) {
            return "xml";
        }
        if ("http://www.w3.org/2000/xmlns/".equals(namespaceURI)) {
            return "xmlns";
        }
        for (Map.Entry<String, String> e2 : this.namespaces.entrySet()) {
            if (!e2.getValue().equals(namespaceURI)) continue;
            return e2.getKey();
        }
        return null;
    }

    public Iterator getPrefixes(String namespaceURI) {
        return null;
    }

    public Map<String, String> getUsedNamespaces() {
        return this.namespaces;
    }
}

