/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.helpers;

import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.apache.cxf.helpers.JavaUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServiceUtils {
    private ServiceUtils() {
    }

    public static String makeServiceNameFromClassName(Class<?> clazz2) {
        int inner2;
        String name = clazz2.getName();
        int last2 = name.lastIndexOf(".");
        if (last2 != -1) {
            name = name.substring(last2 + 1);
        }
        if ((inner2 = name.lastIndexOf("$")) != -1) {
            name = name.substring(inner2 + 1);
        }
        return name;
    }

    public static QName makeQualifiedNameFromClass(Class<?> clazz2) {
        String namespace = ServiceUtils.makeNamespaceFromClassName(clazz2.getName(), "http");
        String localPart = ServiceUtils.makeServiceNameFromClassName(clazz2);
        return new QName(namespace, localPart);
    }

    public static String getMethodName(Method m) {
        StringBuilder sb = new StringBuilder();
        sb.append(m.getDeclaringClass().getName());
        sb.append('.');
        sb.append(m.getName());
        sb.append('(');
        Class<?>[] params2 = m.getParameterTypes();
        for (int i = 0; i < params2.length; ++i) {
            Class<?> param2 = params2[i];
            sb.append(param2.getName());
            if (i >= params2.length - 1) continue;
            sb.append(", ");
        }
        sb.append(')');
        return sb.toString();
    }

    public static String makeNamespaceFromClassName(String className, String protocol) {
        int index2 = className.lastIndexOf(".");
        if (index2 == -1) {
            return protocol + "://" + "DefaultNamespace";
        }
        String packageName = className.substring(0, index2);
        StringTokenizer st = new StringTokenizer(packageName, ".");
        String[] words2 = new String[st.countTokens()];
        for (int i = 0; i < words2.length; ++i) {
            words2[i] = st.nextToken();
        }
        StringBuilder sb = new StringBuilder(80);
        for (int i = words2.length - 1; i >= 0; --i) {
            String word = words2[i];
            if (i != words2.length - 1) {
                sb.append('.');
            }
            sb.append(word);
        }
        return protocol + "://" + sb.toString() + "/";
    }

    public static String makePackageName(String namespace) {
        String hostname = null;
        String path2 = "";
        try {
            URL u = new URL(namespace);
            hostname = u.getHost();
            path2 = u.getPath();
        }
        catch (MalformedURLException e2) {
            if (namespace.indexOf(":") > -1) {
                hostname = namespace.substring(namespace.indexOf(":") + 1);
                if (hostname.indexOf("/") > -1) {
                    hostname = hostname.substring(0, hostname.indexOf("/"));
                }
            }
            hostname = namespace;
        }
        if (hostname == null) {
            return null;
        }
        hostname = hostname.replace('-', '_');
        if ((path2 = path2.replace('-', '_')).length() > 0 && path2.charAt(path2.length() - 1) == '/') {
            path2 = path2.substring(0, path2.length() - 1);
        }
        StringTokenizer st = new StringTokenizer(hostname, ".:");
        String[] words2 = new String[st.countTokens()];
        for (int i = 0; i < words2.length; ++i) {
            words2[i] = st.nextToken();
        }
        StringBuilder sb = new StringBuilder(namespace.length());
        for (int i = words2.length - 1; i >= 0; --i) {
            ServiceUtils.addWordToPackageBuffer(sb, words2[i], i == words2.length - 1);
        }
        StringTokenizer st2 = new StringTokenizer(path2, "/");
        while (st2.hasMoreTokens()) {
            ServiceUtils.addWordToPackageBuffer(sb, st2.nextToken(), false);
        }
        return sb.toString();
    }

    private static void addWordToPackageBuffer(StringBuilder sb, String word, boolean firstWord) {
        if (JavaUtils.isJavaKeyword(word)) {
            word = JavaUtils.makeNonJavaKeyword(word);
        }
        if (!firstWord) {
            sb.append('.');
        }
        if (Character.isDigit(word.charAt(0))) {
            sb.append('_');
        }
        if (word.indexOf(46) != -1) {
            char[] buf = word.toCharArray();
            for (int i = 0; i < word.length(); ++i) {
                if (buf[i] != '.') continue;
                buf[i] = 95;
            }
            word = new String(buf);
        }
        sb.append(word);
    }
}

